/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.SumBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.SumBucketPipelineAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSumBucketPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testSumBucketPipeline() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        SumBucketPipelineAggregation sumBucketPipelineAggregation = this.aggregations.sumBucket("sum_bucket", "histogram>sum");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation((Aggregation)this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation((PipelineAggregation)sumBucketPipelineAggregation);
            });
            indexingTestHelper.search();
            SumBucketPipelineAggregationResult sumBucketPipelineAggregationResult = (SumBucketPipelineAggregationResult)indexingTestHelper.getAggregationResult((PipelineAggregation)sumBucketPipelineAggregation);
            Assert.assertEquals((String)"Sum priority in buckets", (double)210.0, (double)sumBucketPipelineAggregationResult.getValue(), (double)0.0);
        });
    }
}

