/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.count;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.search.test.util.document.BaseDocumentTestCase;
import org.junit.Test;

public abstract class BaseDocumentCountTestCase
extends BaseDocumentTestCase {
    @Test
    public void testAllWordsInAllDocuments() throws Exception {
        this.assertCount("sixth fifth fourth third second first", 6);
    }

    @Test
    public void testOneWordInAllDocuments() throws Exception {
        this.assertCount("Smith", 6);
    }

    @Test
    public void testOneWordPerDocument() throws Exception {
        this.assertCount("first", 1);
        this.assertCount("second", 1);
        this.assertCount("third", 1);
        this.assertCount("fourth", 1);
        this.assertCount("fifth", 1);
        this.assertCount("sixth", 1);
    }

    protected void assertCount(String keywords, int expectedCount) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.setQuery(this.getQuery(keywords));
            indexingTestHelper.search();
            indexingTestHelper.assertResultCount(expectedCount);
        });
    }

    protected Query getQuery(String keywords) {
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        booleanQueryImpl.add((Query)new MatchQuery("firstName", keywords), BooleanClauseOccur.SHOULD);
        booleanQueryImpl.add((Query)new MatchQuery("lastName", keywords), BooleanClauseOccur.SHOULD);
        return booleanQueryImpl;
    }
}

