/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.filter.groupid;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.search.internal.spi.model.query.contributor.GroupIdQueryPreFilterContributor;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public abstract class BaseGroupIdQueryPreFilterContributorTestCase
extends BaseIndexingTestCase {
    protected static final long INACTIVE_GROUP_ID1 = 4L;
    protected static final long INACTIVE_GROUP_ID2 = 5L;
    @Mock
    protected GroupLocalService groupLocalService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockitoAnnotations.initMocks((Object)this);
        ((GroupLocalService)Mockito.doReturn(Arrays.asList(4L, 5L)).when((Object)this.groupLocalService)).getGroupIds(Mockito.anyLong(), Mockito.eq((boolean)false));
    }

    @Test
    public void testNoEmptyClauses() throws Exception {
        Group group = (Group)Mockito.mock(Group.class);
        long groupId = 11111L;
        ((GroupLocalService)Mockito.doReturn((Object)group).when((Object)this.groupLocalService)).getGroup(groupId);
        ((GroupLocalService)Mockito.doReturn((Object)false).when((Object)this.groupLocalService)).isLiveGroupActive(group);
        this.assertSearch(indexingTestHelper -> indexingTestHelper.define(searchContext -> {
            searchContext.setGroupIds(new long[]{groupId});
            BooleanFilter booleanFilter = (BooleanFilter)this.createFilter((SearchContext)searchContext);
            this.assertEmptyClauses(booleanFilter.getMustBooleanClauses());
            this.assertEmptyClauses(booleanFilter.getMustNotBooleanClauses());
            this.assertEmptyClauses(booleanFilter.getShouldBooleanClauses());
        }));
    }

    @Test
    public void testScopeEverythingWithInactiveGroups() {
        this.addDocuments(1L, 2L, 3L, 4L, 5L);
        this.assertSearch(0L, "[1, 2, 3]");
        ((GroupLocalService)Mockito.verify((Object)this.groupLocalService, (VerificationMode)Mockito.never())).getActiveGroups(Mockito.anyLong(), Mockito.anyBoolean());
    }

    @Test
    public void testScopeSingleGroup() throws Exception {
        Group group = (Group)Mockito.mock(Group.class);
        ((GroupLocalService)Mockito.doReturn((Object)group).when((Object)this.groupLocalService)).getGroup(2L);
        ((GroupLocalService)Mockito.doReturn((Object)true).when((Object)this.groupLocalService)).isLiveGroupActive(group);
        this.addDocuments(1L, 2L, 3L, 4L, 5L);
        this.assertSearch(2L, "[2]");
    }

    protected void addDocuments(long ... groupIds) {
        for (long groupId : groupIds) {
            this.addDocument((Document document) -> {
                document.addKeyword("groupId", groupId);
                document.addKeyword("scopeGroupId", groupId);
            });
        }
    }

    protected void assertEmptyClauses(List<BooleanClause<Filter>> clauses) {
        Assert.assertEquals((String)clauses.toString(), (long)0L, (long)clauses.size());
    }

    protected void assertSearch(long scopeGroupId, String expected) {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> {
                searchContext.setGroupIds(new long[]{scopeGroupId});
                indexingTestHelper.setFilter(this.createFilter((SearchContext)searchContext));
            });
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> DocumentsAssert.assertValuesIgnoreRelevance(searchResponse.getRequestString(), (Stream<com.liferay.portal.search.document.Document>)searchResponse.getDocumentsStream(), "groupId", expected));
        });
    }

    protected Filter createFilter(SearchContext searchContext) {
        GroupIdQueryPreFilterContributor contributor = new GroupIdQueryPreFilterContributor();
        contributor.setGroupLocalService(this.groupLocalService);
        BooleanFilter booleanFilter = new BooleanFilter();
        contributor.contribute(booleanFilter, searchContext);
        return booleanFilter;
    }
}

