/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.groupby;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.search.groupby.GroupByRequest;
import com.liferay.portal.search.groupby.GroupByRequestFactory;
import com.liferay.portal.search.groupby.GroupByResponse;
import com.liferay.portal.search.internal.groupby.GroupByRequestFactoryImpl;
import com.liferay.portal.search.test.util.AssertUtils;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseGroupByTestCase
extends BaseIndexingTestCase {
    protected static final String GROUP_FIELD = "userName";
    protected static final String SORT_FIELD = "userId_sortable";
    protected final GroupByRequestFactory groupByRequestFactory = new GroupByRequestFactoryImpl();

    @Test
    public void testFieldNamesDefault() throws Exception {
        this.indexDuplicates("one", 1);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> searchContext.setGroupBy(new GroupBy(GROUP_FIELD)));
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroupedHitsFieldNames("one", (Collection<String>)Arrays.asList("companyId", "entryClassName", "entryClassPK", "groupId", SORT_FIELD, "uid", GROUP_FIELD), (Hits)hits, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper));
        });
    }

    @Test
    public void testFieldNamesSame() throws Exception {
        this.indexDuplicates("one", 1);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> searchContext.setGroupBy(new GroupBy(GROUP_FIELD)));
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroupedHitsFieldNames("one", this.getFieldNames((Hits)hits), (Hits)hits, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper));
        });
    }

    @Test
    public void testFieldNamesSameWithSelected() throws Exception {
        this.indexDuplicates("one", 1);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> {
                searchContext.setGroupBy(new GroupBy(GROUP_FIELD));
                QueryConfig queryConfig = searchContext.getQueryConfig();
                queryConfig.addSelectedFieldNames(new String[]{"companyId", "uid"});
            });
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroupedHitsFieldNames("one", this.getFieldNames((Hits)hits), (Hits)hits, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper));
        });
    }

    @Test
    public void testFieldNamesSelected() throws Exception {
        this.indexDuplicates("one", 1);
        this.assertSearch(indexingTestHelper -> {
            String[] fieldNames = new String[]{"companyId", "uid"};
            indexingTestHelper.define(searchContext -> {
                searchContext.setGroupBy(new GroupBy(GROUP_FIELD));
                QueryConfig queryConfig = searchContext.getQueryConfig();
                queryConfig.addSelectedFieldNames(fieldNames);
            });
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroupedHitsFieldNames("one", (Collection<String>)Arrays.asList(fieldNames), (Hits)hits, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper));
        });
    }

    @Test
    public void testGroupByDocsSize() throws Exception {
        this.indexDuplicates("five", 5);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> {
                GroupBy groupBy = new GroupBy(GROUP_FIELD);
                groupBy.setSize(4);
                searchContext.setGroupBy(groupBy);
            });
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroups(BaseGroupByTestCase.toMap("five", "5|4"), (Hits)hits, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper));
        });
    }

    @Test
    public void testGroupByDocsSortsScoreFieldAsc() throws Exception {
        this.assertGroupByDocsSortsScoreField(false);
    }

    @Test
    public void testGroupByDocsSortsScoreFieldDesc() throws Exception {
        this.assertGroupByDocsSortsScoreField(true);
    }

    @Test
    public void testGroupByDocsSortsSortFieldAsc() throws Exception {
        this.assertGroupByDocsSortsSortField(false);
    }

    @Test
    public void testGroupByDocsSortsSortFieldDesc() throws Exception {
        this.assertGroupByDocsSortsSortField(true);
    }

    @Test
    public void testGroupByDocsStart() throws Exception {
        HashMap map1 = HashMapBuilder.put((Object)"one", (Object)1).put((Object)"two", (Object)2).build();
        map1.forEach((key, value) -> this.indexDuplicates((String)key, (int)value));
        Set entries = map1.entrySet();
        Stream stream = entries.stream();
        Map<String, String> map2 = stream.collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getCountPairString((Integer)entry.getValue(), (Integer)entry.getValue() - 1)));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> {
                GroupBy groupBy = new GroupBy(GROUP_FIELD);
                groupBy.setStart(1);
                searchContext.setGroupBy(groupBy);
            });
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroups(map2, (Hits)hits, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper));
        });
    }

    @Test
    public void testGroupByTermsSizeDefault() throws Exception {
        HashMap map1 = HashMapBuilder.put((Object)"eight", (Object)2).put((Object)"eleven", (Object)2).put((Object)"five", (Object)2).put((Object)"four", (Object)2).put((Object)"nine", (Object)2).put((Object)"one", (Object)1).put((Object)"seven", (Object)2).put((Object)"six", (Object)2).put((Object)"ten", (Object)2).put((Object)"three", (Object)2).put((Object)"two", (Object)2).build();
        map1.forEach((key, value) -> this.indexDuplicates((String)key, (int)value));
        map1.remove("one", 1);
        Set entries = map1.entrySet();
        Stream stream = entries.stream();
        Map<String, String> map2 = stream.collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getCountPairString((Integer)entry.getValue(), (Integer)entry.getValue())));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                GroupByRequest groupByRequest = this.groupByRequestFactory.getGroupByRequest(GROUP_FIELD);
                this.setTermsSortsAndDocsSize(groupByRequest);
                searchRequestBuilder.groupByRequests(new GroupByRequest[]{groupByRequest});
            });
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroups(map2, (Hits)hits, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper));
        });
    }

    @Test
    public void testGroupByTermsSizeLessThanDefault() throws Exception {
        this.indexDuplicates("one", 1);
        this.indexDuplicates("two", 2);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                GroupByRequest groupByRequest = this.groupByRequestFactory.getGroupByRequest(GROUP_FIELD);
                groupByRequest.setTermsSize(1);
                this.setTermsSortsAndDocsSize(groupByRequest);
                searchRequestBuilder.groupByRequests(new GroupByRequest[]{groupByRequest});
            });
            try {
                indexingTestHelper.search();
            }
            catch (RuntimeException runtimeException) {
                if (this._shouldIgnoreSearchEngineGlitchAndRetry(runtimeException)) {
                    Assert.fail((String)runtimeException.getMessage());
                }
                throw runtimeException;
            }
            indexingTestHelper.verify(hits -> this.assertGroups(BaseGroupByTestCase.toMap("two", "2|2"), (Hits)hits, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper));
        });
    }

    @Test
    public void testGroupByTermsSizeMoreThanDefault() throws Exception {
        HashMap map1 = HashMapBuilder.put((Object)"eight", (Object)2).put((Object)"eleven", (Object)2).put((Object)"five", (Object)2).put((Object)"four", (Object)2).put((Object)"nine", (Object)2).put((Object)"one", (Object)1).put((Object)"seven", (Object)2).put((Object)"six", (Object)2).put((Object)"ten", (Object)2).put((Object)"three", (Object)2).put((Object)"two", (Object)2).build();
        map1.forEach((key, value) -> this.indexDuplicates((String)key, (int)value));
        Set entries = map1.entrySet();
        Stream stream = entries.stream();
        Map<String, String> map2 = stream.collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getCountPairString((Integer)entry.getValue(), (Integer)entry.getValue())));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                GroupByRequest groupByRequest = this.groupByRequestFactory.getGroupByRequest(GROUP_FIELD);
                groupByRequest.setTermsSize(11);
                this.setTermsSortsAndDocsSize(groupByRequest);
                searchRequestBuilder.groupByRequests(new GroupByRequest[]{groupByRequest});
            });
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroups(map2, (Hits)hits, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper));
        });
    }

    @Test
    public void testGroupByTermsStart() throws Exception {
        this.indexDuplicates("one", 1);
        this.indexDuplicates("two", 2);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                GroupByRequest groupByRequest = this.groupByRequestFactory.getGroupByRequest(GROUP_FIELD);
                groupByRequest.setTermsSorts(new Sort[]{new Sort(SORT_FIELD, 3, true)});
                groupByRequest.setTermsStart(1);
                searchRequestBuilder.groupByRequests(new GroupByRequest[]{groupByRequest});
            });
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroups(BaseGroupByTestCase.toMap("one", "1|1"), (Hits)hits, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper));
        });
    }

    protected static String sort(Collection<String> collection) {
        ArrayList<String> list = new ArrayList<String>(collection);
        Collections.sort(list);
        return ((Object)list).toString();
    }

    protected void assertGroupByDocsSortsScoreField(boolean desc) throws Exception {
        this.indexDuplicates("one", 1);
        this.indexDuplicates("two", 2);
        this.indexDuplicates("three", 3);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> {
                Sort[] sorts = new Sort[]{new Sort("scoreField", 0, desc)};
                GroupBy groupBy = new GroupBy(GROUP_FIELD);
                groupBy.setSize(3);
                groupBy.setSorts(sorts);
                searchContext.setGroupBy(groupBy);
            });
            BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
            booleanQueryImpl.addExactTerm(SORT_FIELD, "3");
            booleanQueryImpl.addExactTerm(SORT_FIELD, "2");
            booleanQueryImpl.add(this.getDefaultQuery(), BooleanClauseOccur.MUST);
            indexingTestHelper.setQuery((Query)booleanQueryImpl);
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroupsSorted((Hits)hits, true, 3));
        });
    }

    protected void assertGroupByDocsSortsSortField(boolean desc) throws Exception {
        this.indexDuplicates("one", 2);
        this.indexDuplicates("two", 2);
        this.indexDuplicates("three", 3);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> {
                Sort[] sorts = new Sort[]{new Sort(SORT_FIELD, 3, desc)};
                GroupBy groupBy = new GroupBy(GROUP_FIELD);
                groupBy.setSize(3);
                groupBy.setSorts(sorts);
                searchContext.setGroupBy(groupBy);
            });
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> this.assertGroupsSorted((Hits)hits, desc, 3));
        });
    }

    protected void assertGroupedHitsFieldNames(String key, Collection<String> expectedFieldNames, Hits hits, BaseIndexingTestCase.IndexingTestHelper indexingTestHelper) {
        Map groupedHitsMap = hits.getGroupedHits();
        Hits groupedHits = (Hits)groupedHitsMap.get(key);
        Assert.assertEquals((String)indexingTestHelper.getRequestString(), (Object)BaseGroupByTestCase.sort(expectedFieldNames), (Object)BaseGroupByTestCase.sort(this.getFieldNames(groupedHits)));
    }

    protected void assertGroups(Map<String, String> expectedCountsMap, Hits hits, BaseIndexingTestCase.IndexingTestHelper indexingTestHelper) {
        Map hitsMap = hits.getGroupedHits();
        Set entries = hitsMap.entrySet();
        Stream stream = entries.stream();
        Map<String, String> actualCountsMap = stream.collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getCountPairString((Hits)entry.getValue())));
        AssertUtils.assertEquals(indexingTestHelper.getRequestString(), expectedCountsMap, actualCountsMap);
    }

    protected void assertGroupsOrdered(List<String> expectedCountsList, Map<String, Hits> hitsMap, BaseIndexingTestCase.IndexingTestHelper indexingTestHelper) {
        ArrayList<String> actualCountsList = new ArrayList<String>();
        for (Map.Entry<String, Hits> entry : hitsMap.entrySet()) {
            actualCountsList.add(this.getCountPairString(entry.getKey(), entry.getValue()));
        }
        AssertUtils.assertEquals(indexingTestHelper.getRequestString(), expectedCountsList, actualCountsList);
    }

    protected void assertGroupsSorted(Hits hits, boolean desc, int minDocCount) {
        Map groupedHits = hits.getGroupedHits();
        int maxDocCount = 0;
        for (Map.Entry entry : groupedHits.entrySet()) {
            Hits groupHits = (Hits)entry.getValue();
            Document[] documents = groupHits.getDocs();
            if (documents.length > maxDocCount) {
                maxDocCount = documents.length;
            }
            for (int i = 0; i < documents.length; ++i) {
                Document document = documents[i];
                String sortFieldValue = document.get(SORT_FIELD);
                if (desc) {
                    Assert.assertEquals((String)document.toString(), (Object)String.valueOf(documents.length - i), (Object)sortFieldValue);
                    continue;
                }
                Assert.assertEquals((String)document.toString(), (Object)String.valueOf(i + 1), (Object)sortFieldValue);
            }
        }
        Assert.assertEquals((long)maxDocCount, (long)minDocCount);
    }

    protected void assertMultipleGroupsOrdered(Map<String, List<String>> expectedCountsMap, List<GroupByResponse> groupByResponses, BaseIndexingTestCase.IndexingTestHelper indexingTestHelper) {
        for (GroupByResponse groupByResponse : groupByResponses) {
            List<String> expectedCountsList = expectedCountsMap.get(groupByResponse.getField());
            this.assertGroupsOrdered(expectedCountsList, groupByResponse.getHitsMap(), indexingTestHelper);
        }
    }

    protected String getCountPairString(Hits hits) {
        Document[] docs = hits.getDocs();
        return this.getCountPairString(hits.getLength(), docs.length);
    }

    protected String getCountPairString(int hitsCount, int docsCount) {
        return hitsCount + "|" + docsCount;
    }

    protected String getCountPairString(String key, Hits hits) {
        Document[] docs = hits.getDocs();
        return key + "|" + this.getCountPairString(hits.getLength(), docs.length);
    }

    protected Collection<String> getFieldNames(Hits hits) {
        Assert.assertNotNull((Object)hits);
        Assert.assertNotEquals((long)0L, (long)hits.getLength());
        Document document = hits.doc(0);
        Map fields = document.getFields();
        Assert.assertFalse((boolean)fields.isEmpty());
        return fields.keySet();
    }

    protected void indexDuplicates(String name, int count) {
        String field = GROUP_FIELD;
        for (int i = 1; i <= count; ++i) {
            try {
                this.addDocument(DocumentCreationHelpers.twoKeywords(field, name, SORT_FIELD, String.valueOf(i)));
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    protected void setTermsSortsAndDocsSize(GroupByRequest groupByRequest) {
        groupByRequest.setTermsSorts(new Sort[]{new Sort(SORT_FIELD, 3, true)});
        groupByRequest.setDocsSize(2);
    }

    private boolean _shouldIgnoreSearchEngineGlitchAndRetry(RuntimeException runtimeException) {
        Throwable throwable1 = runtimeException.getCause();
        Throwable throwable2 = throwable1.getCause();
        String message = throwable2.getMessage();
        return message.equals("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
    }
}

