/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.indexing;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.aggregation.HierarchicalAggregationResult;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.filter.ComplexQueryPartBuilderFactory;
import com.liferay.portal.search.geolocation.GeoBuilders;
import com.liferay.portal.search.highlight.FieldConfigBuilderFactory;
import com.liferay.portal.search.highlight.HighlightBuilderFactory;
import com.liferay.portal.search.internal.aggregation.AggregationsImpl;
import com.liferay.portal.search.internal.document.DocumentBuilderFactoryImpl;
import com.liferay.portal.search.internal.filter.ComplexQueryPartBuilderFactoryImpl;
import com.liferay.portal.search.internal.geolocation.GeoBuildersImpl;
import com.liferay.portal.search.internal.highlight.FieldConfigBuilderFactoryImpl;
import com.liferay.portal.search.internal.highlight.HighlightBuilderFactoryImpl;
import com.liferay.portal.search.internal.legacy.searcher.SearchRequestBuilderImpl;
import com.liferay.portal.search.internal.legacy.searcher.SearchResponseBuilderImpl;
import com.liferay.portal.search.internal.query.QueriesImpl;
import com.liferay.portal.search.internal.rescore.RescoreBuilderFactoryImpl;
import com.liferay.portal.search.internal.script.ScriptsImpl;
import com.liferay.portal.search.internal.sort.SortsImpl;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.rescore.RescoreBuilderFactory;
import com.liferay.portal.search.script.Scripts;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.SearchMapUtil;
import com.liferay.portal.search.test.util.document.DocumentTranslator;
import com.liferay.portal.search.test.util.indexing.AggregationFixture;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelper;
import com.liferay.portal.search.test.util.indexing.DocumentFixture;
import com.liferay.portal.search.test.util.indexing.IndexingFixture;
import com.liferay.portal.search.test.util.indexing.QueryContributor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class BaseIndexingTestCase {
    @Rule
    public TestName testName = new TestName();
    protected static final long GROUP_ID = RandomTestUtil.randomLong();
    protected final AggregationFixture aggregationFixture = new AggregationFixture();
    protected final Aggregations aggregations = new AggregationsImpl();
    protected final ComplexQueryPartBuilderFactory complexQueryPartBuilderFactory = new ComplexQueryPartBuilderFactoryImpl();
    protected DocumentBuilderFactory documentBuilderFactory = new DocumentBuilderFactoryImpl();
    protected final FieldConfigBuilderFactory fieldConfigBuilderFactory = new FieldConfigBuilderFactoryImpl();
    protected final GeoBuilders geoBuilders = new GeoBuildersImpl();
    protected final HighlightBuilderFactory highlightBuilderFactory = new HighlightBuilderFactoryImpl();
    protected final Queries queries = new QueriesImpl();
    protected final RescoreBuilderFactory rescoreBuilderFactory = new RescoreBuilderFactoryImpl();
    protected final Scripts scripts = new ScriptsImpl();
    protected final Sorts sorts = new SortsImpl();
    private static final DocumentFixture _documentFixture = new DocumentFixture();
    private static IndexingFixture _indexingFixture;
    private String _entryClassName;
    private IndexSearcher _indexSearcher;
    private IndexWriter _indexWriter;

    @BeforeClass
    public static void setUpClassBaseIndexingTestCase() {
        _indexingFixture = null;
        _documentFixture.setUp();
    }

    @AfterClass
    public static void tearDownClassBaseIndexingTestCase() throws Exception {
        _documentFixture.tearDown();
        if (_indexingFixture == null) {
            return;
        }
        if (_indexingFixture.isSearchEngineAvailable()) {
            _indexingFixture.tearDown();
        }
        _indexingFixture = null;
    }

    @Before
    public void setUp() throws Exception {
        this.setUpIndexingFixture();
        Class<?> clazz = this.getClass();
        this._entryClassName = StringUtil.toLowerCase((String)(clazz.getSimpleName() + '.' + this.testName.getMethodName()));
        this._indexSearcher = _indexingFixture.getIndexSearcher();
        this._indexWriter = _indexingFixture.getIndexWriter();
    }

    @After
    public void tearDown() throws Exception {
        if (_indexingFixture == null) {
            return;
        }
        if (!_indexingFixture.isSearchEngineAvailable()) {
            return;
        }
        this._indexWriter.deleteEntityDocuments(this.createSearchContext(), this._entryClassName);
    }

    protected static <K, V> Map<K, V> toMap(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    protected void addDocument(Document document) {
        try {
            this._indexWriter.addDocument(this.createSearchContext(), document);
        }
        catch (SearchException searchException) {
            this._handle(searchException);
            throw new RuntimeException(searchException);
        }
    }

    protected void addDocument(DocumentBuilder documentBuilder) {
        DocumentTranslator documentTranslator = new DocumentTranslator();
        this.addDocument(documentTranslator.toLegacyDocument(documentBuilder.build()));
    }

    protected void addDocument(DocumentCreationHelper documentCreationHelper) {
        Document document = DocumentFixture.newDocument(this.getCompanyId(), GROUP_ID, this._entryClassName);
        documentCreationHelper.populate(document);
        this.addDocument(document);
    }

    protected void addDocuments(Function<String, DocumentCreationHelper> function, Collection<String> values) {
        this.addDocuments(function, values.stream());
    }

    protected void addDocuments(Function<String, DocumentCreationHelper> function, Stream<String> stream) {
        stream.map(function).forEach(this::addDocument);
    }

    protected void assertSearch(Consumer<IndexingTestHelper> indexingTestHelperConsumer) {
        try {
            IdempotentRetryAssert.retryAssert(10L, TimeUnit.SECONDS, () -> indexingTestHelperConsumer.accept(new IndexingTestHelper()));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected abstract IndexingFixture createIndexingFixture() throws Exception;

    protected SearchContext createSearchContext() {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(this.getCompanyId());
        searchContext.setGroupIds(new long[]{GROUP_ID});
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setHitsProcessingEnabled(true);
        queryConfig.setScoreEnabled(false);
        searchContext.setStart(-1);
        return searchContext;
    }

    protected long getCompanyId() {
        return _indexingFixture.getCompanyId();
    }

    protected Query getDefaultQuery() {
        Map<String, String> map = SearchMapUtil.join(BaseIndexingTestCase.toMap("companyId", String.valueOf(this.getCompanyId())), BaseIndexingTestCase.toMap("entryClassName", this._entryClassName), new Map[0]);
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        map.forEach((key, value) -> booleanQueryImpl.add((Query)new TermQueryImpl(key, value), BooleanClauseOccur.MUST));
        return booleanQueryImpl;
    }

    protected String getEntryClassName() {
        return this._entryClassName;
    }

    protected long getGroupId() {
        return GROUP_ID;
    }

    protected IndexSearcher getIndexSearcher() {
        return this._indexSearcher;
    }

    protected IndexWriter getIndexWriter() {
        return this._indexWriter;
    }

    protected SearchEngineAdapter getSearchEngineAdapter() {
        return _indexingFixture.getSearchEngineAdapter();
    }

    protected DocumentBuilder newDocumentBuilder() {
        return this.documentBuilderFactory.builder().setLong("companyId", Long.valueOf(this.getCompanyId())).setString("entryClassName", this.getEntryClassName()).setLong("groupId", Long.valueOf(this.getGroupId()));
    }

    protected Hits search(SearchContext searchContext) {
        return this.search(searchContext, this.getDefaultQuery());
    }

    protected Hits search(SearchContext searchContext, Query query) {
        try {
            return this._indexSearcher.search(searchContext, query);
        }
        catch (SearchException searchException) {
            this._handle(searchException);
            throw new RuntimeException(searchException);
        }
    }

    protected long searchCount(SearchContext searchContext, Query query) {
        try {
            return this._indexSearcher.searchCount(searchContext, query);
        }
        catch (SearchException searchException) {
            this._handle(searchException);
            throw new RuntimeException(searchException);
        }
    }

    protected void setPreBooleanFilter(Filter filter, Query query) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add(filter, BooleanClauseOccur.MUST);
        query.setPreBooleanFilter(booleanFilter);
    }

    protected void setUpIndexingFixture() throws Exception {
        if (_indexingFixture != null) {
            Assume.assumeTrue((boolean)_indexingFixture.isSearchEngineAvailable());
            return;
        }
        _indexingFixture = this.createIndexingFixture();
        Assume.assumeTrue((boolean)_indexingFixture.isSearchEngineAvailable());
        _indexingFixture.setUp();
    }

    private void _handle(SearchException searchException) {
        Throwable throwable = searchException.getCause();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
    }

    protected class IndexingTestHelper {
        private Filter _filter;
        private Hits _hits;
        private Filter _postFilter;
        private Query _query;
        private QueryContributor _queryContributor;
        private final SearchContext _searchContext;
        private final SearchRequestBuilder _searchRequestBuilder;
        private SearchResponse _searchResponse;

        public IndexingTestHelper() {
            this._searchContext = BaseIndexingTestCase.this.createSearchContext();
            this._searchRequestBuilder = new SearchRequestBuilderImpl(null, this._searchContext);
        }

        public void assertResultCount(int expected) {
            Object[] documents = this._hits.getDocs();
            Assert.assertEquals((String)((String)((Object)this._searchContext.getAttribute("queryString")) + "->" + Arrays.toString(documents)), (long)expected, (long)documents.length);
        }

        public void assertValues(String fieldName, List<String> expectedValues) {
            DocumentsAssert.assertValues((String)((Object)this._searchContext.getAttribute("queryString")), this._hits.getDocs(), fieldName, expectedValues);
        }

        public void define(Consumer<SearchContext> searchContextConsumer) {
            searchContextConsumer.accept(this._searchContext);
        }

        public void defineRequest(Consumer<SearchRequestBuilder> searchRequestBuilderConsumer) {
            searchRequestBuilderConsumer.accept(this._searchRequestBuilder);
        }

        public <AR extends AggregationResult> AR getAggregationResult(Aggregation aggregation) {
            return this.getAggregationResult(aggregation.getName());
        }

        public <AR extends AggregationResult> AR getAggregationResult(PipelineAggregation pipelineAggregation) {
            return this.getAggregationResult(pipelineAggregation.getName());
        }

        public <AR extends AggregationResult> AR getChildAggregationResult(Bucket bucket, Aggregation aggregation) {
            return (AR)bucket.getChildAggregationResult(aggregation.getName());
        }

        public <AR extends AggregationResult> AR getChildAggregationResult(HierarchicalAggregationResult aggregationResult, Aggregation aggregation) {
            return (AR)aggregationResult.getChildAggregationResult(aggregation.getName());
        }

        public String getRequestString() {
            return (String)((Object)this._searchContext.getAttribute("queryString"));
        }

        public SearchContext getSearchContext() {
            return this._searchContext;
        }

        public void search() {
            this._hits = BaseIndexingTestCase.this.search(this._searchContext, this.getQuery());
            SearchResponseBuilderImpl searchResponseBuilder = new SearchResponseBuilderImpl(this._searchContext);
            this._searchResponse = searchResponseBuilder.build();
        }

        public long searchCount() {
            long count = BaseIndexingTestCase.this.searchCount(this._searchContext, this.getQuery());
            SearchResponseBuilderImpl searchResponseBuilder = new SearchResponseBuilderImpl(this._searchContext);
            this._searchResponse = searchResponseBuilder.build();
            return count;
        }

        public void setFilter(Filter filter) {
            this._filter = filter;
        }

        public void setPostFilter(Filter postFilter) {
            this._postFilter = postFilter;
        }

        public void setQuery(Query query) {
            this._query = query;
        }

        public void setQueryContributor(QueryContributor queryContributor) {
            this._queryContributor = queryContributor;
        }

        public void setSearchContextAttribute(String name, Serializable value) {
            this._searchContext.setAttribute(name, value);
        }

        public void verify(Consumer<Hits> hitsConsumer) {
            hitsConsumer.accept(this._hits);
        }

        public void verifyContext(Consumer<SearchContext> searchContextConsumer) {
            searchContextConsumer.accept(this._searchContext);
        }

        public void verifyResponse(Consumer<SearchResponse> searchResponseConsumer) {
            searchResponseConsumer.accept(this._searchResponse);
        }

        protected <AR extends AggregationResult> AR getAggregationResult(String name) {
            AggregationResult aggregationResult = this._searchResponse.getAggregationResult(name);
            Assert.assertNotNull((Object)aggregationResult);
            return (AR)aggregationResult;
        }

        protected Query getQuery() {
            Query query = this._query;
            if (query == null) {
                query = BaseIndexingTestCase.this.getDefaultQuery();
            }
            if (this._queryContributor != null) {
                this._queryContributor.contribute(query);
            }
            if (this._filter != null) {
                BaseIndexingTestCase.this.setPreBooleanFilter(this._filter, query);
            }
            if (this._postFilter != null) {
                query.setPostFilter(this._postFilter);
            }
            return query;
        }
    }
}

