/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentResponse;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.internal.document.DocumentBuilderImpl;
import com.liferay.portal.search.query.MoreLikeThisQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMoreLikeThisQueryTestCase
extends BaseIndexingTestCase {
    private static final String _FIELD_DESCRIPTION = "description";
    private static final String _FIELD_TITLE = "title";

    @Test
    public void testLegacyMoreLikeThisWithFieldAndLikeText() throws Exception {
        this.addDocuments("java eclipse", "eclipse liferay", "java liferay eclipse");
        com.liferay.portal.kernel.search.generic.MoreLikeThisQuery moreLikeThisQuery = new com.liferay.portal.kernel.search.generic.MoreLikeThisQuery(this.getCompanyId());
        moreLikeThisQuery.addField(_FIELD_TITLE);
        moreLikeThisQuery.setLikeText("java");
        this.assertSearch(moreLikeThisQuery, Arrays.asList("java eclipse", "java liferay eclipse"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoreLikeThisWithDocumentIdentifier() throws Exception {
        String id = this.indexDocumentWithNoFieldsExceptTitle("java");
        try {
            this.addDocuments("java eclipse", "eclipse liferay", "java liferay eclipse");
            MoreLikeThisQuery.DocumentIdentifier documentIdentifier = this.queries.documentIdentifier(String.valueOf(this.getCompanyId()), "LiferayDocumentType", id);
            MoreLikeThisQuery moreLikeThisQuery = this.queries.moreLikeThis(Collections.singleton(documentIdentifier));
            this.assertSearch(moreLikeThisQuery, Arrays.asList("java eclipse", "java liferay eclipse"));
        }
        finally {
            this.deleteDocumentById(id);
        }
    }

    @Test
    public void testMoreLikeThisWithFieldAndLikeText() throws Exception {
        this.addDocuments("java eclipse", "eclipse liferay", "java liferay eclipse");
        MoreLikeThisQuery moreLikeThisQuery = this.queries.moreLikeThis(Collections.singletonList(_FIELD_TITLE), new String[]{"java"});
        this.assertSearch(moreLikeThisQuery, Arrays.asList("java eclipse", "java liferay eclipse"));
    }

    @Test
    public void testMoreLikeThisWithMinDocFreq() throws Exception {
        this.addDocuments("Red Blue", "Red Dog", "Red Blue Color", "Color");
        MoreLikeThisQuery moreLikeThisQuery = this.queries.moreLikeThis(Collections.singletonList(_FIELD_TITLE), new String[]{"Red Blue Color"});
        moreLikeThisQuery.setMinDocFrequency(Integer.valueOf(1));
        moreLikeThisQuery.setMinTermFrequency(Integer.valueOf(1));
        this.assertSearch(null, moreLikeThisQuery, Arrays.asList("Red Blue Color", "Red Blue", "Color", "Red Dog"));
        moreLikeThisQuery.setMinDocFrequency(Integer.valueOf(3));
        this.assertSearch(null, moreLikeThisQuery, Arrays.asList("Red Blue", "Red Dog", "Red Blue Color"));
    }

    @Test
    public void testMoreLikeThisWithMinimumShouldMatch() throws Exception {
        String[] texts = new String[10];
        for (int i = 0; i < 10; ++i) {
            String text = "";
            for (int j = 1; j <= 10 - i; ++j) {
                text = text + j + " ";
            }
            texts[i] = text.trim();
            this.addDocuments(text);
        }
        MoreLikeThisQuery moreLikeThisQuery = this.queries.moreLikeThis(new String[]{_FIELD_TITLE}, new String[]{texts[0]});
        for (int i = 0; i <= 10; ++i) {
            String minimumShouldMatch = 10 * i + "%";
            moreLikeThisQuery.setMinShouldMatch(minimumShouldMatch);
            ArrayList<String> expected = new ArrayList();
            if (minimumShouldMatch.equals("0%")) {
                expected = Arrays.asList(texts);
            } else {
                for (int j = 0; j < 11 - i; ++j) {
                    expected.add(texts[j]);
                }
            }
            this.assertSearch(moreLikeThisQuery, expected);
        }
    }

    @Test
    public void testMoreLikeThisWithMultipleFields() throws Exception {
        this.addDocuments("alpha charlie", "delta echo");
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(_FIELD_DESCRIPTION, value), Arrays.asList("bravo charlie"));
        MoreLikeThisQuery moreLikeThisQuery = this.queries.moreLikeThis(new String[]{_FIELD_TITLE}, new String[]{"alpha", "bravo"});
        moreLikeThisQuery.addField(_FIELD_DESCRIPTION);
        this.assertSearch(moreLikeThisQuery, Arrays.asList("alpha charlie", "bravo charlie"));
    }

    @Test
    public void testMoreLikeThisWithoutFields() throws Exception {
        this.addDocuments("java eclipse", "eclipse liferay", "java liferay eclipse");
        MoreLikeThisQuery moreLikeThisQuery = this.queries.moreLikeThis(Collections.emptyList(), new String[]{"java"});
        this.assertSearch(moreLikeThisQuery, Collections.emptyList());
    }

    protected void addDocuments(String ... values) throws Exception {
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(_FIELD_TITLE, value), Arrays.asList(values));
    }

    protected void assertSearch(com.liferay.portal.kernel.search.generic.MoreLikeThisQuery legacyMoreLikeThisQuery, List<String> expectedValues) {
        legacyMoreLikeThisQuery.setMinDocFrequency(Integer.valueOf(1));
        legacyMoreLikeThisQuery.setMinTermFrequency(Integer.valueOf(1));
        this.assertSearch(legacyMoreLikeThisQuery, null, expectedValues);
    }

    protected void assertSearch(com.liferay.portal.kernel.search.generic.MoreLikeThisQuery legacyMoreLikeThisQuery, MoreLikeThisQuery moreLikeThisQuery, List<String> expectedValues) {
        this.assertSearch(indexingTestHelper -> {
            SearchSearchRequest searchSearchRequest = this.createSearchSearchRequest();
            searchSearchRequest.setQuery((com.liferay.portal.kernel.search.Query)legacyMoreLikeThisQuery);
            searchSearchRequest.setQuery((Query)moreLikeThisQuery);
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            List searchHitsList = searchHits.getSearchHits();
            ArrayList actualValues = new ArrayList();
            searchHitsList.forEach(searchHit -> {
                String descriptionValue;
                Document document = searchHit.getDocument();
                String titleValue = document.getString(_FIELD_TITLE);
                if (titleValue != null) {
                    actualValues.add(titleValue);
                }
                if ((descriptionValue = document.getString(_FIELD_DESCRIPTION)) != null) {
                    actualValues.add(descriptionValue);
                }
            });
            Assert.assertEquals((String)("Retrieved hits ->" + actualValues), (Object)expectedValues.toString(), (Object)((Object)actualValues).toString());
            Assert.assertEquals((String)"Total hits", (long)expectedValues.size(), (long)searchHits.getTotalHits());
            Assert.assertEquals((String)"Retrieved hits", (long)expectedValues.size(), (long)searchHitsList.size());
        });
    }

    protected void assertSearch(MoreLikeThisQuery moreLikeThisQuery, List<String> expectedValues) {
        moreLikeThisQuery.setMinDocFrequency(Integer.valueOf(1));
        moreLikeThisQuery.setMinTermFrequency(Integer.valueOf(1));
        this.assertSearch(null, moreLikeThisQuery, expectedValues);
    }

    protected SearchSearchRequest createSearchSearchRequest() {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{String.valueOf(this.getCompanyId())});
        searchSearchRequest.setSize(Integer.valueOf(30));
        return searchSearchRequest;
    }

    protected void deleteDocumentById(String id) {
        SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
        DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(String.valueOf(this.getCompanyId()), id);
        deleteDocumentRequest.setType("LiferayDocumentType");
        searchEngineAdapter.execute((DocumentRequest)deleteDocumentRequest);
    }

    protected String indexDocumentWithNoFieldsExceptTitle(String title) {
        SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
        DocumentBuilderImpl documentBuilder = new DocumentBuilderImpl();
        documentBuilder.setString(_FIELD_TITLE, title);
        IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(String.valueOf(this.getCompanyId()), documentBuilder.build());
        indexDocumentRequest.setType("LiferayDocumentType");
        IndexDocumentResponse indexDocumentResponse = (IndexDocumentResponse)searchEngineAdapter.execute((DocumentRequest)indexDocumentRequest);
        return indexDocumentResponse.getUid();
    }
}

