/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.startup.monitor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.util.ThreadUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={})
public class PortalStartupMonitor {
    private static final long _SLEEP = 600000L;
    private ComponentContext _componentContext;
    private Thread _thread;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(module.service.lifecycle=portal.initialized)")
    public void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
        this._componentContext.disableComponent(PortalStartupMonitor.class.getName());
    }

    public void unsetModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this._componentContext = componentContext;
        this._thread = new Thread("Portal Startup Monitoring Thread"){

            @Override
            public void run() {
                StringBundler sb = new StringBundler(4);
                while (true) {
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    sb.append("Thread dump for portal startup after waited ");
                    sb.append(600000L);
                    sb.append("ms:\n");
                    sb.append(ThreadUtil.threadDump());
                    System.out.println(sb.toString());
                    sb.setIndex(0);
                }
            }
        };
        this._thread.setDaemon(true);
        this._thread.start();
    }

    @Deactivate
    protected void deactivate() {
        this._thread.interrupt();
    }
}

