/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.liferay.OAuth2ProviderScopeLiferayAccessControlContext;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public class ActionUtil {
    public static Map<String, String> addAction(String actionName, Class clazz, GroupedModel groupedModel, String methodName, Object object, UriInfo uriInfo) {
        Class<?> groupedModelClass = groupedModel.getClass();
        Class<?> superClass = groupedModelClass.getSuperclass();
        Class<?>[] interfaceClasses = superClass.getInterfaces();
        return ActionUtil.addAction(actionName, clazz, (Long)groupedModel.getPrimaryKeyObj(), methodName, interfaceClasses[0].getName(), object, groupedModel.getGroupId(), uriInfo);
    }

    public static Map<String, String> addAction(String actionName, Class clazz, Long id, String methodName, String permissionName, Object object, Long siteId, UriInfo uriInfo) {
        try {
            return ActionUtil._addAction(actionName, clazz, id, methodName, permissionName, object, siteId, uriInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Map<String, String> _addAction(String actionName, Class clazz, Long id, String methodName, String permissionName, Object object, Long siteId, UriInfo uriInfo) throws Exception {
        List<String> strings;
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        String restrictFields = (String)queryParameters.getFirst((Object)"restrictFields");
        if (restrictFields != null && (strings = Arrays.asList(restrictFields.split(","))).contains("actions")) {
            return null;
        }
        List modelResourceActions = ResourceActionsUtil.getModelResourceActions((String)permissionName);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!modelResourceActions.contains(actionName) || !permissionChecker.hasPermission(siteId.longValue(), permissionName, id.longValue(), actionName)) {
            return null;
        }
        if (object != null) {
            ScopeChecker scopeChecker = (ScopeChecker)object;
            if (OAuth2ProviderScopeLiferayAccessControlContext.isOAuth2AuthVerified() && !scopeChecker.checkScope(methodName)) {
                return null;
            }
        }
        List matchedURIs = uriInfo.getMatchedURIs();
        String version = "";
        if (!matchedURIs.isEmpty()) {
            version = (String)matchedURIs.get(matchedURIs.size() - 1);
        }
        return HashMapBuilder.put((Object)"href", (Object)uriInfo.getBaseUriBuilder().path(version).path(clazz.getSuperclass(), methodName).toTemplate()).put((Object)"method", (Object)ActionUtil._getHttpMethodName(clazz, methodName)).build();
    }

    private static String _getHttpMethodName(Class clazz, String methodName) throws NoSuchMethodException {
        for (Method method : clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            Class superClass = clazz.getSuperclass();
            Method superMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
            for (Annotation annotation : superMethod.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                Annotation[] annotations = annotationType.getAnnotationsByType(HttpMethod.class);
                if (annotations.length <= 0) continue;
                HttpMethod httpMethod = (HttpMethod)annotations[0];
                return httpMethod.value();
            }
        }
        return null;
    }
}

