/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.pagination;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@JacksonXmlRootElement(localName="page")
public class Page<T> {
    private final Map<String, Map<String, String>> _actions;
    private final Collection<T> _items;
    private final long _page;
    private final long _pageSize;
    private final long _totalCount;

    public static <T> Page<T> of(Collection<T> items) {
        return new Page<T>(items);
    }

    public static <T> Page<T> of(Collection<T> items, Pagination pagination, long totalCount) {
        return new Page<T>(items, pagination, totalCount);
    }

    public static <T> Page<T> of(Map<String, Map<String, String>> actions, Collection<T> items) {
        return new Page<T>(actions, items);
    }

    public static <T> Page<T> of(Map<String, Map<String, String>> actions, Collection<T> items, Pagination pagination, long totalCount) {
        return new Page<T>(actions, items, pagination, totalCount);
    }

    @JsonProperty(value="actions")
    public Map<String, Map<String, String>> getActions() {
        return this._actions;
    }

    @JacksonXmlElementWrapper(localName="items")
    @JacksonXmlProperty(localName="item")
    public Collection<T> getItems() {
        return new ArrayList<T>(this._items);
    }

    public long getLastPage() {
        if (this._pageSize == 0L || this._totalCount == 0L) {
            return 1L;
        }
        return -Math.floorDiv(-this._totalCount, this._pageSize);
    }

    @JsonProperty(value="page")
    public long getPage() {
        return this._page;
    }

    @JsonProperty(value="pageSize")
    public long getPageSize() {
        return this._pageSize;
    }

    public long getTotalCount() {
        return this._totalCount;
    }

    public boolean hasNext() {
        return this.getLastPage() > this._page;
    }

    public boolean hasPrevious() {
        return this._page > 1L;
    }

    private Page(Collection<T> items) {
        this(new HashMap<String, Map<String, String>>(), items);
    }

    private Page(Collection<T> items, Pagination pagination, long totalCount) {
        this(new HashMap<String, Map<String, String>>(), items, pagination, totalCount);
    }

    private Page(Map<String, Map<String, String>> actions, Collection<T> items) {
        this._actions = actions;
        this._items = items;
        this._page = 1L;
        this._pageSize = items.size();
        this._totalCount = items.size();
    }

    private Page(Map<String, Map<String, String>> actions, Collection<T> items, Pagination pagination, long totalCount) {
        this._actions = actions;
        this._items = items;
        if (pagination == null) {
            this._page = 0L;
            this._pageSize = 0L;
        } else {
            this._page = pagination.getPage();
            this._pageSize = pagination.getPageSize();
        }
        this._totalCount = totalCount;
    }
}

