/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.accept.language;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;

public class AcceptLanguageImpl
implements AcceptLanguage {
    private final HttpServletRequest _httpServletRequest;
    private final Language _language;
    private final Portal _portal;

    public AcceptLanguageImpl(HttpServletRequest httpServletRequest, Language language, Portal portal) {
        this._httpServletRequest = httpServletRequest;
        this._language = language;
        this._portal = portal;
    }

    public List<Locale> getLocales() {
        String acceptLanguage = this._httpServletRequest.getHeader("Accept-Language");
        if (acceptLanguage == null) {
            return Collections.emptyList();
        }
        try {
            Company company = this._portal.getCompany(this._httpServletRequest);
            Set companyAvailableLocales = this._language.getCompanyAvailableLocales(company.getCompanyId());
            List<Locale> locales = Locale.filter(Locale.LanguageRange.parse(acceptLanguage), companyAvailableLocales);
            if (ListUtil.isEmpty(locales)) {
                throw new ClientErrorException("No available locale matches the accepted languages: " + acceptLanguage, 422);
            }
            return locales;
        }
        catch (PortalException pe) {
            throw new InternalServerErrorException("Unable to get preferred locale: " + pe.getMessage(), (Throwable)pe);
        }
    }

    public String getPreferredLanguageId() {
        return LocaleUtil.toLanguageId((Locale)this.getPreferredLocale());
    }

    public Locale getPreferredLocale() {
        List<Locale> locales = this.getLocales();
        if (ListUtil.isNotEmpty(locales)) {
            return locales.get(0);
        }
        try {
            User user = this._portal.initUser(this._httpServletRequest);
            return user.getLocale();
        }
        catch (NoSuchUserException nsue) {
            throw new NotFoundException("Unable to get preferred locale from nonexistent user", (Throwable)nsue);
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Unable to get preferred locale: " + e.getMessage(), (Throwable)e);
        }
    }
}

