/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.graphql.servlet;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.servlet.ServletData;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.graphQLProcessors.GraphQLInputProcessor;
import graphql.annotations.processor.graphQLProcessors.GraphQLOutputProcessor;
import graphql.annotations.processor.retrievers.GraphQLExtensionsHandler;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.annotations.processor.retrievers.GraphQLInterfaceRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.retrievers.GraphQLTypeRetriever;
import graphql.annotations.processor.retrievers.fieldBuilders.ArgumentBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DeprecateBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DescriptionBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodNameBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodTypeBuilder;
import graphql.annotations.processor.searchAlgorithms.BreadthFirstSearch;
import graphql.annotations.processor.searchAlgorithms.ParentalSearch;
import graphql.annotations.processor.typeFunctions.DefaultTypeFunction;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.NamingKit;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.servlet.GraphQLContext;
import graphql.servlet.SimpleGraphQLHttpServlet;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={})
public class GraphQLServletExtender {
    private static final GraphQLScalarType _dateGraphQLScalarType = new GraphQLScalarType("Date", "An RFC-3339 compliant date time scalar", (Coercing)new Coercing<Date, String>(){

        public Date parseLiteral(Object value) throws CoercingParseLiteralException {
            return this._toDate(value);
        }

        public Date parseValue(Object value) throws CoercingParseValueException {
            return this._toDate(value);
        }

        public String serialize(Object value) throws CoercingSerializeException {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            return simpleDateFormat.format((Date)value);
        }

        private Date _toDate(Object value) {
            if (value instanceof Date) {
                return (Date)value;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            try {
                if (value instanceof StringValue) {
                    StringValue stringValue = (StringValue)value;
                    return simpleDateFormat.parse(stringValue.getValue());
                }
                return simpleDateFormat.parse(value.toString());
            }
            catch (ParseException pe) {
                throw new CoercingSerializeException("Unable to parse " + value, (Throwable)pe);
            }
        }
    });
    private static final GraphQLScalarType _objectGraphQLScalarType = new GraphQLScalarType("Object", "Any kind of object supported by basic scalar types", (Coercing)new Coercing<Object, Object>(){

        public Object parseLiteral(Object value) throws CoercingParseLiteralException {
            if (value instanceof ArrayValue) {
                ArrayValue arrayValue = (ArrayValue)value;
                List values = arrayValue.getValues();
                return values.stream().map(this::parseLiteral).collect(Collectors.toList());
            }
            if (value instanceof BooleanValue) {
                BooleanValue booleanValue = (BooleanValue)value;
                return booleanValue.isValue();
            }
            if (value instanceof EnumValue) {
                EnumValue enumValue = (EnumValue)value;
                return enumValue.getName();
            }
            if (value instanceof FloatValue) {
                FloatValue floatValue = (FloatValue)value;
                return floatValue.getValue();
            }
            if (value instanceof IntValue) {
                IntValue intValue = (IntValue)value;
                return intValue.getValue();
            }
            if (value instanceof NullValue) {
                return null;
            }
            if (value instanceof ObjectValue) {
                ObjectValue objectValue = (ObjectValue)value;
                List objectFields = objectValue.getObjectFields();
                return objectFields.stream().collect(Collectors.toMap(ObjectField::getName, objectField -> this.parseLiteral(objectField.getValue())));
            }
            if (value instanceof StringValue) {
                StringValue stringValue = (StringValue)value;
                return stringValue.getValue();
            }
            throw new CoercingSerializeException("Unable to parse " + value);
        }

        public Object parseValue(Object value) throws CoercingParseValueException {
            return value;
        }

        public Object serialize(Object value) throws CoercingSerializeException {
            return value;
        }
    });
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    private DefaultTypeFunction _defaultTypeFunction;
    private GraphQLFieldRetriever _graphQLFieldRetriever;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    private volatile Servlet _servlet;
    private ServiceRegistration<ServletContextHelper> _servletContextHelperServiceRegistration;
    private final List<ServletData> _servletDataList = new ArrayList<ServletData>();
    private ServiceTracker<ServletData, ServletData> _servletDataServiceTracker;
    private ServiceRegistration<Servlet> _servletServiceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._graphQLFieldRetriever = new LiferayGraphQLFieldRetriever();
        final GraphQLInterfaceRetriever graphQLInterfaceRetriever = new GraphQLInterfaceRetriever();
        final GraphQLObjectInfoRetriever graphQLObjectInfoRetriever = new GraphQLObjectInfoRetriever(){

            @Override
            public String getTypeName(Class<?> objectClass) {
                GraphQLName graphQLName = objectClass.getAnnotation(GraphQLName.class);
                if (graphQLName == null) {
                    return NamingKit.toGraphqlName(objectClass.getName());
                }
                return NamingKit.toGraphqlName(graphQLName.value());
            }
        };
        final BreadthFirstSearch breadthFirstSearch = new BreadthFirstSearch(graphQLObjectInfoRetriever);
        final ParentalSearch parentalSearch = new ParentalSearch(graphQLObjectInfoRetriever);
        final GraphQLTypeRetriever graphQLTypeRetriever = new GraphQLTypeRetriever(){
            {
                this.setExtensionsHandler(new GraphQLExtensionsHandler(){
                    {
                        this.setFieldRetriever(GraphQLServletExtender.this._graphQLFieldRetriever);
                        this.setFieldSearchAlgorithm(parentalSearch);
                        this.setGraphQLObjectInfoRetriever(graphQLObjectInfoRetriever);
                        this.setMethodSearchAlgorithm(breadthFirstSearch);
                    }
                });
                this.setFieldSearchAlgorithm(parentalSearch);
                this.setGraphQLFieldRetriever(GraphQLServletExtender.this._graphQLFieldRetriever);
                this.setGraphQLInterfaceRetriever(graphQLInterfaceRetriever);
                this.setGraphQLObjectInfoRetriever(graphQLObjectInfoRetriever);
                this.setMethodSearchAlgorithm(breadthFirstSearch);
            }
        };
        graphQLInterfaceRetriever.setGraphQLTypeRetriever(graphQLTypeRetriever);
        this._defaultTypeFunction = new DefaultTypeFunction(new GraphQLInputProcessor(){
            {
                this.setGraphQLTypeRetriever(graphQLTypeRetriever);
            }
        }, new GraphQLOutputProcessor(){
            {
                this.setGraphQLTypeRetriever(graphQLTypeRetriever);
            }
        });
        this._defaultTypeFunction.register(new DateTypeFunction());
        this._defaultTypeFunction.register(new ObjectTypeFunction());
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("osgi.http.whiteboard.context.name", "GraphQL");
        properties.put("osgi.http.whiteboard.context.path", "/graphql");
        properties.put("osgi.http.whiteboard.filter.servlet", "GraphQL");
        this._servletContextHelperServiceRegistration = bundleContext.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(bundleContext.getBundle()){}, (Dictionary)properties);
        this._servletDataServiceTracker = new ServiceTracker(bundleContext, ServletData.class, (ServiceTrackerCustomizer)new ServletDataServiceTrackerCustomizer());
        this._servletDataServiceTracker.open();
        properties = new HashMapDictionary();
        properties.put("osgi.http.whiteboard.context.select", "GraphQL");
        properties.put("osgi.http.whiteboard.servlet.name", "GraphQL");
        properties.put("osgi.http.whiteboard.servlet.pattern", "/*");
        this._servletServiceRegistration = this._bundleContext.registerService(Servlet.class, (Object)((Servlet)ProxyUtil.newProxyInstance((ClassLoader)GraphQLServletExtender.class.getClassLoader(), (Class[])new Class[]{Servlet.class}, (InvocationHandler)new InvocationHandler(){
            private ServletConfig _servletConfig;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (methodName.equals("destroy")) {
                    return null;
                }
                if (methodName.equals("getServletInfo")) {
                    return "";
                }
                if (methodName.equals("hashCode")) {
                    return this.hashCode();
                }
                if (methodName.equals("init") && args.length > 0) {
                    this._servletConfig = (ServletConfig)args[0];
                    return null;
                }
                Servlet servlet = GraphQLServletExtender.this._getServlet();
                servlet.init(this._servletConfig);
                try {
                    return method.invoke((Object)servlet, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getCause();
                }
            }
        })), (Dictionary)properties);
    }

    @Deactivate
    protected void deactivate() {
        this._servletDataServiceTracker.close();
        this._servletServiceRegistration.unregister();
        this._servletContextHelperServiceRegistration.unregister();
    }

    private void _collectObjectFields(GraphQLObjectType.Builder builder, Function<ServletData, Object> function, ProcessingElementsContainer processingElementsContainer) {
        Map<String, Optional<Method>> methods = this._servletDataList.stream().map(function).map(Object::getClass).map(Class::getMethods).flatMap(Arrays::stream).filter(method -> method.isAnnotationPresent(GraphQLField.class)).collect(Collectors.groupingBy(Method::getName, Collectors.maxBy(Comparator.comparingInt(this::_getVersion))));
        for (Optional<Method> methodOptional : methods.values()) {
            if (!methodOptional.isPresent()) continue;
            Method method2 = methodOptional.get();
            Class<?> clazz = method2.getDeclaringClass();
            builder.field(this._graphQLFieldRetriever.getField(clazz.getSimpleName(), method2, processingElementsContainer));
        }
    }

    private Object _get(DataFetchingEnvironment dataFetchingEnvironment, Method method) throws Exception {
        Class<?> clazz = method.getDeclaringClass();
        Object instance = clazz.newInstance();
        GraphQLContext graphQLContext = (GraphQLContext)dataFetchingEnvironment.getContext();
        Optional httpServletRequestOptional = graphQLContext.getHttpServletRequest();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
            Class<Object> fieldType = field.getType();
            if (fieldType.isAssignableFrom(AcceptLanguage.class)) {
                field.setAccessible(true);
                field.set(instance, new AcceptLanguageImpl(httpServletRequestOptional.orElse(null), this._language, this._portal));
                continue;
            }
            if (!fieldType.isAssignableFrom(Company.class)) continue;
            field.setAccessible(true);
            field.set(instance, this._companyLocalService.getCompany(CompanyThreadLocal.getCompanyId().longValue()));
        }
        Parameter[] parameters = method.getParameters();
        Map arguments = dataFetchingEnvironment.getArguments();
        Object[] args = new Object[arguments.size()];
        for (int i = 0; i < args.length; ++i) {
            Parameter parameter = parameters[i];
            String parameterName = null;
            GraphQLName graphQLName = parameter.getAnnotation(GraphQLName.class);
            parameterName = graphQLName == null ? NamingKit.toGraphqlName(parameter.getName()) : NamingKit.toGraphqlName(graphQLName.value());
            args[i] = arguments.get(parameterName);
        }
        return method.invoke(instance, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Servlet _getServlet() {
        Servlet servlet = this._servlet;
        if (servlet != null) {
            return servlet;
        }
        List<ServletData> list = this._servletDataList;
        synchronized (list) {
            if (this._servlet != null) {
                return this._servlet;
            }
            ProcessingElementsContainer processingElementsContainer = new ProcessingElementsContainer(this._defaultTypeFunction);
            GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
            GraphQLObjectType.Builder mutationBuilder = GraphQLObjectType.newObject();
            mutationBuilder.name("mutation");
            GraphQLObjectType.Builder queryBuilder = GraphQLObjectType.newObject();
            queryBuilder.name("query");
            this._collectObjectFields(mutationBuilder, ServletData::getMutation, processingElementsContainer);
            this._collectObjectFields(queryBuilder, ServletData::getQuery, processingElementsContainer);
            schemaBuilder.mutation(mutationBuilder.build());
            schemaBuilder.query(queryBuilder.build());
            SimpleGraphQLHttpServlet.Builder servletBuilder = SimpleGraphQLHttpServlet.newBuilder((GraphQLSchema)schemaBuilder.build());
            this._servlet = servletBuilder.build();
            return this._servlet;
        }
    }

    private Integer _getVersion(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        Package pkg = clazz.getPackage();
        String packageString = pkg.toString();
        String[] packageNames = packageString.split("\\.");
        String version = packageNames[packageNames.length - 1];
        return Integer.valueOf(version.replaceAll("\\D", ""));
    }

    private class ServletDataServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServletData, ServletData> {
        private ServletDataServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServletData addingService(ServiceReference<ServletData> serviceReference) {
            ServletData servletData = (ServletData)GraphQLServletExtender.this._bundleContext.getService(serviceReference);
            List list = GraphQLServletExtender.this._servletDataList;
            synchronized (list) {
                GraphQLServletExtender.this._servletDataList.add(servletData);
                GraphQLServletExtender.this._servlet = null;
            }
            return servletData;
        }

        public void modifiedService(ServiceReference<ServletData> serviceReference, ServletData servletData) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ServletData> serviceReference, ServletData servletData) {
            List list = GraphQLServletExtender.this._servletDataList;
            synchronized (list) {
                GraphQLServletExtender.this._servletDataList.remove(servletData);
                GraphQLServletExtender.this._servlet = null;
            }
            GraphQLServletExtender.this._bundleContext.ungetService(serviceReference);
        }
    }

    private class ObjectTypeFunction
    implements TypeFunction {
        private ObjectTypeFunction() {
        }

        @Override
        public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
            return _objectGraphQLScalarType;
        }

        @Override
        public boolean canBuildType(Class<?> clazz, AnnotatedType annotatedType) {
            return clazz == Filter.class || clazz == MultipartBody.class || clazz == Object.class || clazz == Sort[].class;
        }
    }

    private class LiferayMethodDataFetcher
    implements DataFetcher<Object> {
        private final Method _method;

        public Object get(DataFetchingEnvironment dataFetchingEnvironment) {
            try {
                return GraphQLServletExtender.this._get(dataFetchingEnvironment, this._method);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private LiferayMethodDataFetcher(Method method) {
            this._method = method;
        }
    }

    private class LiferayGraphQLFieldRetriever
    extends GraphQLFieldRetriever {
        private LiferayGraphQLFieldRetriever() {
        }

        @Override
        public GraphQLFieldDefinition getField(String parentName, Method method, ProcessingElementsContainer processingElementsContainer) {
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            MethodTypeBuilder methodTypeBuilder = new MethodTypeBuilder(method, processingElementsContainer.getDefaultTypeFunction(), processingElementsContainer, false);
            GraphQLOutputType graphQLOutputType = (GraphQLOutputType)methodTypeBuilder.build();
            ArgumentBuilder argumentBuilder = new ArgumentBuilder(method, processingElementsContainer.getDefaultTypeFunction(), builder, processingElementsContainer, graphQLOutputType);
            builder.arguments((List)argumentBuilder.build());
            builder.dataFetcher((DataFetcher)new LiferayMethodDataFetcher(method));
            DeprecateBuilder deprecateBuilder = new DeprecateBuilder(method);
            builder.deprecate(deprecateBuilder.build());
            DescriptionBuilder descriptionBuilder = new DescriptionBuilder(method);
            builder.description(descriptionBuilder.build());
            MethodNameBuilder methodNameBuilder = new MethodNameBuilder(method);
            builder.name(methodNameBuilder.build());
            builder.type(graphQLOutputType);
            return builder.build();
        }
    }

    private class DateTypeFunction
    implements TypeFunction {
        private DateTypeFunction() {
        }

        @Override
        public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
            return _dateGraphQLScalarType;
        }

        @Override
        public boolean canBuildType(Class<?> clazz, AnnotatedType annotatedType) {
            return clazz == Date.class;
        }
    }
}

