/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.container.request.filter;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

@Provider
public class SiteValidatorContainerRequestFilter
implements ContainerRequestFilter {
    private final GroupLocalService _groupLocalService;
    @Context
    private UriInfo _uriInfo;

    public SiteValidatorContainerRequestFilter(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    public void filter(ContainerRequestContext requestContext) {
        MultivaluedMap multivaluedMap = this._uriInfo.getPathParameters();
        String siteId = (String)multivaluedMap.getFirst((Object)"siteId");
        if (siteId == null) {
            return;
        }
        if (!this._isValidSite(siteId)) {
            throw new NotFoundException("Unable to get a valid site with ID " + siteId);
        }
    }

    private boolean _isValidSite(String siteId) {
        Group group = this._groupLocalService.fetchGroup(GetterUtil.getLong((String)siteId));
        return group != null && group.isSite();
    }
}

