/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.context.provider;

import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.impl.ResourceContextImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

public class ContextProviderUtil {
    public static EntityModel getEntityModel(Message message) throws Exception {
        Object matchedResource = ContextProviderUtil._getMatchedResource(message);
        if (matchedResource instanceof EntityModelResource) {
            EntityModelResource entityModelResource = (EntityModelResource)matchedResource;
            return entityModelResource.getEntityModel(ContextProviderUtil._getPathParameters(message));
        }
        return null;
    }

    public static HttpServletRequest getHttpServletRequest(Message message) {
        return (HttpServletRequest)message.getContextualProperty("HTTP.REQUEST");
    }

    private static Object _getMatchedResource(Message message) {
        Exchange exchange = message.getExchange();
        Object root = exchange.get((Object)"service.root.instance");
        if (root != null) {
            return root;
        }
        OperationResourceInfo operationResourceInfo = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ResourceContextImpl resourceContext = new ResourceContextImpl(message, operationResourceInfo);
        ClassResourceInfo classResourceInfo = operationResourceInfo.getClassResourceInfo();
        ResourceProvider resourceProvider = classResourceInfo.getResourceProvider();
        if (resourceProvider != null) {
            Object instance = resourceProvider.getInstance(message);
            resourceContext.initResource(instance);
            return instance;
        }
        UriInfoImpl uriInfo = new UriInfoImpl(message);
        List matchedResources = uriInfo.getMatchedResources();
        Class matchedResourceClass = (Class)matchedResources.get(0);
        return resourceContext.getResource(matchedResourceClass);
    }

    private static MultivaluedMap<String, String> _getPathParameters(Message message) {
        UriInfoImpl uriInfo = new UriInfoImpl(message);
        return uriInfo.getPathParameters();
    }
}

