/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.message.body;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.internal.jaxrs.validation.ValidatorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;

public abstract class BaseMessageBodyReader
implements MessageBodyReader {
    private final Class<? extends ObjectMapper> _contextType;
    @Context
    private HttpServletRequest _httpServletRequest;
    private final MediaType _mediaType;
    @Context
    private Providers _providers;

    public BaseMessageBodyReader(Class<? extends ObjectMapper> contextType, MediaType mediaType) {
        this._contextType = contextType;
        this._mediaType = mediaType;
    }

    public boolean isReadable(Class clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class clazz, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException {
        ObjectReader objectMapper = this._getObjectMapper(clazz).readerFor(clazz);
        Object value = objectMapper.readValue(inputStream);
        if (!StringUtil.equals((String)this._httpServletRequest.getMethod(), (String)"PATCH")) {
            this._validate(value);
        }
        return value;
    }

    private ObjectMapper _getObjectMapper(Class<?> clazz) {
        return Optional.ofNullable(this._providers.getContextResolver(this._contextType, this._mediaType)).map(contextResolver -> (ObjectMapper)contextResolver.getContext(clazz)).orElseThrow(() -> new InternalServerErrorException("Unable to generate object mapper for class " + clazz));
    }

    private void _validate(Object value) {
        Validator validator = ValidatorFactory.getValidator();
        Set constraintViolations = validator.validate(value, new Class[0]);
        if (constraintViolations.isEmpty()) {
            return;
        }
        StringBundler sb = new StringBundler(constraintViolations.size() * 4);
        for (ConstraintViolation constraintViolation : constraintViolations) {
            sb.append((Object)constraintViolation.getPropertyPath());
            sb.append(" ");
            sb.append(constraintViolation.getMessage());
            sb.append("\n");
        }
        throw new ValidationException(sb.toString());
    }
}

