/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.message.body;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.liferay.portal.vulcan.fields.FieldsQueryParam;
import com.liferay.portal.vulcan.internal.jackson.databind.ser.VulcanPropertyFilter;
import com.liferay.portal.vulcan.internal.jaxrs.serializer.PageJsonSerializer;
import com.liferay.portal.vulcan.pagination.Page;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

public abstract class BaseMessageBodyWriter
implements MessageBodyWriter<Object> {
    private final Class<? extends ObjectMapper> _contextType;
    @Context
    private FieldsQueryParam _fieldsQueryParam;
    private final MediaType _mediaType;
    @Context
    private Providers _providers;

    public BaseMessageBodyWriter(Class<? extends ObjectMapper> contextType, MediaType mediaType) {
        this._contextType = contextType;
        this._mediaType = mediaType;
    }

    public boolean isWriteable(Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType) {
        ObjectMapper objectMapper = this._getObjectMapper(clazz);
        return objectMapper.canSerialize(clazz);
    }

    public void writeTo(Object object, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        ObjectMapper objectMapper = this._getObjectMapper(clazz);
        if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addSerializer(Page.class, (JsonSerializer)new PageJsonSerializer());
            objectMapper.registerModule((Module)simpleModule);
        }
        ObjectWriter objectWriter = objectMapper.writerFor(objectMapper.constructType(genericType));
        objectWriter.writeValue(outputStream, object);
        outputStream.flush();
    }

    private ObjectMapper _addFilter(ObjectMapper objectMapper) {
        objectMapper.setFilterProvider((FilterProvider)new SimpleFilterProvider(){
            {
                Set fieldNames = BaseMessageBodyWriter.this._fieldsQueryParam.getFieldNames();
                Object propertyFilter = null;
                propertyFilter = fieldNames == null ? SimpleBeanPropertyFilter.serializeAll() : VulcanPropertyFilter.of(fieldNames);
                this.addFilter("Liferay.Vulcan", (PropertyFilter)propertyFilter);
            }
        });
        return objectMapper;
    }

    private ObjectMapper _getObjectMapper(Class<?> clazz) {
        return Optional.ofNullable(this._providers.getContextResolver(this._contextType, this._mediaType)).map(contextResolver -> (ObjectMapper)contextResolver.getContext(clazz)).map(this::_addFilter).orElseThrow(() -> new InternalServerErrorException("Unable to generate object mapper for class " + clazz));
    }
}

