/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.validation;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.internal.jaxrs.validation.ValidatorFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.validation.AbstractValidationInterceptor;

@Provider
public class BeanValidationInterceptor
extends AbstractValidationInterceptor
implements ContainerRequestFilter {
    public BeanValidationInterceptor() {
        super("pre-invoke");
    }

    public BeanValidationInterceptor(String phase) {
        super(phase);
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        InterceptorChain interceptorChain = message.getInterceptorChain();
        interceptorChain.add((Interceptor)this);
    }

    public void handleMessage(Message message) throws Fault {
        Object serviceObject = this.getServiceObject(message);
        if (serviceObject == null) {
            return;
        }
        Method method = this.getServiceMethod(message);
        if (method == null) {
            return;
        }
        MessageContentsList arguments = MessageContentsList.getContentsList((Message)message);
        this.handleValidation(message, serviceObject, method, (List<Object>)arguments);
    }

    protected Object getServiceObject(Message message) {
        Exchange exchange = message.getExchange();
        OperationResourceInfo operationResourceInfo = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        if (operationResourceInfo == null) {
            return null;
        }
        ClassResourceInfo classResourceInfo = operationResourceInfo.getClassResourceInfo();
        if (!classResourceInfo.isRoot()) {
            return exchange.get((Object)"org.apache.cxf.service.object.last");
        }
        ResourceProvider resourceProvider = classResourceInfo.getResourceProvider();
        Object instance = resourceProvider.getInstance(message);
        resourceProvider.releaseInstance(message, instance);
        return instance;
    }

    protected void handleValidation(Message message, Object resourceInstance, Method method, List<Object> arguments) {
        if (ListUtil.isEmpty(arguments)) {
            return;
        }
        Validator validator = ValidatorFactory.getValidator();
        ExecutableValidator executableValidator = validator.forExecutables();
        Set constraintViolations = executableValidator.validateParameters(resourceInstance, method, arguments.toArray(), new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }
}

