/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.writer.interceptor;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.internal.fields.NestedFieldsContext;
import com.liferay.portal.vulcan.internal.fields.NestedFieldsContextThreadLocal;
import com.liferay.portal.vulcan.internal.fields.servlet.NestedFieldsHttpServletRequestWrapper;
import com.liferay.portal.vulcan.internal.param.converter.DateParamConverter;
import com.liferay.portal.vulcan.pagination.Page;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.message.Message;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@Provider
public class NestedFieldsWriterInterceptor
implements WriterInterceptor {
    private static final Log _log = LogFactoryUtil.getLog(NestedFieldsWriterInterceptor.class);
    private final BundleContext _bundleContext;
    private final DateParamConverter _dateParamConverter = new DateParamConverter();

    public NestedFieldsWriterInterceptor(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException, WebApplicationException {
        NestedFieldsContext nestedFieldsContext = NestedFieldsContextThreadLocal.getNestedFieldsContext();
        if (nestedFieldsContext == null) {
            writerInterceptorContext.proceed();
            return;
        }
        try {
            this._setFieldValue(writerInterceptorContext.getEntity(), nestedFieldsContext);
        }
        catch (Exception e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        writerInterceptorContext.proceed();
    }

    protected List<ContextProvider> getContextProviders() throws InvalidSyntaxException {
        ArrayList<ContextProvider> contextProviders = new ArrayList<ContextProvider>();
        Collection serviceReferences = this._bundleContext.getServiceReferences(ContextProvider.class, null);
        for (ServiceReference serviceReference : serviceReferences) {
            ContextProvider contextProvider = (ContextProvider)this._bundleContext.getService(serviceReference);
            contextProviders.add(contextProvider);
        }
        return contextProviders;
    }

    protected HttpServletRequest getHttpServletRequest(Message message) {
        return (HttpServletRequest)message.getContextualProperty("HTTP.REQUEST");
    }

    protected List<Object> getResources() throws InvalidSyntaxException {
        ServiceReference[] serviceReferences;
        ArrayList<Object> resources = new ArrayList<Object>();
        for (ServiceReference serviceReference : serviceReferences = this._bundleContext.getAllServiceReferences(null, "(osgi.jaxrs.resource=true)")) {
            resources.add(this._bundleContext.getService(serviceReference));
        }
        return resources;
    }

    private Object _convert(String value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (type == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (type == Byte.class) {
            return Byte.valueOf(value);
        }
        if (type == Character.class) {
            return Character.valueOf(value.charAt(0));
        }
        if (type == Date.class) {
            return this._dateParamConverter.fromString(value);
        }
        if (type == Double.class) {
            return Double.valueOf(value);
        }
        if (type == Float.class) {
            return Float.valueOf(value);
        }
        if (type == Integer.class) {
            return Integer.valueOf(value);
        }
        if (type == LocalDate.class) {
            return LocalDate.parse(value);
        }
        if (type == LocalDateTime.class) {
            return LocalDateTime.parse(value);
        }
        if (type == Long.class) {
            return Long.valueOf(value);
        }
        if (type == Short.class) {
            return Short.valueOf(value);
        }
        if (type == String.class) {
            return value;
        }
        throw new IllegalArgumentException(String.format("value %s cannot be converted to %s", value, type));
    }

    private Method _getAnnotatedMethod(Class<?> clazz, String fieldName) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            NestedField nestedField;
            if (!method.isAnnotationPresent(NestedField.class) || !Objects.equals(fieldName, (nestedField = method.getAnnotation(NestedField.class)).value())) continue;
            return method;
        }
        return null;
    }

    private Parameter[] _getBaseResourceClassMethodParameters(Class<?> clazz, Method implMethod) throws NoSuchMethodException {
        Class<?> baseResourceClass = clazz.getSuperclass();
        Method interfaceMethod = baseResourceClass.getMethod(implMethod.getName(), implMethod.getParameterTypes());
        return interfaceMethod.getParameters();
    }

    private Object _getContext(Class<?> contextClass, Message message) throws InvalidSyntaxException {
        ContextProvider contextProvider = this._getContextProvider(contextClass);
        if (contextProvider != null) {
            return contextProvider.createContext(message);
        }
        return null;
    }

    private ContextProvider _getContextProvider(Class<?> contextClass) throws InvalidSyntaxException {
        for (ContextProvider contextProvider : this.getContextProviders()) {
            if (!this._isRelevantContextProvider(contextClass, contextProvider)) continue;
            return contextProvider;
        }
        return null;
    }

    private Field _getField(Class<?> entityClass, String fieldName) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(entityClass.getDeclaredFields()));
        Class<?> superClass = entityClass.getSuperclass();
        if (superClass != null) {
            Collections.addAll(fields, superClass.getDeclaredFields());
        }
        for (Field field : fields) {
            if (!Objects.equals(field.getName(), fieldName) && !Objects.equals(field.getName(), "_" + fieldName)) continue;
            return field;
        }
        return null;
    }

    private Object _getFieldValue(String fieldName, NestedFieldsContext nestedFieldsContext) throws Exception {
        for (Object resource : this.getResources()) {
            Method method = this._getAnnotatedMethod(resource.getClass(), fieldName);
            if (method == null) continue;
            this._setResourceContexts(resource, nestedFieldsContext.getMessage());
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalAccessException("Method with the NestedField annotation must be defined in an abstract class");
            }
            Parameter[] parameters = this._getBaseResourceClassMethodParameters(resource.getClass(), method);
            Object[] args = this._getMethodArgs(fieldName, nestedFieldsContext, parameters);
            return method.invoke(resource, args);
        }
        return null;
    }

    private Object[] _getMethodArgs(String fieldName, NestedFieldsContext nestedFieldsContext, Parameter[] parameters) throws Exception {
        Object[] args = new Object[parameters.length];
        MultivaluedMap<String, String> pathParameters = nestedFieldsContext.getPathParameters();
        MultivaluedMap<String, String> queryParameters = nestedFieldsContext.getQueryParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Annotation[] annotations = parameter.getAnnotations();
            if (annotations.length == 0) continue;
            if (annotations[0] instanceof Context) {
                Message message = this._getNestedAwareMessage(fieldName, nestedFieldsContext.getMessage());
                args[i] = this._getContext(parameter.getType(), message);
                this._resetNestedAwareMessage(message);
                continue;
            }
            if (annotations[0] instanceof PathParam) {
                PathParam pathParam = (PathParam)annotations[0];
                args[i] = this._convert((String)pathParameters.getFirst((Object)pathParam.value()), parameter.getType());
                continue;
            }
            if (annotations[0] instanceof QueryParam) {
                QueryParam queryParam = (QueryParam)annotations[0];
                args[i] = this._convert((String)queryParameters.getFirst((Object)(fieldName + "." + queryParam.value())), parameter.getType());
                continue;
            }
            args[i] = null;
        }
        return args;
    }

    private Message _getNestedAwareMessage(String fieldName, Message message) {
        message.put((Object)"HTTP.REQUEST", (Object)new NestedFieldsHttpServletRequestWrapper(fieldName, this.getHttpServletRequest(message)));
        return message;
    }

    private Object _getReturnObject(Class<?> fieldType, Object result) {
        if (result instanceof Page) {
            Page page = (Page)result;
            result = page.getItems();
        }
        if (fieldType.isArray() && result instanceof Collection) {
            Collection collection = (Collection)result;
            result = Array.newInstance(fieldType.getComponentType(), collection.size());
            Iterator iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Array.set(result, i++, iterator.next());
            }
        }
        return result;
    }

    private <T> boolean _isRelevantContextProvider(Class<T> contextClass, ContextProvider contextProvider) {
        Type[] genericInterfaceTypes;
        Class<?> contextProviderClass = contextProvider.getClass();
        for (Type type : genericInterfaceTypes = contextProviderClass.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            Type[] typeArguments;
            if (!(type instanceof ParameterizedType) || (typeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments())[0] != contextClass) continue;
            return true;
        }
        return false;
    }

    private void _resetNestedAwareMessage(Message message) {
        NestedFieldsHttpServletRequestWrapper nestedFieldsHttpServletRequestWrapper = (NestedFieldsHttpServletRequestWrapper)((Object)message.getContextualProperty("HTTP.REQUEST"));
        message.put((Object)"HTTP.REQUEST", (Object)nestedFieldsHttpServletRequestWrapper.getRequest());
    }

    private void _setFieldValue(Object entity, NestedFieldsContext nestedFieldsContext) throws Exception {
        for (String fieldName : nestedFieldsContext.getFieldNames()) {
            Field field = this._getField(entity.getClass(), fieldName);
            if (field == null) continue;
            field.setAccessible(true);
            field.set(entity, this._getReturnObject(field.getType(), this._getFieldValue(fieldName, nestedFieldsContext)));
        }
    }

    private void _setResourceContexts(Object resource, Message message) throws Exception {
        Field[] fields;
        Class<?> resourceClass = resource.getClass();
        for (Field field : fields = resourceClass.getDeclaredFields()) {
            Annotation[] annotations = field.getAnnotations();
            if (annotations.length == 0 || !(annotations[0] instanceof Context)) continue;
            field.setAccessible(true);
            field.set(resource, this._getContext(field.getType(), message));
        }
    }
}

