/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.param.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ParamConverter;

public class DateParamConverter
implements ParamConverter<Date> {
    private static final String _DATE_PATTERN = "yyyy-MM-dd";
    private static final String _DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public Date fromString(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this._getPattern(string));
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException pe) {
            throw new WebApplicationException((Throwable)pe);
        }
    }

    public String toString(Date date) {
        return new SimpleDateFormat(_DATE_TIME_PATTERN).format(date);
    }

    private String _getPattern(String string) {
        if (string.contains("T")) {
            return _DATE_TIME_PATTERN;
        }
        return _DATE_PATTERN;
    }
}

