/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.searchAlgorithms;

import graphql.annotations.processor.exceptions.CannotCastMemberException;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.searchAlgorithms.SearchAlgorithm;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={SearchAlgorithm.class}, property={"type=field"}, immediate=true)
public class ParentalSearch
implements SearchAlgorithm {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;

    public ParentalSearch() {
    }

    public ParentalSearch(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
    }

    @Override
    public boolean isFound(Member member) throws CannotCastMemberException {
        Field field = this.CastToField(member);
        Boolean gqf = GraphQLObjectInfoRetriever.isGraphQLField(field);
        if (gqf != null) {
            return gqf;
        }
        Class<?> cls = field.getDeclaringClass();
        do {
            gqf = GraphQLObjectInfoRetriever.isGraphQLField(cls);
            if (gqf == null) continue;
            return gqf;
        } while ((cls = cls.getSuperclass()) != null);
        return false;
    }

    private Field CastToField(Member member) throws CannotCastMemberException {
        if (!(member instanceof Field)) {
            throw new CannotCastMemberException(member.getName(), "Field");
        }
        return (Field)member;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setGraphQLObjectInfoRetriever(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
    }

    public void unsetGraphQLObjectInfoRetriever(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever) {
        this.graphQLObjectInfoRetriever = null;
    }
}

