/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeBuilders;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLTypeResolver;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.CannotCastMemberException;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLExtensionsHandler;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.TypeResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class InterfaceBuilder {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;
    private GraphQLFieldRetriever graphQLFieldRetriever;
    private GraphQLExtensionsHandler extensionsHandler;

    public InterfaceBuilder(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever, GraphQLFieldRetriever graphQLFieldRetriever, GraphQLExtensionsHandler extensionsHandler) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
        this.graphQLFieldRetriever = graphQLFieldRetriever;
        this.extensionsHandler = extensionsHandler;
    }

    public GraphQLInterfaceType.Builder getInterfaceBuilder(Class<?> iface, ProcessingElementsContainer container) throws GraphQLAnnotationsException, IllegalArgumentException, CannotCastMemberException {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface();
        String typeName = this.graphQLObjectInfoRetriever.getTypeName(iface);
        builder.name(typeName);
        GraphQLDescription description = iface.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        ArrayList<String> definedFields = new ArrayList<String>();
        for (Method method : this.graphQLObjectInfoRetriever.getOrderedMethods(iface)) {
            boolean valid = !Modifier.isStatic(method.getModifiers()) && method.getAnnotation(GraphQLField.class) != null;
            if (!valid) continue;
            GraphQLFieldDefinition gqlField = this.graphQLFieldRetriever.getField(typeName, method, container);
            definedFields.add(gqlField.getName());
            builder.field(gqlField);
        }
        builder.fields(this.extensionsHandler.getExtensionFields(iface, definedFields, container));
        GraphQLTypeResolver typeResolver = iface.getAnnotation(GraphQLTypeResolver.class);
        container.getCodeRegistryBuilder().typeResolver(typeName, (TypeResolver)ReflectionKit.newInstance(typeResolver.value()));
        return builder;
    }
}

