/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.container.request.filter;

import com.liferay.petra.lang.SafeClosable;
import com.liferay.petra.reflect.AnnotationLocator;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import java.lang.reflect.Method;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptorChain;

@Provider
public class CTContainerRequestFilter
implements ContainerRequestFilter {
    private static final String _CT_COLLECTION_SAFE_CLOSABLE = CTPreInvokePhaseInterceptor.class.getName() + "#CT_COLLECTION_SAFE_CLOSABLE";
    private static final CTPostInvokePhaseInterceptor _CT_POST_INVOKE_PHASE_INTERCEPTOR = new CTPostInvokePhaseInterceptor();
    private static final CTPreInvokePhaseInterceptor _CT_PRE_INVOKE_PHASE_INTERCEPTOR = new CTPreInvokePhaseInterceptor();

    public void filter(ContainerRequestContext containerRequestContext) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        InterceptorChain interceptorChain = message.getInterceptorChain();
        interceptorChain.add((Interceptor)_CT_PRE_INVOKE_PHASE_INTERCEPTOR);
        interceptorChain.add((Interceptor)_CT_POST_INVOKE_PHASE_INTERCEPTOR);
    }

    private static class CTPreInvokePhaseInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public void handleMessage(Message message) {
            CTAware ctAware;
            Method method = (Method)message.get((Object)"org.apache.cxf.resource.method");
            if (method != null && !CTCollectionThreadLocal.isProductionMode() && ((ctAware = (CTAware)AnnotationLocator.locate((Method)method, method.getDeclaringClass(), CTAware.class)) == null || ctAware.onProduction())) {
                message.put((Object)_CT_COLLECTION_SAFE_CLOSABLE, (Object)CTCollectionThreadLocal.setCTCollectionId((long)0L));
            }
        }

        private CTPreInvokePhaseInterceptor() {
            super("pre-invoke");
        }
    }

    private static class CTPostInvokePhaseInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public void handleMessage(Message message) {
            SafeClosable safeClosable = (SafeClosable)message.get((Object)_CT_COLLECTION_SAFE_CLOSABLE);
            if (safeClosable != null) {
                safeClosable.close();
            }
        }

        private CTPostInvokePhaseInterceptor() {
            super("post-invoke");
        }
    }
}

