/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.context.provider;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.message.Message;

@Provider
public class FilterContextProvider
implements ContextProvider<Filter> {
    private static final Log _log = LogFactoryUtil.getLog(FilterContextProvider.class);
    private final ExpressionConvert<Filter> _expressionConvert;
    private final FilterParserProvider _filterParserProvider;
    private final Language _language;
    private final Portal _portal;

    public FilterContextProvider(ExpressionConvert<Filter> expressionConvert, FilterParserProvider filterParserProvider, Language language, Portal portal) {
        this._expressionConvert = expressionConvert;
        this._filterParserProvider = filterParserProvider;
        this._language = language;
        this._portal = portal;
    }

    public Filter createContext(AcceptLanguage acceptLanguage, EntityModel entityModel, String filterString) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Filter parameter value: " + filterString));
        }
        if (Validator.isNull((String)filterString)) {
            return null;
        }
        if (entityModel == null) {
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("OData entity model name: " + entityModel.getName()));
        }
        FilterParser filterParser = this._filterParserProvider.provide(entityModel);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("OData filter parser: " + filterParser));
        }
        com.liferay.portal.odata.filter.Filter oDataFilter = new com.liferay.portal.odata.filter.Filter(filterParser.parse(filterString));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("OData filter: " + oDataFilter));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Entity model: " + entityModel));
        }
        Filter filter = (Filter)this._expressionConvert.convert(oDataFilter.getExpression(), acceptLanguage.getPreferredLocale(), entityModel);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search filter: " + filter));
        }
        return filter;
    }

    public Filter createContext(Message message) {
        try {
            HttpServletRequest httpServletRequest = ContextProviderUtil.getHttpServletRequest(message);
            return this.createContext(new AcceptLanguageImpl(httpServletRequest, this._language, this._portal), ContextProviderUtil.getEntityModel(message), ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"filter"));
        }
        catch (ExpressionVisitException expressionVisitException) {
            throw new InvalidFilterException(expressionVisitException.getMessage(), (Throwable)expressionVisitException);
        }
        catch (InvalidFilterException invalidFilterException) {
            throw invalidFilterException;
        }
        catch (Exception exception) {
            throw new ServerErrorException(500, (Throwable)exception);
        }
    }
}

