/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.message.body;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.vulcan.internal.multipart.MultipartUtil;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;

@Consumes(value={"multipart/form-data"})
@Provider
public class MultipartBodyMessageBodyReader
implements MessageBodyReader<MultipartBody> {
    private static final Log _log = LogFactoryUtil.getLog(MultipartBodyMessageBodyReader.class);
    private final long _fileMaxSize;
    @Context
    private HttpServletRequest _httpServletRequest;
    @Context
    private ObjectMapper _objectMapper;
    @Context
    private Providers _providers;

    public MultipartBodyMessageBodyReader(long fileMaxSize) {
        this._fileMaxSize = fileMaxSize;
    }

    public boolean isReadable(Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public MultipartBody readFrom(Class<MultipartBody> clazz, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) {
        HashMap<String, String> values;
        HashMap<String, BinaryFile> binaryFiles;
        ContextResolver contextResolver;
        block11: {
            contextResolver = this._providers.getContextResolver(ObjectMapper.class, MediaType.MULTIPART_FORM_DATA_TYPE);
            binaryFiles = new HashMap<String, BinaryFile>();
            values = new HashMap<String, String>();
            try {
                Collection parts = this._httpServletRequest.getParts();
                if (parts != null && !parts.isEmpty()) {
                    for (Part part : parts) {
                        String fileName = MultipartUtil.getFileName(part);
                        if (fileName == null) {
                            values.put(part.getName(), Streams.asString((InputStream)part.getInputStream()));
                            continue;
                        }
                        binaryFiles.put(part.getName(), new BinaryFile(part.getContentType(), fileName, part.getInputStream(), part.getSize()));
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block11;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        if (binaryFiles.isEmpty() && values.isEmpty()) {
            try {
                ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                servletFileUpload.setFileSizeMax(this._fileMaxSize);
                servletFileUpload.setSizeMax(this._fileMaxSize);
                List fileItems = servletFileUpload.parseRequest(this._httpServletRequest);
                for (FileItem fileItem : fileItems) {
                    String name = fileItem.getFieldName();
                    if (fileItem.isFormField()) {
                        values.put(name, Streams.asString((InputStream)fileItem.getInputStream()));
                        continue;
                    }
                    binaryFiles.put(name, new BinaryFile(fileItem.getContentType(), fileItem.getName(), fileItem.getInputStream(), fileItem.getSize()));
                }
            }
            catch (FileUploadBase.SizeLimitExceededException sizeLimitExceededException) {
                throw new BadRequestException("Please enter a file with a valid file size no larger than " + this._fileMaxSize, (Throwable)sizeLimitExceededException);
            }
            catch (Exception exception) {
                throw new BadRequestException("Request body is not a valid multipart form", (Throwable)exception);
            }
        }
        return MultipartBody.of(binaryFiles, arg_0 -> ((ContextResolver)contextResolver).getContext(arg_0), values);
    }
}

