/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.validation;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.internal.jaxrs.validation.ValidatorFactory;
import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;

public class ValidationUtil {
    public static void validate(Object value) {
        Validator validator = ValidatorFactory.getValidator();
        Set constraintViolations = validator.validate(value, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            ValidationUtil._throwValidationException(constraintViolations);
        }
    }

    public static void validateArguments(Object resource, Method method, Object[] arguments) {
        Validator validator = ValidatorFactory.getValidator();
        ExecutableValidator executableValidator = validator.forExecutables();
        Set constraintViolations = executableValidator.validateParameters(resource, method, arguments, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            ValidationUtil._throwValidationException(constraintViolations);
        }
    }

    private static void _throwValidationException(Set<ConstraintViolation<Object>> constraintViolations) {
        StringBundler sb = new StringBundler(constraintViolations.size() * 4);
        for (ConstraintViolation<Object> constraintViolation : constraintViolations) {
            sb.append((Object)constraintViolation.getPropertyPath());
            sb.append(" ");
            sb.append(constraintViolation.getMessage());
            sb.append("\n");
        }
        throw new ValidationException(sb.toString());
    }
}

