/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.configuration.persistence.listener;

import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.internal.configuration.VulcanConfiguration;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.vulcan.internal.configuration.VulcanConfiguration"}, service={ConfigurationModelListener.class})
public class VulcanConfigurationModelListener
implements ConfigurationModelListener {
    private BundleContext _bundleContext;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ServiceComponentRuntime _serviceComponentRuntime;

    public void onAfterSave(String pid, Dictionary<String, Object> dictionary) {
        Collection componentDescriptionDTOs = this._serviceComponentRuntime.getComponentDescriptionDTOs(this._bundleContext.getBundles());
        block0: for (ComponentDescriptionDTO componentDescriptionDTO : componentDescriptionDTOs) {
            Map properties = componentDescriptionDTO.properties;
            Set entries = properties.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (!key.equals("osgi.jaxrs.application.base") || !value.equals(dictionary.get("path"))) continue;
                if (((Boolean)dictionary.get("restEnabled")).booleanValue()) {
                    this._serviceComponentRuntime.enableComponent(componentDescriptionDTO);
                    continue block0;
                }
                this._serviceComponentRuntime.disableComponent(componentDescriptionDTO);
                continue block0;
            }
        }
    }

    public void onBeforeSave(String pid, Dictionary<String, Object> dictionary) throws ConfigurationModelListenerException {
        try {
            String path = (String)dictionary.get("path");
            this._validatePathExists(path);
            this._validateUniqueConfiguration(path, dictionary);
        }
        catch (Exception exception) {
            throw new ConfigurationModelListenerException(exception.getMessage(), VulcanConfigurationModelListener.class, this.getClass(), dictionary);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private void _validatePathExists(String path) throws Exception {
        if (Validator.isNotNull((String)path)) {
            return;
        }
        throw new Exception(ResourceBundleUtil.getString((ResourceBundle)ResourceBundleUtil.getBundle((String)"content.Language", (Locale)LocaleThreadLocal.getThemeDisplayLocale(), this.getClass()), (String)"path-cannot-be-empty"));
    }

    private void _validateUniqueConfiguration(String path, Dictionary<String, Object> dictionary) throws Exception {
        Dictionary properties;
        Object servicePid;
        String filterString = String.format("(&(path=%s)(service.factoryPid=%s))", path, VulcanConfiguration.class.getName());
        Configuration[] configurations = this._configurationAdmin.listConfigurations(filterString);
        if (configurations == null) {
            return;
        }
        Configuration configuration = configurations[0];
        if (configuration != null && !(servicePid = (properties = configuration.getProperties()).get("service.pid")).equals(dictionary.get("service.pid"))) {
            configuration.delete();
        }
    }
}

