/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.context.provider;

import com.liferay.portal.vulcan.fields.FieldsQueryParam;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.message.Message;

@Provider
public class FieldsQueryParamContextProvider
implements ContextProvider<FieldsQueryParam> {
    public FieldsQueryParam createContext(Message message) {
        HttpServletRequest httpServletRequest = ContextProviderUtil.getHttpServletRequest(message);
        String fieldNamesString = httpServletRequest.getParameter("fields");
        if (fieldNamesString == null) {
            return () -> null;
        }
        if (fieldNamesString.isEmpty()) {
            return Collections::emptySet;
        }
        Stream<String> stream = Arrays.stream(fieldNamesString.split(","));
        Set fieldNames = stream.map(this::_toPaths).flatMap(Collection::stream).collect(Collectors.toSet());
        return () -> fieldNames;
    }

    private List<String> _toPaths(String string) {
        if (!string.contains(".")) {
            return Collections.singletonList(string);
        }
        ArrayList<String> list = new ArrayList<String>();
        String pending = string;
        while (!pending.equals("")) {
            list.add(pending);
            if (pending.contains(".")) {
                pending = pending.substring(0, pending.lastIndexOf("."));
                continue;
            }
            pending = "";
        }
        return list;
    }
}

