/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.context.provider;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.sort.InvalidSortException;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.message.Message;

@Provider
public class SortContextProvider
implements ContextProvider<Sort[]> {
    private static final Log _log = LogFactoryUtil.getLog(SortContextProvider.class);
    private final Language _language;
    private final Portal _portal;
    private final SortParserProvider _sortParserProvider;

    public SortContextProvider(Language language, Portal portal, SortParserProvider sortParserProvider) {
        this._language = language;
        this._portal = portal;
        this._sortParserProvider = sortParserProvider;
    }

    public Sort[] createContext(AcceptLanguage acceptLanguage, EntityModel entityModel, String sortString) {
        SortParser sortParser;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sort parameter value: " + sortString));
        }
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        if (_log.isDebugEnabled() && entityModel != null) {
            _log.debug((Object)("OData entity model name: " + entityModel.getName()));
        }
        if ((sortParser = this._sortParserProvider.provide(entityModel)) == null) {
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("OData sort parser: " + sortParser));
        }
        com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("OData sort: " + oDataSort));
        }
        List sortFields = oDataSort.getSortFields();
        Sort[] sorts = new Sort[sortFields.size()];
        for (int i = 0; i < sortFields.size(); ++i) {
            SortField sortField = (SortField)sortFields.get(i);
            sorts[i] = new Sort(sortField.getSortableFieldName(acceptLanguage.getPreferredLocale()), !sortField.isAscending());
        }
        return sorts;
    }

    public Sort[] createContext(Message message) {
        try {
            HttpServletRequest httpServletRequest = ContextProviderUtil.getHttpServletRequest(message);
            return this.createContext(new AcceptLanguageImpl(httpServletRequest, this._language, this._portal), ContextProviderUtil.getEntityModel(message), ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"sort"));
        }
        catch (InvalidSortException invalidSortException) {
            throw invalidSortException;
        }
        catch (Exception exception) {
            throw new ServerErrorException(500, (Throwable)exception);
        }
    }
}

