/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.context.resolver;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.vulcan.internal.jaxrs.serializer.JSONArrayStdSerializer;
import com.liferay.portal.vulcan.internal.jaxrs.serializer.JSONObjectStdSerializer;
import java.text.DateFormat;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

@Provider
public class ObjectMapperContextResolver
implements ContextResolver<ObjectMapper> {
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.enable(SerializationFeature.INDENT_OUTPUT);
            this.registerModule((Module)new SimpleModule(){
                {
                    this.addSerializer(JSONArray.class, (JsonSerializer)new JSONArrayStdSerializer(JSONArray.class));
                    this.addSerializer(JSONObject.class, (JsonSerializer)new JSONObjectStdSerializer(JSONObject.class));
                }
            });
            this.setDateFormat((DateFormat)new ISO8601DateFormat());
            this.setFilterProvider((FilterProvider)new SimpleFilterProvider(){
                {
                    this.addFilter("Liferay.Vulcan", SimpleBeanPropertyFilter.serializeAll());
                }
            });
            this.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        }
    };

    public ObjectMapper getContext(Class<?> clazz) {
        return _objectMapper;
    }
}

