/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.exception.mapper;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.vulcan.jaxrs.exception.mapper.BaseExceptionMapper;
import com.liferay.portal.vulcan.jaxrs.exception.mapper.Problem;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;

public class ExceptionMapper
extends BaseExceptionMapper<Exception> {
    private static final Log _log = LogFactoryUtil.getLog(ExceptionMapper.class);
    @Context
    private Providers _providers;

    public Response toResponse(Exception exception) {
        Throwable throwable = exception.getCause();
        if (throwable == null) {
            return super.toResponse((Throwable)exception);
        }
        javax.ws.rs.ext.ExceptionMapper exceptionMapper = this._providers.getExceptionMapper(throwable.getClass());
        if (exceptionMapper != null) {
            return exceptionMapper.toResponse(throwable);
        }
        return super.toResponse((Throwable)exception);
    }

    protected Problem getProblem(Exception exception) {
        _log.error((Object)exception, (Throwable)exception);
        return new Problem(Response.Status.INTERNAL_SERVER_ERROR, exception.getMessage());
    }
}

