/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.liferay.project.templates.ProjectTemplatesArgs;
import com.liferay.project.templates.internal.Archetyper;
import com.liferay.project.templates.internal.util.FileUtil;
import com.liferay.project.templates.internal.util.StringUtil;
import com.liferay.project.templates.internal.util.Validator;
import com.liferay.project.templates.internal.util.WorkspaceUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.maven.archetype.ArchetypeGenerationResult;

public class ProjectTemplates {
    public static final String TEMPLATE_BUNDLE_PREFIX = "com.liferay.project.templates.";
    private static final Set<PosixFilePermission> _wrapperPosixFilePermissions = PosixFilePermissions.fromString("rwxrwxr--");

    public static Map<String, String> getTemplates() throws Exception {
        TreeMap<String, String> templates = new TreeMap<String, String>();
        File file = FileUtil.getJarFile();
        if (file.isDirectory()) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(file.toPath(), "com.liferay.project.templates.*");){
                for (Path path : directoryStream) {
                    String template = String.valueOf(path.getFileName());
                    template = template.substring(TEMPLATE_BUNDLE_PREFIX.length(), template.lastIndexOf(45));
                    if ((template = template.replace('.', '-')).startsWith("workspace")) continue;
                    JarFile jarFile = new JarFile(path.toFile());
                    Throwable throwable = null;
                    try {
                        Manifest manifest = jarFile.getManifest();
                        Attributes attributes = manifest.getMainAttributes();
                        String bundleDescription = attributes.getValue("Bundle-Description");
                        templates.put(template, bundleDescription);
                    }
                    catch (Throwable manifest) {
                        throwable = manifest;
                        throw manifest;
                    }
                    finally {
                        if (jarFile == null) continue;
                        if (throwable != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable manifest) {
                                throwable.addSuppressed(manifest);
                            }
                            continue;
                        }
                        jarFile.close();
                    }
                }
            }
        }
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String template;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !(template = jarEntry.getName()).startsWith(TEMPLATE_BUNDLE_PREFIX)) continue;
                template = template.substring(TEMPLATE_BUNDLE_PREFIX.length(), template.indexOf("-"));
                if ((template = template.replace('.', '-')).startsWith("workspace")) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    JarInputStream jarInputStream = new JarInputStream(inputStream);
                    Throwable throwable2 = null;
                    try {
                        Manifest manifest = jarInputStream.getManifest();
                        Attributes attributes = manifest.getMainAttributes();
                        String bundleDescription = attributes.getValue("Bundle-Description");
                        templates.put(template, bundleDescription);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (jarInputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                jarInputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        jarInputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        return templates;
    }

    public static void main(String[] args) throws Exception {
        ProjectTemplatesArgs projectTemplatesArgs = new ProjectTemplatesArgs();
        JCommander jCommander = new JCommander(projectTemplatesArgs);
        try {
            File jarFile = FileUtil.getJarFile();
            if (jarFile.isFile()) {
                jCommander.setProgramName("java -jar " + jarFile.getName());
            } else {
                jCommander.setProgramName(ProjectTemplates.class.getName());
            }
            jCommander.parse(args);
            if (projectTemplatesArgs.isHelp()) {
                ProjectTemplates._printHelp(jCommander);
            } else if (projectTemplatesArgs.isList()) {
                ProjectTemplates._printList();
            } else {
                new ProjectTemplates(projectTemplatesArgs);
            }
        }
        catch (ParameterException pe) {
            System.err.println(pe.getMessage());
            ProjectTemplates._printHelp(jCommander);
        }
    }

    public ProjectTemplates(ProjectTemplatesArgs projectTemplatesArgs) throws Exception {
        Exception cause;
        this._checkArgs(projectTemplatesArgs);
        File destinationDir = projectTemplatesArgs.getDestinationDir();
        Archetyper archetyper = new Archetyper();
        ArchetypeGenerationResult archetypeGenerationResult = archetyper.generateProject(projectTemplatesArgs, destinationDir);
        if (archetypeGenerationResult != null && (cause = archetypeGenerationResult.getCause()) != null) {
            throw cause;
        }
        Path templateDirPath = destinationDir.toPath();
        templateDirPath = templateDirPath.resolve(projectTemplatesArgs.getName());
        if (WorkspaceUtil.isWorkspace(destinationDir)) {
            Files.deleteIfExists(templateDirPath.resolve("settings.gradle"));
        } else {
            if (projectTemplatesArgs.isGradle()) {
                FileUtil.extractDirectory("gradle-wrapper", templateDirPath);
                FileUtil.setPosixFilePermissions(templateDirPath.resolve("gradlew"), _wrapperPosixFilePermissions);
            }
            if (projectTemplatesArgs.isMaven()) {
                FileUtil.extractDirectory("maven-wrapper", templateDirPath);
                FileUtil.setPosixFilePermissions(templateDirPath.resolve("mvnw"), _wrapperPosixFilePermissions);
            }
        }
        if (!projectTemplatesArgs.isGradle()) {
            FileUtil.deleteFiles(templateDirPath, "build.gradle", "settings.gradle");
        }
        if (!projectTemplatesArgs.isMaven()) {
            FileUtil.deleteFiles(templateDirPath, "pom.xml");
        }
    }

    private static void _printHelp(JCommander jCommander) throws Exception {
        System.out.println();
        System.out.println("Create a new Liferay module project from several available templates:");
        Map<String, String> templates = ProjectTemplates.getTemplates();
        int lineLength = 0;
        Set<String> templateNames = templates.keySet();
        Iterator<String> iterator = templateNames.iterator();
        while (iterator.hasNext()) {
            String template = iterator.next();
            if (lineLength + template.length() + 1 > jCommander.getColumnSize()) {
                System.out.println();
                lineLength = 0;
            }
            System.out.print(template);
            lineLength += template.length();
            if (!iterator.hasNext()) continue;
            System.out.print(", ");
            lineLength += 2;
        }
        System.out.println();
        System.out.println();
        jCommander.usage();
    }

    private static void _printList() throws Exception {
        Map<String, String> templates = ProjectTemplates.getTemplates();
        for (String template : templates.keySet()) {
            System.out.println(template + " - " + templates.get(template));
        }
    }

    private void _checkArgs(ProjectTemplatesArgs projectTemplatesArgs) {
        String contributorType;
        String[] fileNames;
        if (Validator.isNull(projectTemplatesArgs.getAuthor())) {
            throw new IllegalArgumentException("Author is required");
        }
        String template = projectTemplatesArgs.getTemplate();
        if (Validator.isNull(projectTemplatesArgs.getTemplate())) {
            throw new IllegalArgumentException("Template is required");
        }
        String name = projectTemplatesArgs.getName();
        if (Validator.isNull(name) && !template.equals("workspace")) {
            throw new IllegalArgumentException("Name is required");
        }
        File destinationDir = projectTemplatesArgs.getDestinationDir();
        if (destinationDir == null) {
            throw new IllegalArgumentException("Destination dir is required");
        }
        File dir = destinationDir;
        if (Validator.isNotNull(name)) {
            dir = new File(dir, name);
        }
        if (!projectTemplatesArgs.isForce() && dir.exists() && ((fileNames = dir.list()) == null || fileNames.length > 0)) {
            throw new IllegalArgumentException(dir + " is not empty or it is a file");
        }
        String className = projectTemplatesArgs.getClassName();
        if (Validator.isNull(className) && Validator.isNotNull(name)) {
            className = this._getClassName(name);
        }
        if (template.equals("activator") && !className.endsWith("Activator")) {
            className = className + "Activator";
        } else if ((template.equals("freemarker-portlet") || template.equals("mvc-portlet") || template.equals("spring-mvc-portlet") || template.equals("portlet")) && className.length() > 7 && className.endsWith("Portlet")) {
            className = className.substring(0, className.length() - 7);
        }
        projectTemplatesArgs.setClassName(className);
        if (Validator.isNull(projectTemplatesArgs.getPackageName()) && Validator.isNotNull(name)) {
            projectTemplatesArgs.setPackageName(this._getPackageName(name));
        }
        if (Validator.isNull(contributorType = projectTemplatesArgs.getContributorType())) {
            projectTemplatesArgs.setContributorType(name);
        }
    }

    private String _getCapitalizedName(String name) {
        name = name.replace('-', ' ');
        name = name.replace('.', ' ');
        return StringUtil.capitalize(name, ' ');
    }

    private String _getClassName(String name) {
        name = this._getCapitalizedName(name);
        return StringUtil.removeChar(name, ' ');
    }

    private String _getPackageName(String name) {
        name = name.replace('-', '.');
        name = name.replace(' ', '.');
        return name.toLowerCase();
    }
}

