/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.internal.util;

import com.liferay.project.templates.ProjectTemplates;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileUtil {
    public static void deleteDir(Path dirPath) throws IOException {
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioe) throws IOException {
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteFiles(Path dirPath, final String ... fileNames) throws IOException {
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                for (String fileName : fileNames) {
                    Files.deleteIfExists(dirPath.resolve(fileName));
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void extractDirectory(String dirName, final Path destinationDirPath) throws Exception {
        File file = FileUtil.getJarFile();
        if (file.isDirectory()) {
            Path jarDirPath = file.toPath();
            final Path rootDirPath = jarDirPath.resolve(dirName);
            Files.walkFileTree(rootDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path relativePath = rootDirPath.relativize(path);
                    String fileName = relativePath.toString();
                    Path destinationPath = destinationDirPath.resolve(fileName);
                    Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
                    Files.copy(path, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            try (JarFile jarFile = new JarFile(file);){
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String name;
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory() || !(name = jarEntry.getName()).startsWith(dirName + "/")) continue;
                    String fileName = name.substring(dirName.length() + 1);
                    Path destinationPath = destinationDirPath.resolve(fileName);
                    Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    Throwable throwable = null;
                    try {
                        Files.copy(inputStream, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
        }
    }

    public static Path getFile(Path dirPath, String glob) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath, glob);){
            Iterator<Path> iterator = directoryStream.iterator();
            if (iterator.hasNext()) {
                Path path = iterator.next();
                return path;
            }
        }
        return null;
    }

    public static File getJarFile() throws Exception {
        ProtectionDomain protectionDomain = ProjectTemplates.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL url = codeSource.getLocation();
        return new File(url.toURI());
    }

    public static Path getRootDir(Path dirPath, String markerFileName) {
        do {
            if (!Files.exists(dirPath.resolve(markerFileName), new LinkOption[0])) continue;
            return dirPath;
        } while ((dirPath = dirPath.getParent()) != null);
        return null;
    }

    public static String read(Path path) throws IOException {
        String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        return content.replace("\r\n", "\n");
    }

    public static Properties readProperties(Path path) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            properties.load(inputStream);
        }
        return properties;
    }

    public static void setPosixFilePermissions(Path path, Set<PosixFilePermission> posixFilePermissions) throws IOException {
        try {
            Files.setPosixFilePermissions(path, posixFilePermissions);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

