/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.internal.util;

import com.liferay.project.templates.internal.util.FileUtil;
import com.liferay.project.templates.internal.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class WorkspaceUtil {
    public static final String WORKSPACE = "workspace";
    private static final String _BUILD_GRADLE_FILE_NAME = "build.gradle";
    private static final String _SETTINGS_GRADLE_FILE_NAME = "settings.gradle";
    private static final Pattern _pattern = Pattern.compile("apply\\s+plugin\\s*:\\s*['\"]com\\.liferay\\.workspace['\"]");

    public static File getWorkspaceDir(File dir) throws IOException {
        Path rootDirPath = FileUtil.getRootDir(dir.toPath(), _SETTINGS_GRADLE_FILE_NAME);
        if (rootDirPath == null) {
            return null;
        }
        String settingsGradle = FileUtil.read(rootDirPath.resolve(_SETTINGS_GRADLE_FILE_NAME));
        if (StringUtil.contains(settingsGradle, _pattern)) {
            return rootDirPath.toFile();
        }
        Path buildGradlePath = rootDirPath.resolve(_BUILD_GRADLE_FILE_NAME);
        if (Files.notExists(buildGradlePath, new LinkOption[0])) {
            return null;
        }
        String buildGradle = FileUtil.read(buildGradlePath);
        if (StringUtil.contains(buildGradle, _pattern)) {
            return rootDirPath.toFile();
        }
        return null;
    }

    public static boolean isWorkspace(File dir) throws IOException {
        File workspaceDir = WorkspaceUtil.getWorkspaceDir(dir);
        return workspaceDir != null;
    }
}

