Liferay.Loader.define("questions-web@1.0.52/js/App.es", ['module', 'exports', 'require', '@questions-web$apollo/client', 'frontend-js-react-web$react', 'questions-web$react-router-dom', './AppContext.es', './components/ErrorBoundary.es', './components/ForumsToQuestion.es', './components/ProtectedRoute.es', './pages/NavigationBar.es', './pages/answers/EditAnswer.es', './pages/home/Home', './pages/home/UserActivity.es', './pages/home/UserSubscriptions.es', './pages/questions/EditQuestion.es', './pages/questions/NewQuestion.es', './pages/questions/Question.es', './pages/questions/Questions.es', './pages/tags/Tags.es', './utils/client.es', './utils/utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _client = require("@questions-web$apollo/client");

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("questions-web$react-router-dom");

    var _AppContext = require("./AppContext.es");

    var _ErrorBoundary = require("./components/ErrorBoundary.es");

    var _ForumsToQuestion = _interopRequireDefault(require("./components/ForumsToQuestion.es"));

    var _ProtectedRoute = _interopRequireDefault(require("./components/ProtectedRoute.es"));

    var _NavigationBar = _interopRequireDefault(require("./pages/NavigationBar.es"));

    var _EditAnswer = _interopRequireDefault(require("./pages/answers/EditAnswer.es"));

    var _Home = _interopRequireDefault(require("./pages/home/Home"));

    var _UserActivity = _interopRequireDefault(require("./pages/home/UserActivity.es"));

    var _UserSubscriptions = _interopRequireDefault(require("./pages/home/UserSubscriptions.es"));

    var _EditQuestion = _interopRequireDefault(require("./pages/questions/EditQuestion.es"));

    var _NewQuestion = _interopRequireDefault(require("./pages/questions/NewQuestion.es"));

    var _Question = _interopRequireDefault(require("./pages/questions/Question.es"));

    var _Questions = _interopRequireDefault(require("./pages/questions/Questions.es"));

    var _Tags = _interopRequireDefault(require("./pages/tags/Tags.es"));

    var _client2 = require("./utils/client.es");

    var _utils = require("./utils/utils.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var _default = function _default(props) {
      (function redirectForNotifications() {
        if (window.location.search) {
          var urlSearchParams = new URLSearchParams(window.location.search);
          var redirectTo = urlSearchParams.get('redirectTo');

          if (redirectTo) {
            window.history.replaceState({}, document.title, (0, _utils.getFullPath)() + decodeURIComponent(redirectTo));
          }
        }
      })();
      return _react["default"].createElement(_AppContext.AppContextProvider, props, _react["default"].createElement(_client.ApolloProvider, {
        client: _client2.client
      }, _react["default"].createElement(_reactRouterDom.HashRouter, null, _react["default"].createElement(_ErrorBoundary.ErrorBoundary, null, _react["default"].createElement("div", null, _react["default"].createElement(_NavigationBar["default"], null), _react["default"].createElement(_reactRouterDom.Switch, null, _react["default"].createElement(_reactRouterDom.Route, {
        component: _Home["default"],
        exact: true,
        path: "/"
      }), _react["default"].createElement(_reactRouterDom.Route, {
        component: _Home["default"],
        exact: true,
        path: "/questions"
      }), _react["default"].createElement(_reactRouterDom.Route, {
        component: _ForumsToQuestion["default"],
        exact: true,
        path: "/question/:questionId"
      }), _react["default"].createElement(_reactRouterDom.Route, {
        component: _UserActivity["default"],
        exact: true,
        path: "/activity/:creatorId"
      }), _react["default"].createElement(_reactRouterDom.Route, {
        component: _UserSubscriptions["default"],
        exact: true,
        path: "/subscriptions/:creatorId"
      }), _react["default"].createElement(_reactRouterDom.Route, {
        component: _Questions["default"],
        exact: true,
        path: "/questions/tag/:tag"
      }), _react["default"].createElement(_reactRouterDom.Route, {
        component: _Tags["default"],
        exact: true,
        path: "/tags"
      }), _react["default"].createElement(_reactRouterDom.Route, {
        path: "/questions/:sectionTitle",
        render: function render(_ref) {
          var path = _ref.match.path;
          return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_reactRouterDom.Switch, null, _react["default"].createElement(_ProtectedRoute["default"], {
            component: _EditAnswer["default"],
            exact: true,
            path: "".concat(path, "/:questionId/answers/:answerId/edit")
          }), _react["default"].createElement(_reactRouterDom.Route, {
            component: _Questions["default"],
            exact: true,
            path: "".concat(path, "/creator/:creatorId")
          }), _react["default"].createElement(_reactRouterDom.Route, {
            component: _Questions["default"],
            exact: true,
            path: "".concat(path, "/tag/:tag")
          }), _react["default"].createElement(_ProtectedRoute["default"], {
            component: _NewQuestion["default"],
            exact: true,
            path: "".concat(path, "/new")
          }), _react["default"].createElement(_reactRouterDom.Route, {
            component: _Question["default"],
            exact: true,
            path: "".concat(path, "/:questionId")
          }), _react["default"].createElement(_ProtectedRoute["default"], {
            component: _EditQuestion["default"],
            exact: true,
            path: "".concat(path, "/:questionId/edit")
          }), _react["default"].createElement(_reactRouterDom.Route, {
            component: _Questions["default"],
            exact: true,
            path: "".concat(path, "/")
          })));
        }
      })))))));
    };

    exports["default"] = _default;
    //# sourceMappingURL=App.es.js.map
  }
});
//# sourceMappingURL=App.es.js.map