Liferay.Loader.define("questions-web@1.0.52/js/components/Breadcrumb.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$react', 'questions-web$react-router-dom', '../AppContext.es', '../utils/client.es', '../utils/utils.es', './BreadcrumbNode.es', './NewTopicModal.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("questions-web$react-router-dom");

    var _AppContext = require("../AppContext.es");

    var _client = require("../utils/client.es");

    var _utils = require("../utils/utils.es");

    var _BreadcrumbNode = _interopRequireDefault(require("./BreadcrumbNode.es"));

    var _NewTopicModal = _interopRequireDefault(require("./NewTopicModal.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
      var allowCreateTopicInRootTopic = _ref.allowCreateTopicInRootTopic,
          history = _ref.history,
          section = _ref.section;
      var context = (0, _react.useContext)(_AppContext.AppContext);
      var rootTopicId = context.rootTopicId;

      var historyPushParser = (0, _utils.historyPushWithSlug)(history.push);

      var _useState = (0, _react.useState)([]),
          _useState2 = _slicedToArray(_useState, 2),
          breadcrumbNodes = _useState2[0],
          setBreadcrumbNodes = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          visible = _useState4[0],
          setVisible = _useState4[1];

      var getSubSections = function getSubSections(section) {
        return section && section.messageBoardSections && section.messageBoardSections.items || [];
      };

      var createEllipsisSectionData = function createEllipsisSectionData() {
        var sections = breadcrumbNodes.slice(1, breadcrumbNodes.length - 1).map(function (section) {
          return {
            id: section.id,
            title: section.title
          };
        });
        return {
          subSections: sections,
          title: ''
        };
      };

      var findParent = function findParent(messageBoardSectionId) {
        return _client.client.query({
          query: _client.getSectionQuery,
          variables: {
            messageBoardSectionId: messageBoardSectionId
          }
        }).then(function (_ref2) {
          var data = _ref2.data;
          return data.messageBoardSection;
        });
      };

      var buildBreadcrumbNodesData = (0, _react.useCallback)(function (rootSection, section) {
        var acc = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
        acc.push({
          id: section.id,
          subSections: getSubSections(section),
          title: section.title
        });

        if (+rootSection !== +section.id) {
          if (section.parentMessageBoardSectionId) {
            if (section.parentMessageBoardSection) {
              return Promise.resolve(buildBreadcrumbNodesData(rootSection, section.parentMessageBoardSection, acc));
            }

            return findParent(section.parentMessageBoardSectionId).then(function (section) {
              return buildBreadcrumbNodesData(rootSection, section, acc);
            });
          }
        }

        return +rootSection === 0 ? Promise.resolve((0, _client.getSectionByRootSection)(context.siteKey, rootSection).then(function (data) {
          acc.push({
            id: data.id,
            subSections: data.messageBoardSections.items,
            title: rootSection
          });
          return acc.reverse();
        })).then(acc) : Promise.resolve(acc.reverse());
      }, [context.siteKey]);
      (0, _react.useEffect)(function () {
        if (!section) {
          return;
        }

        buildBreadcrumbNodesData(rootTopicId, section).then(function (acc) {
          return setBreadcrumbNodes(acc);
        });
      }, [buildBreadcrumbNodesData, rootTopicId, section]);
      return _react["default"].createElement("section", {
        className: "align-items-center d-flex mb-0 questions-breadcrumb"
      }, _react["default"].createElement("ol", {
        className: "breadcrumb m-0"
      }, breadcrumbNodes.length > 3 ? _react["default"].createElement(function ShortenedBreadcrumb() {
        return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_BreadcrumbNode["default"], {
          hasDropdown: !context.showCardsForTopicNavigation,
          isFirstNode: true,
          section: breadcrumbNodes[0],
          ui: _react["default"].createElement(_icon["default"], {
            symbol: "home-full"
          })
        }), _react["default"].createElement(_BreadcrumbNode["default"], {
          hasDropdown: true,
          isEllipsis: true,
          section: createEllipsisSectionData()
        }), _react["default"].createElement(_BreadcrumbNode["default"], {
          hasDropdown: true,
          section: breadcrumbNodes[breadcrumbNodes.length - 1]
        }));
      }, null) : _react["default"].createElement(function AllBreadcrumb() {
        return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_BreadcrumbNode["default"], {
          hasDropdown: !context.showCardsForTopicNavigation,
          isFirstNode: true,
          section: breadcrumbNodes[0],
          ui: _react["default"].createElement(_icon["default"], {
            symbol: "home-full"
          })
        }), breadcrumbNodes.filter(function (section) {
          return section.title;
        }).slice(1, breadcrumbNodes.length).map(function (section, i) {
          return _react["default"].createElement(_BreadcrumbNode["default"], {
            hasDropdown: true,
            key: i,
            section: section,
            ui: section.title
          });
        }));
      }, null)), (section && section.actions && section.actions['add-subcategory'] || allowCreateTopicInRootTopic) && _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_NewTopicModal["default"], {
        currentSectionId: section && section.id,
        onClose: function onClose() {
          return setVisible(false);
        },
        onCreateNavigateTo: function onCreateNavigateTo(topic) {
          return historyPushParser("/questions/".concat((0, _utils.stringToSlug)(topic)));
        },
        visible: visible
      }), _react["default"].createElement(_button["default"], {
        className: "breadcrumb-button c-ml-3 c-p-2",
        displayType: "unstyled",
        onClick: function onClick() {
          return setVisible(true);
        }
      }, _react["default"].createElement(_icon["default"], {
        className: "c-mr-2",
        symbol: "plus"
      }), Liferay.Language.get('new-topic'))));
    });

    exports["default"] = _default;
    //# sourceMappingURL=Breadcrumb.es.js.map
  }
});
//# sourceMappingURL=Breadcrumb.es.js.map