Liferay.Loader.define("questions-web@1.0.52/js/components/Comments.es", ['module', 'exports', 'require', '@questions-web$apollo/client', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$react', 'questions-web$react-router-dom', '../utils/client.es', '../utils/utils.es', './Comment.es', './QuestionsEditor', './TextLengthValidation.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _client = require("@questions-web$apollo/client");

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _form = _interopRequireDefault(require("@frontend-taglib-clay$clayui/form"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("questions-web$react-router-dom");

    var _client2 = require("../utils/client.es");

    var _utils = require("../utils/utils.es");

    var _Comment = _interopRequireDefault(require("./Comment.es"));

    var _QuestionsEditor = _interopRequireDefault(require("./QuestionsEditor"));

    var _TextLengthValidation = _interopRequireDefault(require("./TextLengthValidation.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
      var comments = _ref.comments,
          commentsChange = _ref.commentsChange,
          _ref$editable = _ref.editable,
          editable = _ref$editable === void 0 ? true : _ref$editable,
          entityId = _ref.entityId,
          _ref$match$params = _ref.match.params,
          questionId = _ref$match$params.questionId,
          sectionTitle = _ref$match$params.sectionTitle,
          showNewComment = _ref.showNewComment,
          showNewCommentChange = _ref.showNewCommentChange;

      var _useState = (0, _react.useState)(''),
          _useState2 = _slicedToArray(_useState, 2),
          comment = _useState2[0],
          setComment = _useState2[1];

      var _useMutation = (0, _client.useMutation)(_client2.createCommentQuery, {
        context: (0, _utils.getContextLink)("".concat(sectionTitle, "/").concat(questionId)),
        onCompleted: function onCompleted(data) {
          setComment('');
          showNewCommentChange(false);
          commentsChange([].concat(_toConsumableArray(comments), [data.createMessageBoardMessageMessageBoardMessage]));
        }
      }),
          _useMutation2 = _slicedToArray(_useMutation, 1),
          createComment = _useMutation2[0];

      var _commentChange = (0, _react.useCallback)(function (comment) {
        if (commentsChange) {
          return commentsChange(_toConsumableArray(comments.filter(function (o) {
            return o.id !== comment.id;
          })));
        }

        return null;
      }, [commentsChange, comments]);

      return _react["default"].createElement("div", null, comments.map(function (comment) {
        return _react["default"].createElement(_Comment["default"], {
          comment: comment,
          commentChange: _commentChange,
          editable: editable,
          key: comment.id
        });
      }), editable && showNewComment && _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_form["default"].Group, {
        small: true
      }, _react["default"].createElement(_QuestionsEditor["default"], {
        contents: comment,
        onChange: function onChange(event) {
          setComment(event.editor.getData());
        }
      }), _react["default"].createElement(_TextLengthValidation["default"], {
        text: comment
      }), _react["default"].createElement(_button["default"].Group, {
        className: "c-mt-3",
        spaced: true
      }, _react["default"].createElement(_button["default"], {
        disabled: (0, _utils.stripHTML)(comment).length < 15,
        displayType: "primary",
        onClick: function onClick() {
          createComment({
            variables: {
              articleBody: comment,
              parentMessageBoardMessageId: entityId
            }
          });
        }
      }, Liferay.Language.get('reply')), _react["default"].createElement(_button["default"], {
        displayType: "secondary",
        onClick: function onClick() {
          return showNewCommentChange(false);
        }
      }, Liferay.Language.get('cancel'))))));
    });

    exports["default"] = _default;
    //# sourceMappingURL=Comments.es.js.map
  }
});
//# sourceMappingURL=Comments.es.js.map