Liferay.Loader.define("questions-web@1.0.52/js/components/Highlight.es", ['module', 'exports', 'require', 'questions-web$highlight.js', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _highlight = _interopRequireDefault(require("questions-web$highlight.js"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function Highlight(props) {
      var children = props.children,
          Element = props.element,
          innerHTML = props.innerHTML;
      var el = (0, _react.useRef)(null);

      _highlight["default"].configure({
        languages: ['language-java', 'language-javascript', 'html', 'plaintext']
      });

      (0, _react.useEffect)(function highlightCode() {
        if (el.current) {
          var nodes = el.current.querySelectorAll('pre code');

          for (var i = 0; i < nodes.length; i++) {
            _highlight["default"].highlightBlock(nodes[i]);
          }
        }
      });
      var elProps = {
        ref: el
      };

      if (innerHTML) {
        elProps.dangerouslySetInnerHTML = {
          __html: children
        };

        if (Element) {
          return _react["default"].createElement(Element, elProps);
        }

        return _react["default"].createElement("div", elProps);
      }

      if (Element) {
        return _react["default"].createElement(Element, elProps, children);
      }

      return _react["default"].createElement("pre", {
        ref: el
      }, _react["default"].createElement("code", null, children));
    }

    var _default = Highlight;
    exports["default"] = _default;
    //# sourceMappingURL=Highlight.es.js.map
  }
});
//# sourceMappingURL=Highlight.es.js.map