Liferay.Loader.define("questions-web@1.0.52/js/components/QuestionRow.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../utils/utils.es', './ArticleBodyRenderer.es', './Link.es', './QuestionsBadge.es', './SectionLabel.es', './TagList.es', './UserIcon.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _dropDown = require("@frontend-taglib-clay$clayui/drop-down");

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _utils = require("../utils/utils.es");

    var _ArticleBodyRenderer = _interopRequireDefault(require("./ArticleBodyRenderer.es"));

    var _Link = _interopRequireDefault(require("./Link.es"));

    var _QuestionsBadge = _interopRequireDefault(require("./QuestionsBadge.es"));

    var _SectionLabel = _interopRequireDefault(require("./SectionLabel.es"));

    var _TagList = _interopRequireDefault(require("./TagList.es"));

    var _UserIcon = _interopRequireDefault(require("./UserIcon.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    var _default = function _default(_ref) {
      var currentSection = _ref.currentSection,
          items = _ref.items,
          question = _ref.question,
          showSectionLabel = _ref.showSectionLabel;
      var sectionTitle = currentSection || currentSection === '0' ? currentSection : question.messageBoardSection && question.messageBoardSection.title;
      return _react["default"].createElement("div", {
        className: "c-mt-4 c-p-3 position-relative question-row text-secondary"
      }, _react["default"].createElement("div", {
        className: "align-items-center d-flex flex-wrap justify-content-between"
      }, _react["default"].createElement("span", null, showSectionLabel && _react["default"].createElement(_SectionLabel["default"], {
        section: question.messageBoardSection
      })), _react["default"].createElement("ul", {
        className: "c-mb-0 d-flex flex-wrap list-unstyled stretched-link-layer"
      }, _react["default"].createElement("li", null, _react["default"].createElement(_QuestionsBadge["default"], {
        symbol: (0, _utils.normalizeRating)(question.aggregateRating) < 0 ? 'caret-bottom' : 'caret-top',
        tooltip: Liferay.Language.get('votes'),
        value: (0, _utils.normalizeRating)(question.aggregateRating)
      })), _react["default"].createElement("li", null, _react["default"].createElement(_QuestionsBadge["default"], {
        symbol: "view",
        tooltip: Liferay.Language.get('view-count'),
        value: question.viewCount
      })), _react["default"].createElement("li", {
        "data-testid": "has-valid-answer-badge"
      }, _react["default"].createElement(_QuestionsBadge["default"], {
        className: question.hasValidAnswer ? 'alert-success border-0' : '',
        symbol: question.hasValidAnswer ? 'check-circle-full' : 'message',
        tooltip: Liferay.Language.get('number-of-replies'),
        value: question.numberOfMessageBoardMessages
      })), items && items.length && _react["default"].createElement("li", null, _react["default"].createElement(_dropDown.ClayDropDownWithItems, {
        className: "c-py-1",
        items: items,
        trigger: _react["default"].createElement(_button.ClayButtonWithIcon, {
          displayType: "unstyled",
          small: true,
          symbol: "ellipsis-v"
        })
      })))), _react["default"].createElement(_Link["default"], {
        className: "questions-title stretched-link",
        to: "/questions/".concat(sectionTitle, "/").concat(question.friendlyUrlPath)
      }, _react["default"].createElement("h2", {
        className: (0, _classnames["default"])('c-mb-0', 'stretched-link-layer', 'text-dark', {
          'question-seen': question.seen
        })
      }, question.headline, !!question.locked && _react["default"].createElement("span", {
        className: "c-ml-2"
      }, _react["default"].createElement(_icon["default"], {
        symbol: "lock"
      })))), _react["default"].createElement("div", {
        className: "c-mb-0 c-mt-3 question-row-article-body stretched-link-layer text-truncate"
      }, _react["default"].createElement(_ArticleBodyRenderer["default"], _extends({}, question, {
        articleBody: (0, _utils.stripHTML)(question.articleBody),
        compactMode: true
      }))), _react["default"].createElement("div", {
        className: "align-items-sm-center align-items-start d-flex flex-column-reverse flex-sm-row justify-content-between"
      }, _react["default"].createElement("div", {
        className: "c-mt-3 c-mt-sm-0 stretched-link-layer"
      }, _react["default"].createElement(_Link["default"], {
        to: "/questions/".concat(sectionTitle, "/creator/").concat(question.creator.id)
      }, _react["default"].createElement(_UserIcon["default"], {
        fullName: question.creator.name,
        portraitURL: question.creator.image,
        size: "sm",
        userId: String(question.creator.id)
      }), _react["default"].createElement("strong", {
        className: "c-ml-2 text-dark"
      }, question.creator.name)), _react["default"].createElement("span", {
        className: "c-ml-2 small"
      }, '- ' + (0, _utils.dateToInternationalHuman)(question.dateModified))), _react["default"].createElement(_TagList["default"], {
        sectionTitle: sectionTitle,
        tags: question.keywords
      })));
    };

    exports["default"] = _default;
    //# sourceMappingURL=QuestionRow.es.js.map
  }
});
//# sourceMappingURL=QuestionRow.es.js.map