Liferay.Loader.define("questions-web@1.0.52/js/components/QuestionsEditor", ['module', 'exports', 'require', 'frontend-editor-ckeditor-web', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$react', '../AppContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getCKEditorConfig = getCKEditorConfig;
    exports["default"] = void 0;

    var _frontendEditorCkeditorWeb = require("frontend-editor-ckeditor-web");

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = require("../AppContext.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    var getToolbarSet = function getToolbarSet(toolbarSet) {
      if ((0, _frontendJsWeb.isPhone)()) {
        toolbarSet = 'phone';
      } else if ((0, _frontendJsWeb.isTablet)()) {
        toolbarSet = 'tablet';
      }

      return toolbarSet;
    };

    function getCKEditorConfig() {
      var config = {
        allowedContent: true,
        codeSnippet_languages: {
          html: 'HTML',
          java: 'Java',
          javascript: 'JavaScript'
        },
        codeSnippet_theme: 'monokai_sublime',
        extraPlugins: 'codesnippet,itemselector',
        height: 216,
        removePlugins: 'elementspath',
        tabSpaces: 4
      };
      config.toolbar = [['Bold', 'Italic', 'Underline', 'Strike'], ['NumberedList', 'BulletedList'], ['Outdent', 'Indent'], ['Blockquote'], ['CodeSnippet', 'ImageSelector'], ['Link', 'Unlink'], ['Undo', 'Redo'], ['Source']];
      return config;
    }

    var QuestionsEditor = function QuestionsEditor(_ref) {
      var _ref$contents = _ref.contents,
          contents = _ref$contents === void 0 ? '' : _ref$contents,
          cssClass = _ref.cssClass,
          _ref$editorConfig = _ref.editorConfig,
          editorConfig = _ref$editorConfig === void 0 ? {} : _ref$editorConfig,
          initialToolbarSet = _ref.initialToolbarSet,
          props = _objectWithoutProperties(_ref, ["contents", "cssClass", "editorConfig", "initialToolbarSet"]);

      var editorRef = (0, _react.useRef)();
      var context = (0, _react.useContext)(_AppContext.AppContext);

      var _useState = (0, _react.useState)(initialToolbarSet),
          _useState2 = _slicedToArray(_useState, 2),
          toolbarSet = _useState2[0],
          setToolbarSet = _useState2[1];

      var config = (0, _react.useMemo)(function () {
        return _objectSpread({
          toolbar: toolbarSet
        }, getCKEditorConfig(), {}, editorConfig);
      }, [editorConfig, toolbarSet]);
      (0, _react.useEffect)(function () {
        setToolbarSet(getToolbarSet(initialToolbarSet));
      }, [initialToolbarSet]);
      (0, _frontendJsReactWeb.useEventListener)('resize', function () {
        return setToolbarSet(getToolbarSet(initialToolbarSet));
      }, true, window);

      var insertTextAtCursor = function insertTextAtCursor(el, text) {
        var val = el.value;
        var endIndex;
        var range;

        if (typeof el.selectionStart != 'undefined' && typeof el.selectionEnd != 'undefined') {
          endIndex = el.selectionEnd;
          el.value = val.slice(0, el.selectionStart) + text + val.slice(endIndex);
          el.selectionStart = el.selectionEnd = endIndex + text.length;
        } else if (typeof document.selection != 'undefined' && typeof document.selection.createRange != 'undefined') {
          el.focus();
          range = document.selection.createRange();
          range.collapse(false);
          range.text = text;
          range.select();
        }
      };

      return _react["default"].createElement("div", {
        className: cssClass,
        id: "".concat(name, "Container")
      }, _react["default"].createElement(_frontendEditorCkeditorWeb.Editor, _extends({
        className: "lfr-editable",
        config: config,
        data: contents,
        key: toolbarSet,
        onBeforeLoad: function onBeforeLoad(CKEDITOR) {
          if (CKEDITOR) {
            CKEDITOR.disableAutoInline = true;

            if (!CKEDITOR.plugins.externals) {
              CKEDITOR.plugins.addExternal('tab', '/plugins/tab/plugin.js');
            }

            CKEDITOR.getNextZIndex = function () {
              return 1000;
            };

            CKEDITOR.dtd.$removeEmpty.i = 0;
            CKEDITOR.dtd.$removeEmpty.span = 0;
            CKEDITOR.on('instanceCreated', function (_ref2) {
              var editor = _ref2.editor;
              editor.name = name;

              if (context.imageBrowseURL) {
                editor.config.filebrowserImageBrowseUrl = context.imageBrowseURL.replace('EDITOR_NAME_', name);
              }

              editor.on('dialogShow', function (_ref3) {
                var data = _ref3.data;

                if (data._.name === 'codeSnippet') {
                  var _data$_$contents$info = data._.contents.info,
                      code = _data$_$contents$info.code,
                      lang = _data$_$contents$info.lang;
                  document.getElementById(lang._.inputId).value = 'java';
                  var textarea = document.getElementById(code._.inputId);

                  textarea.onkeydown = function (ev) {
                    if (ev.keyCode === 9) {
                      insertTextAtCursor(textarea, '    ');
                      ev.preventDefault();
                      ev.stopPropagation();
                      return false;
                    }
                  };
                }
              });
            });
          }
        },
        ref: editorRef
      }, props)));
    };

    var _default = QuestionsEditor;
    exports["default"] = _default;
    //# sourceMappingURL=QuestionsEditor.js.map
  }
});
//# sourceMappingURL=QuestionsEditor.js.map