Liferay.Loader.define("questions-web@1.0.52/js/components/Rating.es", ['module', 'exports', 'require', '@questions-web$apollo/client', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$react', '../utils/client.es', '../utils/utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _client = require("@questions-web$apollo/client");

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _client2 = require("../utils/client.es");

    var _utils = require("../utils/utils.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var _default = function _default(_ref) {
      var aggregateRating = _ref.aggregateRating,
          _ref$disabled = _ref.disabled,
          disabled = _ref$disabled === void 0 ? false : _ref$disabled,
          entityId = _ref.entityId,
          myRating = _ref.myRating,
          type = _ref.type;

      var _useState = (0, _react.useState)(0),
          _useState2 = _slicedToArray(_useState, 2),
          userRating = _useState2[0],
          setUserRating = _useState2[1];

      var _useState3 = (0, _react.useState)(0),
          _useState4 = _slicedToArray(_useState3, 2),
          rating = _useState4[0],
          setRating = _useState4[1];

      (0, _react.useEffect)(function () {
        setRating((0, _utils.normalizeRating)(aggregateRating));
      }, [aggregateRating]);
      (0, _react.useEffect)(function () {
        setUserRating(myRating === null ? 0 : (0, _utils.normalize)(myRating));
      }, [myRating]);

      var _useMutation = (0, _client.useMutation)(_client2.createVoteMessageQuery),
          _useMutation2 = _slicedToArray(_useMutation, 1),
          createVoteMessage = _useMutation2[0];

      var _useMutation3 = (0, _client.useMutation)(_client2.createVoteThreadQuery),
          _useMutation4 = _slicedToArray(_useMutation3, 1),
          createVoteThread = _useMutation4[0];

      var voteChange = function voteChange(value) {
        if (userRating === value) {
          return;
        }

        var newUserRating = userRating + value;
        var normalizedValue = (userRating + value + 1) / 2;
        setUserRating(newUserRating);
        setRating(rating - userRating + newUserRating);

        if (type === 'Thread') {
          createVoteThread({
            variables: {
              messageBoardThreadId: entityId,
              ratingValue: normalizedValue
            }
          });
        } else {
          createVoteMessage({
            variables: {
              messageBoardMessageId: entityId,
              ratingValue: normalizedValue
            }
          });
        }
      };

      return _react["default"].createElement("div", {
        className: "align-items-center d-inline-flex flex-md-column justify-content-center text-secondary"
      }, _react["default"].createElement(_button["default"], {
        className: 'text-reset' + (userRating === 1 ? ' text-primary' : ''),
        disabled: disabled,
        displayType: "unstyled",
        monospaced: true,
        onClick: function onClick() {
          return voteChange(1);
        }
      }, _react["default"].createElement(_icon["default"], {
        symbol: "caret-top"
      })), _react["default"].createElement("span", {
        className: "c-px-2"
      }, rating || 0), _react["default"].createElement(_button["default"], {
        className: 'text-reset' + (userRating === -1 ? ' text-primary' : ''),
        disabled: disabled,
        displayType: "unstyled",
        monospaced: true,
        onClick: function onClick() {
          return voteChange(-1);
        }
      }, _react["default"].createElement(_icon["default"], {
        symbol: "caret-bottom"
      })));
    };

    exports["default"] = _default;
    //# sourceMappingURL=Rating.es.js.map
  }
});
//# sourceMappingURL=Rating.es.js.map