Liferay.Loader.define("questions-web@1.0.52/js/components/RelatedQuestions.es", ['module', 'exports', 'require', '@questions-web$apollo/client', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', 'questions-web$react-router-dom', '../AppContext.es', '../utils/client.es', '../utils/utils.es', './Link.es', './QuestionsBadge.es', './SectionLabel.es', './UserIcon.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _client = require("@questions-web$apollo/client");

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("questions-web$react-router-dom");

    var _AppContext = require("../AppContext.es");

    var _client2 = require("../utils/client.es");

    var _utils = require("../utils/utils.es");

    var _Link = _interopRequireDefault(require("./Link.es"));

    var _QuestionsBadge = _interopRequireDefault(require("./QuestionsBadge.es"));

    var _SectionLabel = _interopRequireDefault(require("./SectionLabel.es"));

    var _UserIcon = _interopRequireDefault(require("./UserIcon.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
      var sectionTitle = _ref.match.params.sectionTitle,
          question = _ref.question;
      var context = (0, _react.useContext)(_AppContext.AppContext);

      var _useQuery = (0, _client.useQuery)(_client2.getRelatedThreadsQuery, {
        variables: {
          search: question && question.headline,
          siteKey: context.siteKey
        }
      }),
          data = _useQuery.data;

      return _react["default"].createElement(_react["default"].Fragment, null, data && !!data.messageBoardThreads.items.length && _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("h2", {
        className: "c-mt-5 font-weight-light h3 text-secondary"
      }, "Related Questions"), _react["default"].createElement("hr", null), _react["default"].createElement("div", {
        className: "row"
      }, data.messageBoardThreads.items.filter(function (otherQuestion) {
        return otherQuestion.id !== question.id;
      }).map(function (relatedQuestion) {
        return _react["default"].createElement("div", {
          className: "col-lg-3 col-md-4 col-sm-6 p-3 position-relative",
          key: relatedQuestion.id
        }, _react["default"].createElement("div", {
          className: "align-items-center d-flex justify-content-between stretched-link-layer"
        }, _react["default"].createElement(_SectionLabel["default"], {
          section: relatedQuestion.messageBoardSection
        }), _react["default"].createElement(_QuestionsBadge["default"], {
          className: "text-secondary",
          symbol: (0, _utils.normalizeRating)(question.aggregateRating) < 0 ? 'caret-bottom' : 'caret-top',
          value: (0, _utils.normalizeRating)(relatedQuestion.aggregateRating)
        })), _react["default"].createElement(_Link["default"], {
          className: "c-mt-2 d-block questions-title stretched-link text-reset",
          to: "/questions/".concat(sectionTitle, "/").concat(relatedQuestion.friendlyUrlPath)
        }, _react["default"].createElement("h3", {
          className: (0, _classnames["default"])('h2', 'stretched-link-layer', {
            'question-seen': relatedQuestion.seen
          })
        }, relatedQuestion.headline, !!relatedQuestion.locked && _react["default"].createElement("span", {
          className: "c-ml-2"
        }, _react["default"].createElement(_icon["default"], {
          symbol: "lock"
        })))), _react["default"].createElement("div", {
          className: "c-mt-3 small stretched-link-layer"
        }, _react["default"].createElement(_UserIcon["default"], {
          fullName: relatedQuestion.creator.name,
          portraitURL: relatedQuestion.creator.image,
          size: "sm",
          userId: String(relatedQuestion.creator.id)
        }), _react["default"].createElement("span", {
          className: "c-ml-2 font-weight-bold"
        }, relatedQuestion.creator.name), _react["default"].createElement("span", {
          className: "text-secondary"
        }, ' - ' + (0, _utils.dateToInternationalHuman)(relatedQuestion.dateModified))));
      }))));
    });

    exports["default"] = _default;
    //# sourceMappingURL=RelatedQuestions.es.js.map
  }
});
//# sourceMappingURL=RelatedQuestions.es.js.map