Liferay.Loader.define("questions-web@1.0.52/js/pages/home/UserActivity.es", ['module', 'exports', 'require', '@questions-web$apollo/client', 'frontend-js-react-web$react', 'questions-web$react-router-dom', '../../AppContext.es', '../../components/PaginatedList.es', '../../components/QuestionRow.es', '../../components/UserIcon.es', '../../hooks/useQueryParams.es', '../../utils/client.es', '../../utils/utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _client = require("@questions-web$apollo/client");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("questions-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    var _PaginatedList = _interopRequireDefault(require("../../components/PaginatedList.es"));

    var _QuestionRow = _interopRequireDefault(require("../../components/QuestionRow.es"));

    var _UserIcon = _interopRequireDefault(require("../../components/UserIcon.es"));

    var _useQueryParams = _interopRequireDefault(require("../../hooks/useQueryParams.es"));

    var _client2 = require("../../utils/client.es");

    var _utils = require("../../utils/utils.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
      var history = _ref.history,
          location = _ref.location,
          creatorId = _ref.match.params.creatorId;
      var context = (0, _react.useContext)(_AppContext.AppContext);
      var historyPushParser = (0, _utils.historyPushWithSlug)(history.push);
      var queryParams = (0, _useQueryParams["default"])(location);
      var siteKey = context.siteKey;

      var _useState = (0, _react.useState)(1),
          _useState2 = _slicedToArray(_useState, 2),
          page = _useState2[0],
          setPage = _useState2[1];

      var _useState3 = (0, _react.useState)(20),
          _useState4 = _slicedToArray(_useState3, 2),
          pageSize = _useState4[0],
          setPageSize = _useState4[1];

      (0, _react.useEffect)(function () {
        var pageNumber = queryParams.get('page') || 1;
        setPage(isNaN(pageNumber) ? 1 : parseInt(pageNumber, 10));
      }, [queryParams]);
      (0, _react.useEffect)(function () {
        setPageSize(queryParams.get('pagesize') || 20);
      }, [queryParams]);

      var _useQuery = (0, _client.useQuery)(_client2.getUserActivityQuery, {
        variables: {
          filter: "creatorId eq ".concat(creatorId),
          page: page,
          pageSize: pageSize,
          siteKey: siteKey
        }
      }),
          data = _useQuery.data,
          loading = _useQuery.loading;

      var creatorInfo = {
        id: creatorId,
        image: null,
        name: decodeURI(JSON.parse("\"".concat(Liferay.ThemeDisplay.getUserName(), "\""))),
        postsNumber: 0,
        rank: context.defaultRank
      };

      if (data && data.messageBoardThreads.items && data.messageBoardThreads.items.length) {
        var _data$messageBoardThr = data.messageBoardThreads.items[0],
            creator = _data$messageBoardThr.creator,
            creatorStatistics = _data$messageBoardThr.creatorStatistics;
        creatorInfo = {
          id: creatorId,
          image: creator.image,
          name: creator.name,
          postsNumber: creatorStatistics.postsNumber,
          rank: creatorStatistics.rank
        };
      }

      var _changePage = function changePage(page, pageSize) {
        historyPushParser("/activity/".concat(creatorId, "?page=").concat(page, "&pagesize=").concat(pageSize));
      };

      return _react["default"].createElement("section", {
        className: "questions-section questions-section-list"
      }, _react["default"].createElement("div", {
        className: "questions-container"
      }, _react["default"].createElement("div", {
        className: "c-p-5 row"
      }, _react["default"].createElement("div", {
        className: "c-mt-3 c-mx-auto c-px-0 col-xl-10"
      }, _react["default"].createElement("div", {
        className: "d-flex flex-row"
      }, _react["default"].createElement("div", {
        className: "c-mt-3"
      }, _react["default"].createElement(_UserIcon["default"], {
        fullName: creatorInfo.name,
        portraitURL: creatorInfo.image,
        size: "xl",
        userId: String(creatorInfo.id)
      })), _react["default"].createElement("div", {
        className: "c-ml-4 flex-column"
      }, _react["default"].createElement("div", null, _react["default"].createElement("span", {
        className: "small"
      }, "Rank: ", creatorInfo.rank)), _react["default"].createElement("div", null, _react["default"].createElement("strong", {
        className: "h2"
      }, creatorInfo.name)), _react["default"].createElement("div", null, _react["default"].createElement("span", {
        className: "small"
      }, "Posts: ", creatorInfo.postsNumber)))), _react["default"].createElement("div", {
        className: "border-bottom c-mt-5"
      }, _react["default"].createElement("h2", null, "Latest Questions Asked"))), _react["default"].createElement("div", {
        className: "c-mx-auto c-px-0 col-xl-10"
      }, _react["default"].createElement(_PaginatedList["default"], {
        activeDelta: pageSize,
        activePage: page,
        changeDelta: function changeDelta(pageSize) {
          return _changePage(page, pageSize);
        },
        changePage: function changePage(page) {
          return _changePage(page, pageSize);
        },
        data: data && data.messageBoardThreads,
        loading: loading
      }, function (question) {
        return _react["default"].createElement(_QuestionRow["default"], {
          currentSection: context.useTopicNamesInURL ? question.messageBoardSection && question.messageBoardSection.title : question.messageBoardSection && question.messageBoardSection.id || context.rootTopicId,
          key: question.id,
          question: question,
          showSectionLabel: true
        });
      })))));
    });

    exports["default"] = _default;
    //# sourceMappingURL=UserActivity.es.js.map
  }
});
//# sourceMappingURL=UserActivity.es.js.map