Liferay.Loader.define("questions-web@1.0.52/js/pages/home/UserSubscriptions.es", ['module', 'exports', 'require', '@questions-web$apollo/client', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/empty-state', 'frontend-js-react-web$react', 'questions-web$react-router-dom', '../../AppContext.es', '../../components/Alert.es', '../../components/DeleteQuestion.es', '../../components/Link.es', '../../components/QuestionRow.es', '../../utils/client.es', '../../utils/utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _client = require("@questions-web$apollo/client");

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _dropDown = require("@frontend-taglib-clay$clayui/drop-down");

    var _emptyState = _interopRequireDefault(require("@frontend-taglib-clay$clayui/empty-state"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("questions-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    var _Alert = _interopRequireDefault(require("../../components/Alert.es"));

    var _DeleteQuestion = _interopRequireDefault(require("../../components/DeleteQuestion.es"));

    var _Link = _interopRequireDefault(require("../../components/Link.es"));

    var _QuestionRow = _interopRequireDefault(require("../../components/QuestionRow.es"));

    var _client2 = require("../../utils/client.es");

    var _utils = require("../../utils/utils.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
      var history = _ref.history;

      var _useState = (0, _react.useState)({}),
          _useState2 = _slicedToArray(_useState, 2),
          entity = _useState2[0],
          setEntity = _useState2[1];

      var _useState3 = (0, _react.useState)({}),
          _useState4 = _slicedToArray(_useState3, 2),
          info = _useState4[0],
          setInfo = _useState4[1];

      var _useState5 = (0, _react.useState)({}),
          _useState6 = _slicedToArray(_useState5, 2),
          questionToDelete = _useState6[0],
          setQuestionToDelete = _useState6[1];

      var context = (0, _react.useContext)(_AppContext.AppContext);

      var _useQuery = (0, _client.useQuery)(_client2.getSubscriptionsQuery, {
        fetchPolicy: 'network-only',
        variables: {
          contentType: 'MessageBoardThread'
        }
      }),
          threads = _useQuery.data,
          refetchThreads = _useQuery.refetch;

      var _useQuery2 = (0, _client.useQuery)(_client2.getSubscriptionsQuery, {
        fetchPolicy: 'network-only',
        variables: {
          contentType: 'MessageBoardSection'
        }
      }),
          topics = _useQuery2.data,
          refetchTopics = _useQuery2.refetch;

      var _useMutation = (0, _client.useMutation)(_client2.unsubscribeMyUserAccountQuery, {
        onCompleted: function onCompleted() {
          refetchThreads();
          refetchTopics();
          setInfo({
            title: 'You have unsubscribed from this asset successfully.'
          });
        }
      }),
          _useMutation2 = _slicedToArray(_useMutation, 1),
          unsubscribe = _useMutation2[0];

      (0, _react.useEffect)(function () {
        if (entity.title) {
          _client2.client.cache.evict("MessageBoardSection:".concat(entity.id));
        } else {
          _client2.client.cache.evict("MessageBoardThread:".concat(entity.id));
        }

        _client2.client.cache.gc();
      }, [entity]);

      var _useState7 = (0, _react.useState)(false),
          _useState8 = _slicedToArray(_useState7, 2),
          showDeleteModalPanel = _useState8[0],
          setShowDeleteModalPanel = _useState8[1];

      var historyPushParser = (0, _utils.historyPushWithSlug)(history.push);

      var actions = function actions(data) {
        var question = data.graphQLNode;
        var actions = [{
          label: 'Unsubscribe',
          onClick: function onClick() {
            setEntity(_objectSpread({}, data.graphQLNode));
            unsubscribe({
              variables: {
                subscriptionId: data.id
              }
            });
          }
        }];

        if (question.actions && question.actions["delete"]) {
          actions.push({
            label: 'Delete',
            onClick: function onClick() {
              setQuestionToDelete(question);
              setShowDeleteModalPanel(true);
            }
          });
        }

        if (question.actions && question.actions.replace) {
          actions.push({
            label: 'Edit',
            onClick: function onClick() {
              historyPushParser("/questions/".concat(context.useTopicNamesInURL ? question.messageBoardSection.title : question.messageBoardSection.id, "/").concat(data.graphQLNode.friendlyUrlPath, "/edit"));
            }
          });
        }

        if (question.headline) {
          actions.push({
            label: 'Reply',
            onClick: function onClick() {
              historyPushParser("/questions/".concat(context.useTopicNamesInURL ? question.messageBoardSection.title : question.messageBoardSection.id, "/").concat(question.friendlyUrlPath));
            }
          });
        }

        return actions;
      };

      return _react["default"].createElement("section", {
        className: "questions-section questions-section-list"
      }, _react["default"].createElement("div", {
        className: "c-p-5 questions-container row"
      }, _react["default"].createElement("div", {
        className: "col-xl-8 offset-xl-2"
      }, _react["default"].createElement("h2", {
        className: "sheet-subtitle"
      }, "Topics"), topics && topics.myUserAccountSubscriptions.items && !topics.myUserAccountSubscriptions.items.length && _react["default"].createElement(_emptyState["default"], {
        title: Liferay.Language.get('there-are-no-results')
      }), _react["default"].createElement("div", {
        className: "row"
      }, topics && topics.myUserAccountSubscriptions.items && topics.myUserAccountSubscriptions.items.map(function (data) {
        return _react["default"].createElement("div", {
          className: "col-md-4 question-tags",
          key: data.graphQLNode.id
        }, _react["default"].createElement("div", {
          className: "card card-interactive card-interactive-primary card-type-template template-card-horizontal"
        }, _react["default"].createElement("div", {
          className: "card-body"
        }, _react["default"].createElement("div", {
          className: "card-row"
        }, _react["default"].createElement("div", {
          className: "autofit-col autofit-col-expand"
        }, _react["default"].createElement(_Link["default"], {
          title: data.graphQLNode.title,
          to: "/questions/".concat(context.useTopicNamesInURL ? data.graphQLNode.title : data.graphQLNode.id)
        }, _react["default"].createElement("div", {
          className: "autofit-section"
        }, _react["default"].createElement("div", {
          className: "card-title"
        }, _react["default"].createElement("span", {
          className: "text-truncate"
        }, data.graphQLNode.title))))), _react["default"].createElement("div", {
          className: "autofit-col"
        }, _react["default"].createElement(_dropDown.ClayDropDownWithItems, {
          items: actions(data),
          trigger: _react["default"].createElement(_button.ClayButtonWithIcon, {
            displayType: "unstyled",
            small: true,
            symbol: "ellipsis-v"
          })
        }))))));
      })), _react["default"].createElement("h2", {
        className: "mt-5 sheet-subtitle"
      }, "Questions"), _react["default"].createElement("div", null, threads && threads.myUserAccountSubscriptions.items && !threads.myUserAccountSubscriptions.items.length && _react["default"].createElement(_emptyState["default"], {
        title: Liferay.Language.get('there-are-no-results')
      }), threads && threads.myUserAccountSubscriptions.items && threads.myUserAccountSubscriptions.items.map(function (data) {
        return _react["default"].createElement("div", {
          key: data.id
        }, _react["default"].createElement(_QuestionRow["default"], {
          currentSection: context.useTopicNamesInURL ? data.graphQLNode.messageBoardSection && data.graphQLNode.messageBoardSection.title : data.graphQLNode.messageBoardSection && data.graphQLNode.messageBoardSection.id || context.rootTopicId,
          items: actions(data),
          question: data.graphQLNode,
          showSectionLabel: true
        }));
      }), _react["default"].createElement(_DeleteQuestion["default"], {
        deleteModalVisibility: showDeleteModalPanel,
        question: questionToDelete,
        setDeleteModalVisibility: setShowDeleteModalPanel
      })))), _react["default"].createElement(_Alert["default"], {
        displayType: 'success',
        info: info
      }));
    });

    exports["default"] = _default;
    //# sourceMappingURL=UserSubscriptions.es.js.map
  }
});
//# sourceMappingURL=UserSubscriptions.es.js.map