Liferay.Loader.define("questions-web@1.0.52/js/pages/questions/NewQuestion.es", ['module', 'exports', 'require', '@questions-web$apollo/client', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$react', 'questions-web$react-router-dom', '../../AppContext.es', '../../components/Alert.es', '../../components/Link.es', '../../components/QuestionsEditor', '../../components/TagSelector.es', '../../components/TextLengthValidation.es', '../../utils/client.es', '../../utils/lang.es', '../../utils/utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _client = require("@questions-web$apollo/client");

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("questions-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    var _Alert = _interopRequireDefault(require("../../components/Alert.es"));

    var _Link = _interopRequireDefault(require("../../components/Link.es"));

    var _QuestionsEditor = _interopRequireDefault(require("../../components/QuestionsEditor"));

    var _TagSelector = _interopRequireDefault(require("../../components/TagSelector.es"));

    var _TextLengthValidation = _interopRequireDefault(require("../../components/TextLengthValidation.es"));

    var _client2 = require("../../utils/client.es");

    var _lang = _interopRequireDefault(require("../../utils/lang.es"));

    var _utils = require("../../utils/utils.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
      var history = _ref.history,
          sectionTitle = _ref.match.params.sectionTitle;

      var _useState = (0, _react.useState)(''),
          _useState2 = _slicedToArray(_useState, 2),
          articleBody = _useState2[0],
          setArticleBody = _useState2[1];

      var _useState3 = (0, _react.useState)(''),
          _useState4 = _slicedToArray(_useState3, 2),
          headline = _useState4[0],
          setHeadline = _useState4[1];

      var _useState5 = (0, _react.useState)({}),
          _useState6 = _slicedToArray(_useState5, 2),
          error = _useState6[0],
          setError = _useState6[1];

      var _useState7 = (0, _react.useState)(),
          _useState8 = _slicedToArray(_useState7, 2),
          sectionId = _useState8[0],
          setSectionId = _useState8[1];

      var _useState9 = (0, _react.useState)([]),
          _useState10 = _slicedToArray(_useState9, 2),
          sections = _useState10[0],
          setSections = _useState10[1];

      var _useState11 = (0, _react.useState)([]),
          _useState12 = _slicedToArray(_useState11, 2),
          tags = _useState12[0],
          setTags = _useState12[1];

      var _useState13 = (0, _react.useState)(true),
          _useState14 = _slicedToArray(_useState13, 2),
          tagsLoaded = _useState14[0],
          setTagsLoaded = _useState14[1];

      var context = (0, _react.useContext)(_AppContext.AppContext);
      var historyPushParser = (0, _utils.historyPushWithSlug)(history.push);

      var _useDebounceCallback = (0, _utils.useDebounceCallback)(function () {
        return historyPushParser("/questions/".concat(sectionTitle, "/"));
      }, 500),
          _useDebounceCallback2 = _slicedToArray(_useDebounceCallback, 1),
          debounceCallback = _useDebounceCallback2[0];

      var _useMutation = (0, _client.useMutation)(_client2.createQuestionInASectionQuery, {
        context: (0, _utils.getContextLink)(sectionTitle),
        onCompleted: function onCompleted() {
          _client2.client.resetStore();

          debounceCallback();
        }
      }),
          _useMutation2 = _slicedToArray(_useMutation, 1),
          createQuestionInASection = _useMutation2[0];

      var _useMutation3 = (0, _client.useMutation)(_client2.createQuestionInRootQuery, {
        context: (0, _utils.getContextLink)(sectionTitle),
        onCompleted: function onCompleted() {
          _client2.client.resetStore();

          debounceCallback();
        }
      }),
          _useMutation4 = _slicedToArray(_useMutation3, 1),
          createQuestionInRoot = _useMutation4[0];

      (0, _react.useEffect)(function () {
        (0, _client2.getSectionBySectionTitle)(context.siteKey, (0, _utils.slugToText)(sectionTitle)).then(function (section) {
          setSectionId(section && section.id || +context.rootTopicId);

          if (section.parentMessageBoardSection) {
            setSections([{
              id: section.parentMessageBoardSection.id,
              title: section.parentMessageBoardSection.title
            }].concat(_toConsumableArray(section.parentMessageBoardSection.messageBoardSections.items), _toConsumableArray(section.messageBoardSections.items)));
          } else {
            setSections([{
              id: section.id,
              title: section.title
            }].concat(_toConsumableArray(section.messageBoardSections.items)));
          }
        });
      }, [context.rootTopicId, context.siteKey, sectionTitle]);

      var processError = function processError(error) {
        if (error.message && error.message.includes('AssetTagException')) {
          error.message = _lang["default"].sub(Liferay.Language.get('the-x-cannot-contain-the-following-invalid-characters-x'), ['Tag', ' & \' @ \\\\ ] } : , = > / < \\n [ {  | + # ` ? \\" \\r ; / * ~']);
        }

        setError(error);
      };

      var createQuestion = function createQuestion() {
        if (sectionTitle === context.rootTopicId && +context.rootTopicId === 0) {
          createQuestionInRoot({
            variables: {
              articleBody: articleBody,
              headline: headline,
              keywords: tags.map(function (tag) {
                return tag.label;
              }),
              siteKey: context.siteKey
            }
          })["catch"](processError);
        } else {
          createQuestionInASection({
            variables: {
              articleBody: articleBody,
              headline: headline,
              keywords: tags.map(function (tag) {
                return tag.label;
              }),
              messageBoardSectionId: sectionId
            }
          })["catch"](processError);
        }
      };

      return _react["default"].createElement("section", {
        className: "c-mt-5 questions-section questions-section-new"
      }, _react["default"].createElement("div", {
        className: "questions-container"
      }, _react["default"].createElement("div", {
        className: "row"
      }, _react["default"].createElement("div", {
        className: "c-mx-auto col-xl-10"
      }, _react["default"].createElement("h1", null, Liferay.Language.get('new-question')), _react["default"].createElement(_form["default"], {
        className: "c-mt-5"
      }, _react["default"].createElement(_form["default"].Group, null, _react["default"].createElement("label", {
        htmlFor: "basicInput"
      }, Liferay.Language.get('title'), _react["default"].createElement("span", {
        className: "c-ml-2 reference-mark"
      }, _react["default"].createElement(_icon["default"], {
        symbol: "asterisk"
      }))), _react["default"].createElement(_form.ClayInput, {
        maxLength: 75,
        onChange: function onChange(event) {
          return setHeadline(event.target.value);
        },
        placeholder: Liferay.Language.get('what-is-your-question'),
        required: true,
        type: "text",
        value: headline
      }), _react["default"].createElement(_form["default"].FeedbackGroup, null, _react["default"].createElement(_form["default"].FeedbackItem, null, _react["default"].createElement("span", {
        className: "small text-secondary"
      }, Liferay.Language.get('be-specific-and-imagine-you-are-asking-a-question-to-another-person'))))), _react["default"].createElement(_form["default"].Group, {
        className: "c-mt-4"
      }, _react["default"].createElement("label", {
        htmlFor: "basicInput"
      }, Liferay.Language.get('body'), _react["default"].createElement("span", {
        className: "c-ml-2 reference-mark"
      }, _react["default"].createElement(_icon["default"], {
        symbol: "asterisk"
      }))), _react["default"].createElement(_QuestionsEditor["default"], {
        onChange: function onChange(event) {
          setArticleBody(event.editor.getData());
        }
      }), _react["default"].createElement(_form["default"].FeedbackGroup, null, _react["default"].createElement(_form["default"].FeedbackItem, null, _react["default"].createElement("span", {
        className: "small text-secondary"
      }, Liferay.Language.get('include-all-the-information-someone-would-need-to-answer-your-question')), _react["default"].createElement(_TextLengthValidation["default"], {
        text: articleBody
      })))), sections.length > 1 && _react["default"].createElement(_form["default"].Group, {
        className: "c-mt-4"
      }, _react["default"].createElement("label", {
        htmlFor: "basicInput"
      }, Liferay.Language.get('topic')), _react["default"].createElement(_form.ClaySelect, {
        onChange: function onChange(event) {
          return setSectionId(event.target.value);
        }
      }, sections.map(function (_ref2) {
        var id = _ref2.id,
            title = _ref2.title;
        return _react["default"].createElement(_form.ClaySelect.Option, {
          key: id,
          label: title,
          selected: sectionId === id,
          value: id
        });
      }))), _react["default"].createElement(_TagSelector["default"], {
        className: "c-mt-3",
        tags: tags,
        tagsChange: function tagsChange(tags) {
          return setTags(tags);
        },
        tagsLoaded: setTagsLoaded
      })), _react["default"].createElement("div", {
        className: "c-mt-4 d-flex flex-column-reverse flex-sm-row"
      }, _react["default"].createElement(_button["default"], {
        className: "c-mt-4 c-mt-sm-0",
        disabled: !articleBody || !headline || !tagsLoaded || (0, _utils.stripHTML)(articleBody).length < 15,
        displayType: "primary",
        onClick: function onClick() {
          createQuestion();
        }
      }, Liferay.Language.get('post-your-question')), _react["default"].createElement(_Link["default"], {
        className: "btn btn-secondary c-ml-sm-3",
        to: "/questions/".concat(sectionTitle)
      }, Liferay.Language.get('cancel')))))), _react["default"].createElement(_Alert["default"], {
        info: error
      }));
    });

    exports["default"] = _default;
    //# sourceMappingURL=NewQuestion.es.js.map
  }
});
//# sourceMappingURL=NewQuestion.es.js.map