Liferay.Loader.define("questions-web@1.0.52/js/pages/questions/Question.es", ['module', 'exports', 'require', '@questions-web$apollo/client', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/navigation-bar', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', 'questions-web$react-router-dom', '../../AppContext.es', '../../components/Answer.es', '../../components/ArticleBodyRenderer.es', '../../components/Breadcrumb.es', '../../components/CreatorRow.es', '../../components/DeleteQuestion.es', '../../components/Link.es', '../../components/PaginatedList.es', '../../components/QuestionsEditor', '../../components/Rating.es', '../../components/RelatedQuestions.es', '../../components/SectionLabel.es', '../../components/Subscription.es', '../../components/TagList.es', '../../components/TextLengthValidation.es', '../../hooks/useQueryParams.es', '../../utils/client.es', '../../utils/lang.es', '../../utils/utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _client = require("@questions-web$apollo/client");

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _form = _interopRequireDefault(require("@frontend-taglib-clay$clayui/form"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _navigationBar = _interopRequireDefault(require("@frontend-taglib-clay$clayui/navigation-bar"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("questions-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    var _Answer = _interopRequireDefault(require("../../components/Answer.es"));

    var _ArticleBodyRenderer = _interopRequireDefault(require("../../components/ArticleBodyRenderer.es"));

    var _Breadcrumb = _interopRequireDefault(require("../../components/Breadcrumb.es"));

    var _CreatorRow = _interopRequireDefault(require("../../components/CreatorRow.es"));

    var _DeleteQuestion = _interopRequireDefault(require("../../components/DeleteQuestion.es"));

    var _Link = _interopRequireDefault(require("../../components/Link.es"));

    var _PaginatedList = _interopRequireDefault(require("../../components/PaginatedList.es"));

    var _QuestionsEditor = _interopRequireDefault(require("../../components/QuestionsEditor"));

    var _Rating = _interopRequireDefault(require("../../components/Rating.es"));

    var _RelatedQuestions = _interopRequireDefault(require("../../components/RelatedQuestions.es"));

    var _SectionLabel = _interopRequireDefault(require("../../components/SectionLabel.es"));

    var _Subscription = _interopRequireDefault(require("../../components/Subscription.es"));

    var _TagList = _interopRequireDefault(require("../../components/TagList.es"));

    var _TextLengthValidation = _interopRequireDefault(require("../../components/TextLengthValidation.es"));

    var _useQueryParams = _interopRequireDefault(require("../../hooks/useQueryParams.es"));

    var _client2 = require("../../utils/client.es");

    var _lang = _interopRequireDefault(require("../../utils/lang.es"));

    var _utils = require("../../utils/utils.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
      var location = _ref.location,
          _ref$match = _ref.match,
          _ref$match$params = _ref$match.params,
          questionId = _ref$match$params.questionId,
          sectionTitle = _ref$match$params.sectionTitle,
          url = _ref$match.url;
      var context = (0, _react.useContext)(_AppContext.AppContext);
      var queryParams = (0, _useQueryParams["default"])(location);
      var sort = queryParams.get('sort') || 'active';

      var _useState = (0, _react.useState)(),
          _useState2 = _slicedToArray(_useState, 2),
          articleBody = _useState2[0],
          setArticleBody = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          showDeleteModalPanel = _useState4[0],
          setShowDeleteModalPanel = _useState4[1];

      var _useState5 = (0, _react.useState)(1),
          _useState6 = _slicedToArray(_useState5, 2),
          page = _useState6[0],
          setPage = _useState6[1];

      var _useState7 = (0, _react.useState)(20),
          _useState8 = _slicedToArray(_useState7, 2),
          pageSize = _useState8[0],
          setPageSize = _useState8[1];

      sectionTitle = sectionTitle || sectionTitle === '0' ? sectionTitle : question.messageBoardSection && question.messageBoardSection.title;

      var _useQuery = (0, _client.useQuery)(_client2.getThreadQuery, {
        context: {
          uri: '/o/graphql?nestedFields=lastPostDate'
        },
        variables: {
          friendlyUrlPath: questionId,
          siteKey: context.siteKey
        }
      }),
          loading = _useQuery.loading,
          _useQuery$data = _useQuery.data;

      _useQuery$data = _useQuery$data === void 0 ? {} : _useQuery$data;
      var _useQuery$data$messag = _useQuery$data.messageBoardThreadByFriendlyUrlPath,
          question = _useQuery$data$messag === void 0 ? {} : _useQuery$data$messag;

      var _useQuery2 = (0, _client.useQuery)(_client2.getMessagesQuery, {
        context: {
          uri: '/o/graphql?nestedFields=lastPostDate'
        },
        skip: !question || !question.id,
        variables: {
          messageBoardThreadId: question.id,
          page: sort === 'votes' ? 1 : page,
          pageSize: sort === 'votes' ? 100 : pageSize,
          sort: sort === 'votes' || sort === 'active' ? 'dateModified:desc' : 'dateCreated:desc'
        }
      }),
          _useQuery2$data = _useQuery2.data;

      _useQuery2$data = _useQuery2$data === void 0 ? {} : _useQuery2$data;
      var _useQuery2$data$messa = _useQuery2$data.messageBoardThreadMessageBoardMessages,
          messageBoardThreadMessageBoardMessages = _useQuery2$data$messa === void 0 ? {} : _useQuery2$data$messa,
          refetch = _useQuery2.refetch;

      var _useState9 = (0, _react.useState)({}),
          _useState10 = _slicedToArray(_useState9, 2),
          answers = _useState10[0],
          setAnswers = _useState10[1];

      (0, _react.useEffect)(function () {
        if (messageBoardThreadMessageBoardMessages.totalCount) {
          if (sort !== 'votes') {
            setAnswers(_objectSpread({}, messageBoardThreadMessageBoardMessages));
          } else {
            var items = _toConsumableArray(_toConsumableArray(messageBoardThreadMessageBoardMessages.items).sort(function (answer1, answer2) {
              if (answer2.showAsAnswer) {
                return 1;
              }

              if (answer1.showAsAnswer) {
                return -1;
              }

              var ratingValue1 = answer1.aggregateRating && answer1.aggregateRating.ratingValue || 0;
              var ratingValue2 = answer2.aggregateRating && answer2.aggregateRating.ratingValue || 0;
              return ratingValue2 - ratingValue1;
            }));

            setAnswers(_objectSpread({}, messageBoardThreadMessageBoardMessages, {
              items: items
            }));
          }
        }
      }, [messageBoardThreadMessageBoardMessages, pageSize, sort]);

      var _useMutation = (0, _client.useMutation)(_client2.createAnswerQuery, {
        context: (0, _utils.getContextLink)("".concat(sectionTitle, "/").concat(questionId)),
        onCompleted: function onCompleted() {
          setArticleBody('');
          refetch();
        }
      }),
          _useMutation2 = _slicedToArray(_useMutation, 1),
          createAnswer = _useMutation2[0];

      var deleteAnswer = (0, _react.useCallback)(function (answer) {
        setAnswers(_objectSpread({}, answers, {
          items: _toConsumableArray(answers.items.filter(function (otherAnswer) {
            return answer.id !== otherAnswer.id;
          })),
          totalCount: answers.totalCount - 1
        }));
      }, [answers]);

      var _useMutation3 = (0, _client.useMutation)(_client2.markAsAnswerMessageBoardMessageQuery, {
        onCompleted: function onCompleted() {
          refetch();
        }
      }),
          _useMutation4 = _slicedToArray(_useMutation3, 1),
          markAsAnswerMessageBoardMessage = _useMutation4[0];

      var answerChange = (0, _react.useCallback)(function (answerId) {
        var answer = answers.items.find(function (answer) {
          return answer.showAsAnswer && answer.id !== answerId;
        });

        if (answer) {
          markAsAnswerMessageBoardMessage({
            variables: {
              messageBoardMessageId: answer.id,
              showAsAnswer: false
            }
          });
        }
      }, [markAsAnswerMessageBoardMessage, answers.items]);
      return _react["default"].createElement("section", {
        className: "questions-section questions-section-single"
      }, _react["default"].createElement(_Breadcrumb["default"], {
        section: question.messageBoardSection || context.rootTopicId
      }), _react["default"].createElement("div", {
        className: "c-mt-5 questions-container"
      }, !loading && _react["default"].createElement("div", {
        className: "row"
      }, _react["default"].createElement("div", {
        className: "col-md-1 text-md-center"
      }, _react["default"].createElement(_Rating["default"], {
        aggregateRating: question.aggregateRating,
        disabled: !!question.locked,
        entityId: question.id,
        myRating: question.myRating && question.myRating.ratingValue,
        type: 'Thread'
      })), _react["default"].createElement("div", {
        className: "col-md-10"
      }, _react["default"].createElement("div", {
        className: "align-items-end flex-column-reverse flex-md-row row"
      }, _react["default"].createElement("div", {
        className: "c-mt-4 c-mt-md-0 col-md-8"
      }, !!question.messageBoardSection && !!question.messageBoardSection.numberOfMessageBoardSections && _react["default"].createElement(_Link["default"], {
        to: "/questions/".concat(context.useTopicNamesInURL ? sectionTitle : question.messageBoardSection.id)
      }, _react["default"].createElement(_SectionLabel["default"], {
        section: question.messageBoardSection
      })), _react["default"].createElement("h1", {
        className: (0, _classnames["default"])('c-mt-2', 'question-headline', {
          'question-seen': question.seen
        })
      }, question.headline, !!question.locked && _react["default"].createElement("span", {
        className: "c-ml-2"
      }, _react["default"].createElement(_icon["default"], {
        symbol: "lock"
      }))), _react["default"].createElement("p", {
        className: "c-mb-0 small text-secondary"
      }, Liferay.Language.get('asked'), ' ', (0, _utils.dateToBriefInternationalHuman)(question.dateCreated), ' - ', Liferay.Language.get('active'), ' ', (0, _utils.dateToBriefInternationalHuman)(question.dateModified), ' - ', _lang["default"].sub(Liferay.Language.get('viewed-x-times'), [question.viewCount]))), !question.locked && _react["default"].createElement("div", {
        className: "col-md-4 text-right"
      }, _react["default"].createElement(_button["default"].Group, {
        className: "questions-actions",
        spaced: true
      }, question.actions.subscribe && _react["default"].createElement(_Subscription["default"], {
        question: question
      }), question.actions["delete"] && _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_DeleteQuestion["default"], {
        deleteModalVisibility: showDeleteModalPanel,
        question: question,
        setDeleteModalVisibility: setShowDeleteModalPanel
      }), _react["default"].createElement(_tooltip.ClayTooltipProvider, null, _react["default"].createElement(_button["default"], {
        "data-tooltip-align": "top",
        displayType: "secondary",
        onClick: function onClick() {
          return setShowDeleteModalPanel(true);
        },
        title: Liferay.Language.get('delete')
      }, _react["default"].createElement(_icon["default"], {
        symbol: "trash"
      })))), question.actions.replace && _react["default"].createElement(_Link["default"], {
        to: "".concat(url, "/edit")
      }, _react["default"].createElement(_button["default"], {
        displayType: "secondary"
      }, Liferay.Language.get('edit')))))), _react["default"].createElement("div", {
        className: "c-mt-4"
      }, _react["default"].createElement(_ArticleBodyRenderer["default"], question)), _react["default"].createElement("div", {
        className: "c-mt-4"
      }, _react["default"].createElement(_TagList["default"], {
        sectionTitle: sectionTitle,
        tags: question.keywords
      })), _react["default"].createElement("div", {
        className: "c-mt-4 position-relative questions-creator text-center text-md-right"
      }, _react["default"].createElement(_CreatorRow["default"], {
        question: question
      })), _react["default"].createElement("h3", {
        className: "c-mt-4 text-secondary"
      }, answers.totalCount, ' ', Liferay.Language.get('answers')), !!answers.totalCount && _react["default"].createElement("div", {
        className: "border-bottom c-mt-3"
      }, _react["default"].createElement(_navigationBar["default"], {
        triggerLabel: "Active"
      }, _react["default"].createElement(_navigationBar["default"].Item, {
        active: sort === 'active'
      }, _react["default"].createElement(_Link["default"], {
        className: "link-unstyled nav-link",
        to: "".concat(url, "?sort=active")
      }, Liferay.Language.get('active'))), _react["default"].createElement(_navigationBar["default"].Item, {
        active: sort === 'oldest'
      }, _react["default"].createElement(_Link["default"], {
        className: "link-unstyled nav-link",
        to: "".concat(url, "?sort=oldest")
      }, Liferay.Language.get('oldest'))), _react["default"].createElement(_navigationBar["default"].Item, {
        active: sort === 'votes'
      }, _react["default"].createElement(_Link["default"], {
        className: "link-unstyled nav-link",
        to: "".concat(url, "?sort=votes")
      }, Liferay.Language.get('votes'))))), _react["default"].createElement("div", {
        className: "c-mt-3"
      }, _react["default"].createElement(_PaginatedList["default"], {
        activeDelta: pageSize,
        activePage: page,
        changeDelta: setPageSize,
        changePage: setPage,
        data: answers
      }, function (answer) {
        return _react["default"].createElement(_Answer["default"], {
          answer: answer,
          answerChange: answerChange,
          canMarkAsAnswer: !question.locked && !!question.actions.replace,
          deleteAnswer: deleteAnswer,
          editable: !question.locked,
          key: answer.id
        });
      })), question && !question.locked && question.actions && question.actions['reply-to-thread'] && _react["default"].createElement("div", {
        className: "c-mt-5"
      }, _react["default"].createElement(_form["default"], null, _react["default"].createElement(_form["default"].Group, {
        className: "form-group-sm"
      }, _react["default"].createElement("label", {
        htmlFor: "basicInput"
      }, Liferay.Language.get('your-answer'), _react["default"].createElement("span", {
        className: "c-ml-2 reference-mark"
      }, _react["default"].createElement(_icon["default"], {
        symbol: "asterisk"
      }))), _react["default"].createElement("div", {
        className: "c-mt-2"
      }, _react["default"].createElement(_QuestionsEditor["default"], {
        contents: articleBody,
        onChange: function onChange(event) {
          setArticleBody(event.editor.getData());
        }
      })), _react["default"].createElement(_form["default"].FeedbackGroup, null, _react["default"].createElement(_form["default"].FeedbackItem, null, _react["default"].createElement(_TextLengthValidation["default"], {
        text: articleBody
      }))))), _react["default"].createElement(_button["default"], {
        disabled: !articleBody || (0, _utils.stripHTML)(articleBody).length < 15,
        displayType: "primary",
        onClick: function onClick() {
          createAnswer({
            variables: {
              articleBody: articleBody,
              messageBoardThreadId: question.id
            }
          });
        }
      }, Liferay.Language.get('post-answer'))))), question && question.id && _react["default"].createElement(_RelatedQuestions["default"], {
        question: question
      })));
    });

    exports["default"] = _default;
    //# sourceMappingURL=Question.es.js.map
  }
});
//# sourceMappingURL=Question.es.js.map