Liferay.Loader.define("questions-web@1.0.52/js/pages/questions/Questions.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/empty-state', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-react-web$react', 'questions-web$react-router-dom', '../../AppContext.es', '../../components/Alert.es', '../../components/Breadcrumb.es', '../../components/PaginatedList.es', '../../components/QuestionRow.es', '../../components/ResultsMessage.es', '../../components/SectionSubscription.es', '../../hooks/useQueryParams.es', '../../utils/client.es', '../../utils/utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/button"));

    var _emptyState = _interopRequireDefault(require("@frontend-taglib-clay$clayui/empty-state"));

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("questions-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    var _Alert = _interopRequireDefault(require("../../components/Alert.es"));

    var _Breadcrumb = _interopRequireDefault(require("../../components/Breadcrumb.es"));

    var _PaginatedList = _interopRequireDefault(require("../../components/PaginatedList.es"));

    var _QuestionRow = _interopRequireDefault(require("../../components/QuestionRow.es"));

    var _ResultsMessage = _interopRequireDefault(require("../../components/ResultsMessage.es"));

    var _SectionSubscription = _interopRequireDefault(require("../../components/SectionSubscription.es"));

    var _useQueryParams = _interopRequireDefault(require("../../hooks/useQueryParams.es"));

    var _client = require("../../utils/client.es");

    var _utils = require("../../utils/utils.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function getFilterOptions() {
      return [{
        label: Liferay.Language.get('latest-created'),
        title: Liferay.Language.get('showing-questions-ordered-by-last-created-first'),
        value: 'latest-created'
      }, {
        label: Liferay.Language.get('latest-edited'),
        title: Liferay.Language.get('showing-questions-ordered-by-last-edited-first'),
        value: 'latest-edited'
      }, {
        label: Liferay.Language.get('voted-in-the-last-week'),
        title: Liferay.Language.get('showing-questions-that-have-at-least-one-vote-in-the-last-week-ordered-by-votes-received'),
        value: 'week'
      }, {
        label: Liferay.Language.get('voted-in-the-last-month'),
        title: Liferay.Language.get('showing-questions-that-have-at-least-one-vote-in-the-last-month-ordered-by-votes-received'),
        value: 'month'
      }, {
        label: Liferay.Language.get('most-voted'),
        title: Liferay.Language.get('showing-questions-that-have-at-least-one-vote-ordered-by-votes-received'),
        value: 'most-voted'
      }];
    }

    var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
      var history = _ref.history,
          location = _ref.location,
          _ref$match$params = _ref.match.params,
          creatorId = _ref$match$params.creatorId,
          sectionTitle = _ref$match$params.sectionTitle,
          tag = _ref$match$params.tag;
      var MAX_NUMBER_OF_QUESTIONS = 500;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          allowCreateTopicInRootTopic = _useState2[0],
          setAllowCreateTopicInRootTopic = _useState2[1];

      var _useState3 = (0, _react.useState)(''),
          _useState4 = _slicedToArray(_useState3, 2),
          currentTag = _useState4[0],
          setCurrentTag = _useState4[1];

      var _useState5 = (0, _react.useState)({}),
          _useState6 = _slicedToArray(_useState5, 2),
          error = _useState6[0],
          setError = _useState6[1];

      var _useState7 = (0, _react.useState)(),
          _useState8 = _slicedToArray(_useState7, 2),
          filter = _useState8[0],
          setFilter = _useState8[1];

      var _useState9 = (0, _react.useState)(true),
          _useState10 = _slicedToArray(_useState9, 2),
          loading = _useState10[0],
          setLoading = _useState10[1];

      var _useState11 = (0, _react.useState)(1),
          _useState12 = _slicedToArray(_useState11, 2),
          page = _useState12[0],
          setPage = _useState12[1];

      var _useState13 = (0, _react.useState)(20),
          _useState14 = _slicedToArray(_useState13, 2),
          pageSize = _useState14[0],
          setPageSize = _useState14[1];

      var _useState15 = (0, _react.useState)([]),
          _useState16 = _slicedToArray(_useState15, 2),
          questions = _useState16[0],
          setQuestions = _useState16[1];

      var _useState17 = (0, _react.useState)(''),
          _useState18 = _slicedToArray(_useState17, 2),
          search = _useState18[0],
          setSearch = _useState18[1];

      var _useState19 = (0, _react.useState)({}),
          _useState20 = _slicedToArray(_useState19, 2),
          section = _useState20[0],
          setSection = _useState20[1];

      var _useState21 = (0, _react.useState)(0),
          _useState22 = _slicedToArray(_useState21, 2),
          totalCount = _useState22[0],
          setTotalCount = _useState22[1];

      var queryParams = (0, _useQueryParams["default"])(location);
      var context = (0, _react.useContext)(_AppContext.AppContext);
      var siteKey = context.siteKey;
      var historyPushParser = (0, _utils.historyPushWithSlug)(history.push);
      (0, _react.useEffect)(function () {
        setCurrentTag(tag ? (0, _utils.slugToText)(tag) : '');
      }, [tag]);
      (0, _react.useEffect)(function () {
        var pageNumber = queryParams.get('page') || 1;
        setPage(isNaN(pageNumber) ? 1 : parseInt(pageNumber, 10));
      }, [queryParams]);
      (0, _react.useEffect)(function () {
        setPageSize(queryParams.get('pagesize') || 20);
      }, [queryParams]);
      (0, _react.useEffect)(function () {
        setSearch(queryParams.get('search') || '');
      }, [queryParams]);
      (0, _react.useEffect)(function () {
        if (+context.rootTopicId === 0 && location.pathname.endsWith('/' + context.rootTopicId)) {
          (0, _client.getSectionsByRootSection)(context.siteKey, context.rootTopicId).then(function (_ref2) {
            var data = _ref2.data;
            setAllowCreateTopicInRootTopic(data.actions && data.actions.create && true || false);
          })["catch"](function (error) {

            setLoading(false);
            setError({
              message: 'Loading Topics',
              title: 'Error'
            });
          });
        }
      }, [context.rootTopicId, context.siteKey, location.pathname]);
      (0, _react.useEffect)(function () {
        setTotalCount((filter === 'latest-edited' || !!search) && questions.totalCount > MAX_NUMBER_OF_QUESTIONS ? MAX_NUMBER_OF_QUESTIONS : questions.totalCount);
      }, [filter, questions.totalCount, search]);
      (0, _react.useEffect)(function () {
        if (section.id == null && !currentTag) {
          return;
        }

        (0, _client.getQuestionThreads)(creatorId, filter, currentTag, page, pageSize, search, section, siteKey).then(function (_ref3) {
          var data = _ref3.data,
              loading = _ref3.loading;
          setQuestions(data || []);
          setLoading(loading);
        })["catch"](function (error) {

          setLoading(false);
          setError({
            message: 'Loading Questions',
            title: 'Error'
          });
        });
      }, [creatorId, currentTag, filter, page, pageSize, search, section, siteKey]);

      function buildURL(search, page, pageSize) {
        var url = '/questions';

        if (sectionTitle || sectionTitle === '0') {
          url += "/".concat(sectionTitle);
        }

        if (tag) {
          url += "/tag/".concat(tag);
        }

        if (creatorId) {
          url += "/creator/".concat(creatorId);
        }

        if (search) {
          url += "?search=".concat(search, "&");
        } else {
          url += '?';
        }

        url += "page=".concat(page, "&pagesize=").concat(pageSize);
        return url;
      }

      var _changePage = function changePage(page, pageSize) {
        historyPushParser(buildURL(search, page, pageSize));
      };

      var _useDebounceCallback = (0, _utils.useDebounceCallback)(function (search) {
        setLoading(true);
        historyPushParser(buildURL(search, 1, 20));
      }, 500),
          _useDebounceCallback2 = _slicedToArray(_useDebounceCallback, 1),
          debounceCallback = _useDebounceCallback2[0];

      (0, _react.useEffect)(function () {
        if (sectionTitle && sectionTitle !== '0') {
          (0, _client.getSectionBySectionTitle)(context.siteKey, (0, _utils.slugToText)(sectionTitle)).then(setSection);
        } else if (sectionTitle === '0') {
          (0, _client.getSectionByRootSection)(context.siteKey).then(setSection);
        }
      }, [sectionTitle, context.siteKey]);
      var filterOptions = getFilterOptions();

      var navigateToNewQuestion = function navigateToNewQuestion() {
        if (context.redirectToLogin && !themeDisplay.isSignedIn()) {
          var baseURL = (0, _utils.getBasePath)();
          window.location.replace("/c/portal/login?redirect=".concat(baseURL, "#/questions/").concat(sectionTitle, "/new"));
        } else {
          historyPushParser("/questions/".concat(sectionTitle, "/new"));
        }

        return false;
      };

      return _react["default"].createElement("section", {
        className: "questions-section questions-section-list"
      }, _react["default"].createElement(_Breadcrumb["default"], {
        allowCreateTopicInRootTopic: allowCreateTopicInRootTopic,
        section: section
      }), _react["default"].createElement("div", {
        className: "questions-container"
      }, _react["default"].createElement("div", {
        className: "row"
      }, _react["default"].createElement("div", {
        className: "c-mt-3 col col-xl-12"
      }, _react["default"].createElement(function QuestionsNavigationBar() {
        return _react["default"].createElement("div", {
          className: "d-flex flex-column flex-xl-row justify-content-between"
        }, _react["default"].createElement("div", {
          className: "align-items-center d-flex flex-grow-1"
        }, section && section.actions && section.actions.subscribe && _react["default"].createElement("div", {
          className: "c-ml-3"
        }, _react["default"].createElement(_SectionSubscription["default"], {
          section: section
        }))), (questions && questions.totalCount > 0 || search || filter) && _react["default"].createElement("div", {
          className: "c-mt-3 c-mt-xl-0 d-flex flex-column flex-grow-1 flex-md-row"
        }, _react["default"].createElement(_form.ClayInput.Group, {
          className: "justify-content-xl-end"
        }, _react["default"].createElement(_form.ClayInput.GroupItem, {
          shrink: true
        }, _react["default"].createElement("label", {
          className: "align-items-center d-inline-flex m-0 text-secondary",
          htmlFor: "questionsFilter"
        }, Liferay.Language.get('filter-by'))), _react["default"].createElement(_form.ClayInput.GroupItem, {
          shrink: true
        }, _react["default"].createElement(_form.ClaySelect, {
          className: "bg-transparent border-0",
          disabled: loading,
          id: "questionsFilter",
          onChange: function onChange(event) {
            setLoading(true);
            setFilter(event.target.value);
          },
          value: filter
        }, filterOptions.map(function (option) {
          return _react["default"].createElement(_form.ClaySelect.Option, {
            key: option.value,
            label: option.label,
            title: option.title,
            value: option.value
          });
        })))), _react["default"].createElement(_form.ClayInput.Group, {
          className: "c-mt-3 c-mt-md-0"
        }, _react["default"].createElement(_form.ClayInput.GroupItem, null, _react["default"].createElement(_form.ClayInput, {
          className: "bg-transparent form-control input-group-inset input-group-inset-after",
          defaultValue: search && (0, _utils.slugToText)(search) || '',
          disabled: !search && questions && questions.items && !questions.items.length,
          onChange: function onChange(event) {
            return debounceCallback(event.target.value);
          },
          placeholder: Liferay.Language.get('search'),
          type: "text"
        }), _react["default"].createElement(_form.ClayInput.GroupInsetItem, {
          after: true,
          className: "bg-transparent",
          tag: "span"
        }, loading && _react["default"].createElement("button", {
          className: "btn btn-monospaced btn-unstyled",
          type: "submit"
        }, _react["default"].createElement(_loadingIndicator["default"], {
          className: "mb-0 mt-0",
          small: true
        })), !loading && (!!search && _react["default"].createElement(_button.ClayButtonWithIcon, {
          displayType: "unstyled",
          onClick: function onClick() {
            setLoading(true);
            historyPushParser(buildURL('', 1, 20));
          },
          symbol: "times-circle",
          type: "submit"
        }) || _react["default"].createElement(_button.ClayButtonWithIcon, {
          displayType: "unstyled",
          symbol: "search",
          type: "search"
        })))), sectionTitle && questions && questions.totalCount > 0 && (context.redirectToLogin || section && section.actions && section.actions['add-thread'] || context.canCreateThread) && _react["default"].createElement(_form.ClayInput.GroupItem, {
          shrink: true
        }, _react["default"].createElement(_button["default"], {
          className: "c-ml-3 d-none d-sm-block text-nowrap",
          displayType: "primary",
          onClick: navigateToNewQuestion
        }, Liferay.Language.get('ask-question')), _react["default"].createElement(_button["default"], {
          className: "btn-monospaced d-block d-sm-none position-fixed questions-button shadow",
          displayType: "primary",
          onClick: navigateToNewQuestion
        }, _react["default"].createElement(_icon["default"], {
          symbol: "pencil"
        }), _react["default"].createElement("span", {
          className: "sr-only"
        }, Liferay.Language.get('ask-question')))))));
      }, null)), !!search && !loading && _react["default"].createElement(_ResultsMessage["default"], {
        maxNumberOfSearchResults: MAX_NUMBER_OF_QUESTIONS,
        searchCriteria: search,
        totalCount: totalCount
      }), _react["default"].createElement("div", {
        className: "c-mx-auto c-px-0 col-xl-10"
      }, _react["default"].createElement(_PaginatedList["default"], {
        activeDelta: pageSize,
        activePage: page,
        changeDelta: function changeDelta(pageSize) {
          return _changePage(page, pageSize);
        },
        changePage: function changePage(page) {
          return _changePage(page, pageSize);
        },
        data: questions,
        emptyState: !search && !filter ? _react["default"].createElement(_emptyState["default"], {
          description: Liferay.Language.get('there-are-no-questions-inside-this-topic-be-the-first-to-ask-something'),
          imgSrc: context.includeContextPath + '/assets/empty_questions_list.png',
          title: Liferay.Language.get('this-topic-is-empty')
        }, _react["default"].createElement(_button["default"], {
          displayType: "primary",
          onClick: navigateToNewQuestion
        }, Liferay.Language.get('ask-question'))) : _react["default"].createElement(_emptyState["default"], {
          title: Liferay.Language.get('there-are-no-results')
        }),
        loading: loading,
        totalCount: totalCount
      }, function (question) {
        return _react["default"].createElement(_QuestionRow["default"], {
          currentSection: sectionTitle,
          key: question.id,
          question: question,
          showSectionLabel: !!section.numberOfMessageBoardSections
        });
      }), _react["default"].createElement(_Alert["default"], {
        info: error
      })))));
    });

    exports["default"] = _default;
    //# sourceMappingURL=Questions.es.js.map
  }
});
//# sourceMappingURL=Questions.es.js.map