Liferay.Loader.define("questions-web@1.0.52/js/pages/tags/Tags.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/empty-state', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-react-web$react', 'questions-web$react-router-dom', '../../AppContext.es', '../../components/Alert.es', '../../components/Link.es', '../../components/PaginatedList.es', '../../hooks/useQueryParams.es', '../../utils/client.es', '../../utils/lang.es', '../../utils/utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _emptyState = _interopRequireDefault(require("@frontend-taglib-clay$clayui/empty-state"));

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("questions-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    var _Alert = _interopRequireDefault(require("../../components/Alert.es"));

    var _Link = _interopRequireDefault(require("../../components/Link.es"));

    var _PaginatedList = _interopRequireDefault(require("../../components/PaginatedList.es"));

    var _useQueryParams = _interopRequireDefault(require("../../hooks/useQueryParams.es"));

    var _client = require("../../utils/client.es");

    var _lang = _interopRequireDefault(require("../../utils/lang.es"));

    var _utils = require("../../utils/utils.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function getOrderByOptions() {
      return [{
        label: Liferay.Language.get('latest-created'),
        value: 'latest-created'
      }, {
        label: Liferay.Language.get('number-of-usages'),
        value: 'number-of-usages'
      }];
    }

    var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
      var history = _ref.history,
          location = _ref.location;
      var context = (0, _react.useContext)(_AppContext.AppContext);

      var _useState = (0, _react.useState)({}),
          _useState2 = _slicedToArray(_useState, 2),
          error = _useState2[0],
          setError = _useState2[1];

      var _useState3 = (0, _react.useState)(''),
          _useState4 = _slicedToArray(_useState3, 2),
          searchBoxValue = _useState4[0],
          setSearchBoxValue = _useState4[1];

      var _useState5 = (0, _react.useState)(true),
          _useState6 = _slicedToArray(_useState5, 2),
          loading = _useState6[0],
          setLoading = _useState6[1];

      var _useState7 = (0, _react.useState)('number-of-usages'),
          _useState8 = _slicedToArray(_useState7, 2),
          orderBy = _useState8[0],
          setOrderBy = _useState8[1];

      var _useState9 = (0, _react.useState)(1),
          _useState10 = _slicedToArray(_useState9, 2),
          page = _useState10[0],
          setPage = _useState10[1];

      var _useState11 = (0, _react.useState)(20),
          _useState12 = _slicedToArray(_useState11, 2),
          pageSize = _useState12[0],
          setPageSize = _useState12[1];

      var _useState13 = (0, _react.useState)(''),
          _useState14 = _slicedToArray(_useState13, 2),
          search = _useState14[0],
          setSearch = _useState14[1];

      var _useState15 = (0, _react.useState)([]),
          _useState16 = _slicedToArray(_useState15, 2),
          tags = _useState16[0],
          setTags = _useState16[1];

      (0, _react.useEffect)(function () {
        (0, _client.getTags)(orderBy, page, pageSize, search, context.siteKey).then(function (_ref2) {
          var data = _ref2.data,
              loading = _ref2.loading;
          setTags(data || []);
          setLoading(loading);
          setSearchBoxValue(search);
        })["catch"](function (error) {

          setLoading(false);
          setError({
            message: 'Loading Tags',
            title: 'Error'
          });
        });
      }, [orderBy, page, pageSize, search, context.siteKey]);
      var queryParams = (0, _useQueryParams["default"])(location);
      (0, _react.useEffect)(function () {
        setPage(+queryParams.get('page') || 1);
      }, [queryParams]);
      (0, _react.useEffect)(function () {
        setPageSize(+queryParams.get('pagesize') || 20);
      }, [queryParams]);
      (0, _react.useEffect)(function () {
        setSearch(queryParams.get('search') || '');
      }, [queryParams]);
      var historyPushParser = (0, _utils.historyPushWithSlug)(history.push);

      function buildURL(search, page, pageSize) {
        var url = '/tags?';

        if (search) {
          url += "search=".concat(search, "&");
        }

        url += "page=".concat(page, "&pagesize=").concat(pageSize);
        return url;
      }

      var _changePage = function changePage(page, pageSize) {
        historyPushParser(buildURL(search, page, pageSize));
      };

      var orderByOptions = getOrderByOptions();

      var _useDebounceCallback = (0, _utils.useDebounceCallback)(function (search) {
        setLoading(true);
        historyPushParser(buildURL(search, 1, pageSize));
      }, 500),
          _useDebounceCallback2 = _slicedToArray(_useDebounceCallback, 1),
          debounceCallback = _useDebounceCallback2[0];

      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("div", {
        className: "container"
      }, _react["default"].createElement("div", {
        className: "d-flex flex-row"
      }, _react["default"].createElement("div", {
        className: "d-flex flex-column flex-grow-1"
      }, _react["default"].createElement(_form.ClayInput.Group, {
        className: "c-mt-3 justify-content-end"
      }, _react["default"].createElement(_form.ClayInput.GroupItem, {
        shrink: true
      }, _react["default"].createElement("label", {
        className: "align-items-center d-inline-flex m-0 text-secondary",
        htmlFor: "tagsOrderBy"
      }, Liferay.Language.get('order-by'))), _react["default"].createElement(_form.ClayInput.GroupItem, {
        shrink: true
      }, _react["default"].createElement(_form.ClaySelect, {
        className: "bg-transparent border-0",
        disabled: loading,
        id: "tagsOrderBy",
        onChange: function onChange(event) {
          setLoading(true);
          setOrderBy(event.target.value);
        },
        value: orderBy
      }, orderByOptions.map(function (option) {
        return _react["default"].createElement(_form.ClaySelect.Option, {
          key: option.value,
          label: option.label,
          value: option.value
        });
      }))))), _react["default"].createElement("div", {
        className: "d-flex flex-column flex-grow-0"
      }, _react["default"].createElement(_form.ClayInput.Group, {
        className: "c-mt-3"
      }, _react["default"].createElement(_form.ClayInput.GroupItem, null, _react["default"].createElement(_form.ClayInput, {
        className: "bg-transparent form-control input-group-inset input-group-inset-after",
        disabled: !search && tags && tags.items && !tags.items.length,
        onChange: function onChange(event) {
          setSearchBoxValue(event.target.value);
          debounceCallback(event.target.value);
        },
        placeholder: Liferay.Language.get('search'),
        type: "text",
        value: searchBoxValue
      }), _react["default"].createElement(_form.ClayInput.GroupInsetItem, {
        after: true,
        className: "bg-transparent",
        tag: "span"
      }, loading && _react["default"].createElement(_loadingIndicator["default"], {
        small: true
      }), !loading && (!!search && _react["default"].createElement(_button.ClayButtonWithIcon, {
        displayType: "unstyled",
        onClick: function onClick() {
          historyPushParser(buildURL('', 1, pageSize));
        },
        symbol: "times-circle",
        type: "submit"
      }) || _react["default"].createElement(_button.ClayButtonWithIcon, {
        displayType: "unstyled",
        symbol: "search",
        type: "search"
      }))))))), _react["default"].createElement("div", {
        className: "c-mt-3 row"
      }, _react["default"].createElement(_PaginatedList["default"], {
        activeDelta: pageSize,
        activePage: page,
        changeDelta: function changeDelta(pageSize) {
          return _changePage(page, pageSize);
        },
        changePage: function changePage(page) {
          return _changePage(page, pageSize);
        },
        data: tags,
        emptyState: _react["default"].createElement(_emptyState["default"], {
          className: "empty-state-icon",
          title: Liferay.Language.get('there-are-no-results')
        }),
        loading: loading
      }, function (tag) {
        return _react["default"].createElement("div", {
          className: "col-md-3 question-tags",
          key: tag.id
        }, _react["default"].createElement(_Link["default"], {
          title: tag.name,
          to: "/questions/tag/".concat(tag.name)
        }, _react["default"].createElement("div", {
          className: "card card-interactive card-interactive-primary card-type-template template-card-horizontal"
        }, _react["default"].createElement("div", {
          className: "card-body"
        }, _react["default"].createElement("div", {
          className: "card-row"
        }, _react["default"].createElement("div", {
          className: "autofit-col autofit-col-expand"
        }, _react["default"].createElement("div", {
          className: "autofit-section"
        }, _react["default"].createElement("div", {
          className: "card-title"
        }, _react["default"].createElement("span", {
          className: "text-truncate"
        }, tag.name)), orderBy === 'latest-created' ? _react["default"].createElement("div", null, _lang["default"].sub(Liferay.Language.get('created-on'), [(0, _utils.dateToInternationalHuman)(tag.dateCreated)])) : _react["default"].createElement("div", null, _lang["default"].sub(Liferay.Language.get('used-x-times'), [tag.keywordUsageCount])))))))));
      }), _react["default"].createElement(_Alert["default"], {
        info: error
      }))));
    });

    exports["default"] = _default;
    //# sourceMappingURL=Tags.es.js.map
  }
});
//# sourceMappingURL=Tags.es.js.map