Liferay.Loader.define("questions-web@1.0.52/js/utils/client.es", ['module', 'exports', 'require', '@questions-web$apollo/client', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.unsubscribeMyUserAccountQuery = exports.getSubscriptionsQuery = exports.unsubscribeSectionQuery = exports.subscribeSectionQuery = exports.unsubscribeQuery = exports.subscribeQuery = exports.updateThreadQuery = exports.updateMessageQuery = exports.markAsAnswerMessageBoardMessageQuery = exports.getUserActivityQuery = exports.getSectionsQuery = exports.getSectionQuery = exports.getSectionBySectionTitleQuery = exports.getRelatedThreadsQuery = exports.getRankedThreadsQuery = exports.getRankedThreads = exports.getSectionThreadsQuery = exports.getThreadsQuery = exports.getSectionBySectionTitle = exports.getSectionByRootSection = exports.getSectionsByRootSection = exports.getThreads = exports.getQuestionThreads = exports.hasListPermissionsQuery = exports.getMessagesQuery = exports.getThreadContentQuery = exports.getMessageBoardThreadByIdQuery = exports.getThreadQuery = exports.getMessageQuery = exports.getTagsOrderByDateCreatedQuery = exports.getTagsOrderByNumberOfUsagesQuery = exports.getTags = exports.deleteMessageBoardThreadQuery = exports.deleteMessageQuery = exports.createVoteThreadQuery = exports.createVoteMessageQuery = exports.createTopicQuery = exports.createSubTopicQuery = exports.createQuestionInASectionQuery = exports.createQuestionInRootQuery = exports.createCommentQuery = exports.createAnswerQuery = exports.client = void 0;

    var _client = require("@questions-web$apollo/client");

    var _frontendJsWeb = require("frontend-js-web");

    function _templateObject35() {
      var data = _taggedTemplateLiteral(["\n\tmutation deleteMyUserAccountSubscription($subscriptionId: Long!) {\n\t\tdeleteMyUserAccountSubscription(subscriptionId: $subscriptionId)\n\t}\n"]);

      _templateObject35 = function _templateObject35() {
        return data;
      };

      return data;
    }

    function _templateObject34() {
      var data = _taggedTemplateLiteral(["\n\tquery myUserAccountSubscriptions($contentType: String!) {\n\t\tmyUserAccountSubscriptions(contentType: $contentType) {\n\t\t\titems {\n\t\t\t\tid\n\t\t\t\tcontentType\n\t\t\t\tgraphQLNode {\n\t\t\t\t\t... on MessageBoardSection {\n\t\t\t\t\t\tid\n\t\t\t\t\t\ttitle\n\t\t\t\t\t}\n\t\t\t\t\t... on MessageBoardThread {\n\t\t\t\t\t\tactions\n\t\t\t\t\t\taggregateRating {\n\t\t\t\t\t\t\tratingAverage\n\t\t\t\t\t\t\tratingCount\n\t\t\t\t\t\t\tratingValue\n\t\t\t\t\t\t}\n\t\t\t\t\t\tarticleBody\n\t\t\t\t\t\tcreator {\n\t\t\t\t\t\t\tid\n\t\t\t\t\t\t\timage\n\t\t\t\t\t\t\tname\n\t\t\t\t\t\t}\n\t\t\t\t\t\tcreatorStatistics {\n\t\t\t\t\t\t\tjoinDate\n\t\t\t\t\t\t\tlastPostDate\n\t\t\t\t\t\t\tpostsNumber\n\t\t\t\t\t\t\trank\n\t\t\t\t\t\t}\n\t\t\t\t\t\tdateCreated\n\t\t\t\t\t\tdateModified\n\t\t\t\t\t\tencodingFormat\n\t\t\t\t\t\tfriendlyUrlPath\n\t\t\t\t\t\theadline\n\t\t\t\t\t\tid\n\t\t\t\t\t\tkeywords\n\t\t\t\t\t\tmessageBoardSection {\n\t\t\t\t\t\t\tid\n\t\t\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\t\t\ttitle\n\t\t\t\t\t\t}\n\t\t\t\t\t\tmyRating {\n\t\t\t\t\t\t\tratingValue\n\t\t\t\t\t\t}\n\t\t\t\t\t\tsubscribed\n\t\t\t\t\t\tviewCount\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n"]);

      _templateObject34 = function _templateObject34() {
        return data;
      };

      return data;
    }

    function _templateObject33() {
      var data = _taggedTemplateLiteral(["\n\tmutation updateMessageBoardSectionUnsubscribe(\n\t\t$messageBoardSectionId: Long!\n\t) {\n\t\tupdateMessageBoardSectionUnsubscribe(\n\t\t\tmessageBoardSectionId: $messageBoardSectionId\n\t\t)\n\t}\n"]);

      _templateObject33 = function _templateObject33() {
        return data;
      };

      return data;
    }

    function _templateObject32() {
      var data = _taggedTemplateLiteral(["\n\tmutation updateMessageBoardSectionSubscribe($messageBoardSectionId: Long!) {\n\t\tupdateMessageBoardSectionSubscribe(\n\t\t\tmessageBoardSectionId: $messageBoardSectionId\n\t\t)\n\t}\n"]);

      _templateObject32 = function _templateObject32() {
        return data;
      };

      return data;
    }

    function _templateObject31() {
      var data = _taggedTemplateLiteral(["\n\tmutation updateMessageBoardThreadUnsubscribe($messageBoardThreadId: Long!) {\n\t\tupdateMessageBoardThreadUnsubscribe(\n\t\t\tmessageBoardThreadId: $messageBoardThreadId\n\t\t)\n\t}\n"]);

      _templateObject31 = function _templateObject31() {
        return data;
      };

      return data;
    }

    function _templateObject30() {
      var data = _taggedTemplateLiteral(["\n\tmutation updateMessageBoardThreadSubscribe($messageBoardThreadId: Long!) {\n\t\tupdateMessageBoardThreadSubscribe(\n\t\t\tmessageBoardThreadId: $messageBoardThreadId\n\t\t)\n\t}\n"]);

      _templateObject30 = function _templateObject30() {
        return data;
      };

      return data;
    }

    function _templateObject29() {
      var data = _taggedTemplateLiteral(["\n\tmutation patchMessageBoardThread(\n\t\t$articleBody: String!\n\t\t$headline: String!\n\t\t$keywords: [String]\n\t\t$messageBoardThreadId: Long!\n\t) {\n\t\tpatchMessageBoardThread(\n\t\t\tmessageBoardThread: {\n\t\t\t\tarticleBody: $articleBody\n\t\t\t\tencodingFormat: \"html\"\n\t\t\t\theadline: $headline\n\t\t\t\tkeywords: $keywords\n\t\t\t}\n\t\t\tmessageBoardThreadId: $messageBoardThreadId\n\t\t) {\n\t\t\tarticleBody\n\t\t\theadline\n\t\t\tkeywords\n\t\t}\n\t}\n"]);

      _templateObject29 = function _templateObject29() {
        return data;
      };

      return data;
    }

    function _templateObject28() {
      var data = _taggedTemplateLiteral(["\n\tmutation patchMessageBoardMessage(\n\t\t$articleBody: String!\n\t\t$messageBoardMessageId: Long!\n\t) {\n\t\tpatchMessageBoardMessage(\n\t\t\tmessageBoardMessage: {\n\t\t\t\tarticleBody: $articleBody\n\t\t\t\tencodingFormat: \"html\"\n\t\t\t}\n\t\t\tmessageBoardMessageId: $messageBoardMessageId\n\t\t) {\n\t\t\tarticleBody\n\t\t}\n\t}\n"]);

      _templateObject28 = function _templateObject28() {
        return data;
      };

      return data;
    }

    function _templateObject27() {
      var data = _taggedTemplateLiteral(["\n\tmutation patchMessageBoardMessage(\n\t\t$messageBoardMessageId: Long!\n\t\t$showAsAnswer: Boolean!\n\t) {\n\t\tpatchMessageBoardMessage(\n\t\t\tmessageBoardMessage: {showAsAnswer: $showAsAnswer}\n\t\t\tmessageBoardMessageId: $messageBoardMessageId\n\t\t) {\n\t\t\tid\n\t\t\tshowAsAnswer\n\t\t}\n\t}\n"]);

      _templateObject27 = function _templateObject27() {
        return data;
      };

      return data;
    }

    function _templateObject26() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardThreads(\n\t\t$filter: String\n\t\t$page: Int!\n\t\t$pageSize: Int!\n\t\t$siteKey: String!\n\t) {\n\t\tmessageBoardThreads(\n\t\t\tfilter: $filter\n\t\t\tflatten: true\n\t\t\tpage: $page\n\t\t\tpageSize: $pageSize\n\t\t\tsiteKey: $siteKey\n\t\t\tsort: \"dateCreated:desc\"\n\t\t) {\n\t\t\titems {\n\t\t\t\taggregateRating {\n\t\t\t\t\tratingAverage\n\t\t\t\t\tratingCount\n\t\t\t\t\tratingValue\n\t\t\t\t}\n\t\t\t\tarticleBody\n\t\t\t\tcreator {\n\t\t\t\t\tid\n\t\t\t\t\timage\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t\tcreatorStatistics {\n\t\t\t\t\tpostsNumber\n\t\t\t\t\trank\n\t\t\t\t}\n\t\t\t\tdateModified\n\t\t\t\tfriendlyUrlPath\n\t\t\t\thasValidAnswer\n\t\t\t\theadline\n\t\t\t\tid\n\t\t\t\tkeywords\n\t\t\t\tmessageBoardSection {\n\t\t\t\t\tid\n\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\ttitle\n\t\t\t\t}\n\t\t\t\tnumberOfMessageBoardMessages\n\t\t\t\ttaxonomyCategoryBriefs {\n\t\t\t\t\ttaxonomyCategoryId\n\t\t\t\t\ttaxonomyCategoryName\n\t\t\t\t}\n\t\t\t\tviewCount\n\t\t\t}\n\t\t\tpage\n\t\t\tpageSize\n\t\t\ttotalCount\n\t\t}\n\t}\n"]);

      _templateObject26 = function _templateObject26() {
        return data;
      };

      return data;
    }

    function _templateObject25() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardSections($siteKey: String!) {\n\t\tmessageBoardSections(siteKey: $siteKey, sort: \"title:asc\") {\n\t\t\tactions\n\t\t\titems {\n\t\t\t\tdescription\n\t\t\t\tid\n\t\t\t\tnumberOfMessageBoardThreads\n\t\t\t\tparentMessageBoardSectionId\n\t\t\t\tsubscribed\n\t\t\t\ttitle\n\t\t\t}\n\t\t}\n\t}\n"]);

      _templateObject25 = function _templateObject25() {
        return data;
      };

      return data;
    }

    function _templateObject24() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardSection($messageBoardSectionId: Long!) {\n\t\tmessageBoardSection(messageBoardSectionId: $messageBoardSectionId) {\n\t\t\tactions\n\t\t\tid\n\t\t\tmessageBoardSections(sort: \"title:asc\") {\n\t\t\t\titems {\n\t\t\t\t\tid\n\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\tsubscribed\n\t\t\t\t\ttitle\n\t\t\t\t}\n\t\t\t}\n\t\t\tnumberOfMessageBoardThreads\n\t\t\tparentMessageBoardSectionId\n\t\t\tsubscribed\n\t\t\ttitle\n\t\t}\n\t}\n"]);

      _templateObject24 = function _templateObject24() {
        return data;
      };

      return data;
    }

    function _templateObject23() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardSections($filter: String!, $siteKey: String!) {\n\t\tmessageBoardSections(\n\t\t\tfilter: $filter\n\t\t\tflatten: true\n\t\t\tpageSize: 1\n\t\t\tsiteKey: $siteKey\n\t\t\tsort: \"title:asc\"\n\t\t) {\n\t\t\tactions\n\t\t\titems {\n\t\t\t\tactions\n\t\t\t\tid\n\t\t\t\tmessageBoardSections(sort: \"title:asc\") {\n\t\t\t\t\tactions\n\t\t\t\t\titems {\n\t\t\t\t\t\tid\n\t\t\t\t\t\tdescription\n\t\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\t\tnumberOfMessageBoardThreads\n\t\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\t\tsubscribed\n\t\t\t\t\t\ttitle\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\tparentMessageBoardSection {\n\t\t\t\t\tid\n\t\t\t\t\tmessageBoardSections {\n\t\t\t\t\t\titems {\n\t\t\t\t\t\t\tid\n\t\t\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\t\t\tsubscribed\n\t\t\t\t\t\t\ttitle\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\tsubscribed\n\t\t\t\t\ttitle\n\t\t\t\t}\n\t\t\t\tparentMessageBoardSectionId\n\t\t\t\tsubscribed\n\t\t\t\ttitle\n\t\t\t}\n\t\t}\n\t}\n"]);

      _templateObject23 = function _templateObject23() {
        return data;
      };

      return data;
    }

    function _templateObject22() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardThreads($search: String!, $siteKey: String!) {\n\t\tmessageBoardThreads(\n\t\t\tpage: 1\n\t\t\tpageSize: 4\n\t\t\tflatten: true\n\t\t\tsearch: $search\n\t\t\tsiteKey: $siteKey\n\t\t) {\n\t\t\titems {\n\t\t\t\taggregateRating {\n\t\t\t\t\tratingAverage\n\t\t\t\t\tratingCount\n\t\t\t\t\tratingValue\n\t\t\t\t}\n\t\t\t\tcreator {\n\t\t\t\t\tid\n\t\t\t\t\timage\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t\tdateModified\n\t\t\t\tfriendlyUrlPath\n\t\t\t\theadline\n\t\t\t\tid\n\t\t\t\tlocked\n\t\t\t\tmessageBoardSection {\n\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\ttitle\n\t\t\t\t}\n\t\t\t\tseen\n\t\t\t}\n\t\t\tpage\n\t\t\tpageSize\n\t\t\ttotalCount\n\t\t}\n\t}\n"]);

      _templateObject22 = function _templateObject22() {
        return data;
      };

      return data;
    }

    function _templateObject21() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardThreadsRanked(\n\t\t$dateModified: Date\n\t\t$messageBoardSectionId: Long\n\t\t$page: Int!\n\t\t$pageSize: Int!\n\t\t$sort: String!\n\t) {\n\t\tmessageBoardThreadsRanked(\n\t\t\tdateModified: $dateModified\n\t\t\tmessageBoardSectionId: $messageBoardSectionId\n\t\t\tpage: $page\n\t\t\tpageSize: $pageSize\n\t\t\tsort: $sort\n\t\t) {\n\t\t\titems {\n\t\t\t\taggregateRating {\n\t\t\t\t\tratingAverage\n\t\t\t\t\tratingCount\n\t\t\t\t\tratingValue\n\t\t\t\t}\n\t\t\t\tarticleBody\n\t\t\t\tcreator {\n\t\t\t\t\tid\n\t\t\t\t\timage\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t\tdateModified\n\t\t\t\tfriendlyUrlPath\n\t\t\t\thasValidAnswer\n\t\t\t\theadline\n\t\t\t\tid\n\t\t\t\tkeywords\n\t\t\t\tlocked\n\t\t\t\tmessageBoardSection {\n\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\ttitle\n\t\t\t\t}\n\t\t\t\tnumberOfMessageBoardMessages\n\t\t\t\tseen\n\t\t\t\tviewCount\n\t\t\t}\n\t\t\tpage\n\t\t\tpageSize\n\t\t\ttotalCount\n\t\t}\n\t}\n"]);

      _templateObject21 = function _templateObject21() {
        return data;
      };

      return data;
    }

    function _templateObject20() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardSectionMessageBoardThreads(\n\t\t$messageBoardSectionId: Long!\n\t\t$page: Int!\n\t\t$pageSize: Int!\n\t) {\n\t\tmessageBoardSectionMessageBoardThreads(\n\t\t\tmessageBoardSectionId: $messageBoardSectionId\n\t\t\tpage: $page\n\t\t\tpageSize: $pageSize\n\t\t) {\n\t\t\titems {\n\t\t\t\taggregateRating {\n\t\t\t\t\tratingAverage\n\t\t\t\t\tratingCount\n\t\t\t\t\tratingValue\n\t\t\t\t}\n\t\t\t\tarticleBody\n\t\t\t\tcreator {\n\t\t\t\t\tid\n\t\t\t\t\timage\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t\tdateModified\n\t\t\t\tfriendlyUrlPath\n\t\t\t\thasValidAnswer\n\t\t\t\theadline\n\t\t\t\tid\n\t\t\t\tkeywords\n\t\t\t\tlocked\n\t\t\t\tmessageBoardSection {\n\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\ttitle\n\t\t\t\t}\n\t\t\t\tnumberOfMessageBoardMessages\n\t\t\t\tseen\n\t\t\t\tviewCount\n\t\t\t}\n\t\t\tpage\n\t\t\tpageSize\n\t\t\ttotalCount\n\t\t}\n\t}\n"]);

      _templateObject20 = function _templateObject20() {
        return data;
      };

      return data;
    }

    function _templateObject19() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardThreads(\n\t\t$filter: String!\n\t\t$page: Int!\n\t\t$pageSize: Int!\n\t\t$search: String!\n\t\t$siteKey: String!\n\t\t$sort: String!\n\t) {\n\t\tmessageBoardThreads(\n\t\t\tfilter: $filter\n\t\t\tflatten: true\n\t\t\tpage: $page\n\t\t\tpageSize: $pageSize\n\t\t\tsearch: $search\n\t\t\tsiteKey: $siteKey\n\t\t\tsort: $sort\n\t\t) {\n\t\t\titems {\n\t\t\t\taggregateRating {\n\t\t\t\t\tratingAverage\n\t\t\t\t\tratingCount\n\t\t\t\t\tratingValue\n\t\t\t\t}\n\t\t\t\tarticleBody\n\t\t\t\tcreator {\n\t\t\t\t\tid\n\t\t\t\t\timage\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t\tdateModified\n\t\t\t\tfriendlyUrlPath\n\t\t\t\thasValidAnswer\n\t\t\t\theadline\n\t\t\t\tid\n\t\t\t\tkeywords\n\t\t\t\tlocked\n\t\t\t\tmessageBoardSection {\n\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\ttitle\n\t\t\t\t}\n\t\t\t\tnumberOfMessageBoardMessages\n\t\t\t\tseen\n\t\t\t\tviewCount\n\t\t\t}\n\t\t\tpage\n\t\t\tpageSize\n\t\t\ttotalCount\n\t\t}\n\t}\n"]);

      _templateObject19 = function _templateObject19() {
        return data;
      };

      return data;
    }

    function _templateObject18() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardThreads($siteKey: String!) {\n\t\tmessageBoardThreads(siteKey: $siteKey) {\n\t\t\tactions\n\t\t}\n\t}\n"]);

      _templateObject18 = function _templateObject18() {
        return data;
      };

      return data;
    }

    function _templateObject17() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardThreadMessageBoardMessages(\n\t\t$messageBoardThreadId: Long!\n\t\t$page: Int!\n\t\t$pageSize: Int!\n\t\t$sort: String!\n\t) {\n\t\tmessageBoardThreadMessageBoardMessages(\n\t\t\tmessageBoardThreadId: $messageBoardThreadId\n\t\t\tpage: $page\n\t\t\tpageSize: $pageSize\n\t\t\tsort: $sort\n\t\t) {\n\t\t\titems {\n\t\t\t\tactions\n\t\t\t\taggregateRating {\n\t\t\t\t\tratingAverage\n\t\t\t\t\tratingCount\n\t\t\t\t\tratingValue\n\t\t\t\t}\n\t\t\t\tarticleBody\n\t\t\t\tcreator {\n\t\t\t\t\tid\n\t\t\t\t\timage\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t\tcreatorStatistics {\n\t\t\t\t\tjoinDate\n\t\t\t\t\tlastPostDate\n\t\t\t\t\tpostsNumber\n\t\t\t\t\trank\n\t\t\t\t}\n\t\t\t\tencodingFormat\n\t\t\t\tfriendlyUrlPath\n\t\t\t\tid\n\t\t\t\tmessageBoardMessages {\n\t\t\t\t\titems {\n\t\t\t\t\t\tactions\n\t\t\t\t\t\tarticleBody\n\t\t\t\t\t\tcreator {\n\t\t\t\t\t\t\tid\n\t\t\t\t\t\t\timage\n\t\t\t\t\t\t\tname\n\t\t\t\t\t\t}\n\t\t\t\t\t\tencodingFormat\n\t\t\t\t\t\tid\n\t\t\t\t\t\tshowAsAnswer\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tmyRating {\n\t\t\t\t\tratingValue\n\t\t\t\t}\n\t\t\t\tshowAsAnswer\n\t\t\t}\n\t\t\tpageSize\n\t\t\ttotalCount\n\t\t}\n\t}\n"]);

      _templateObject17 = function _templateObject17() {
        return data;
      };

      return data;
    }

    function _templateObject16() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardThreadByFriendlyUrlPath(\n\t\t$friendlyUrlPath: String!\n\t\t$siteKey: String!\n\t) {\n\t\tmessageBoardThreadByFriendlyUrlPath(\n\t\t\tfriendlyUrlPath: $friendlyUrlPath\n\t\t\tsiteKey: $siteKey\n\t\t) {\n\t\t\tarticleBody\n\t\t\theadline\n\t\t\tid\n\t\t\tkeywords\n\t\t}\n\t}\n"]);

      _templateObject16 = function _templateObject16() {
        return data;
      };

      return data;
    }

    function _templateObject15() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardThreads($filter: String!, $siteKey: String!) {\n\t\tmessageBoardThreads(filter: $filter, flatten: true, siteKey: $siteKey) {\n\t\t\titems {\n\t\t\t\tfriendlyUrlPath\n\t\t\t\tid\n\t\t\t\tmessageBoardSection {\n\t\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\t\tparentMessageBoardSectionId\n\t\t\t\t\ttitle\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n"]);

      _templateObject15 = function _templateObject15() {
        return data;
      };

      return data;
    }

    function _templateObject14() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardThreadByFriendlyUrlPath(\n\t\t$friendlyUrlPath: String!\n\t\t$siteKey: String!\n\t) {\n\t\tmessageBoardThreadByFriendlyUrlPath(\n\t\t\tfriendlyUrlPath: $friendlyUrlPath\n\t\t\tsiteKey: $siteKey\n\t\t) {\n\t\t\tactions\n\t\t\taggregateRating {\n\t\t\t\tratingAverage\n\t\t\t\tratingCount\n\t\t\t\tratingValue\n\t\t\t}\n\t\t\tarticleBody\n\t\t\tcreator {\n\t\t\t\tid\n\t\t\t\timage\n\t\t\t\tname\n\t\t\t}\n\t\t\tcreatorStatistics {\n\t\t\t\tjoinDate\n\t\t\t\tlastPostDate\n\t\t\t\tpostsNumber\n\t\t\t\trank\n\t\t\t}\n\t\t\tdateCreated\n\t\t\tdateModified\n\t\t\tencodingFormat\n\t\t\tfriendlyUrlPath\n\t\t\theadline\n\t\t\tid\n\t\t\tkeywords\n\t\t\tlocked\n\t\t\tmessageBoardSection {\n\t\t\t\tid\n\t\t\t\tnumberOfMessageBoardSections\n\t\t\t\tparentMessageBoardSectionId\n\t\t\t\ttitle\n\t\t\t}\n\t\t\tmyRating {\n\t\t\t\tratingValue\n\t\t\t}\n\t\t\tseen\n\t\t\tsubscribed\n\t\t\tviewCount\n\t\t}\n\t}\n"]);

      _templateObject14 = function _templateObject14() {
        return data;
      };

      return data;
    }

    function _templateObject13() {
      var data = _taggedTemplateLiteral(["\n\tquery messageBoardMessageByFriendlyUrlPath(\n\t\t$friendlyUrlPath: String!\n\t\t$siteKey: String!\n\t) {\n\t\tmessageBoardMessageByFriendlyUrlPath(\n\t\t\tfriendlyUrlPath: $friendlyUrlPath\n\t\t\tsiteKey: $siteKey\n\t\t) {\n\t\t\tarticleBody\n\t\t\theadline\n\t\t\tid\n\t\t}\n\t}\n"]);

      _templateObject13 = function _templateObject13() {
        return data;
      };

      return data;
    }

    function _templateObject12() {
      var data = _taggedTemplateLiteral(["\n\tquery keywords(\n\t\t$page: Int!\n\t\t$pageSize: Int!\n\t\t$search: String\n\t\t$siteKey: String!\n\t) {\n\t\tkeywords(\n\t\t\tpage: $page\n\t\t\tpageSize: $pageSize\n\t\t\tsearch: $search\n\t\t\tsiteKey: $siteKey\n\t\t\tsort: \"dateCreated:desc\"\n\t\t) {\n\t\t\titems {\n\t\t\t\tid\n\t\t\t\tdateCreated\n\t\t\t\tname\n\t\t\t}\n\t\t\tlastPage\n\t\t\tpage\n\t\t\tpageSize\n\t\t\ttotalCount\n\t\t}\n\t}\n"]);

      _templateObject12 = function _templateObject12() {
        return data;
      };

      return data;
    }

    function _templateObject11() {
      var data = _taggedTemplateLiteral(["\n\tquery keywordsRanked(\n\t\t$page: Int!\n\t\t$pageSize: Int!\n\t\t$search: String\n\t\t$siteKey: String!\n\t) {\n\t\tkeywordsRanked(\n\t\t\tpage: $page\n\t\t\tpageSize: $pageSize\n\t\t\tsearch: $search\n\t\t\tsiteKey: $siteKey\n\t\t) {\n\t\t\titems {\n\t\t\t\tid\n\t\t\t\tkeywordUsageCount\n\t\t\t\tname\n\t\t\t}\n\t\t\tlastPage\n\t\t\tpage\n\t\t\tpageSize\n\t\t\ttotalCount\n\t\t}\n\t}\n"]);

      _templateObject11 = function _templateObject11() {
        return data;
      };

      return data;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _templateObject10() {
      var data = _taggedTemplateLiteral(["\n\tmutation deleteMessageBoardThread($messageBoardThreadId: Long!) {\n\t\tdeleteMessageBoardThread(messageBoardThreadId: $messageBoardThreadId)\n\t}\n"]);

      _templateObject10 = function _templateObject10() {
        return data;
      };

      return data;
    }

    function _templateObject9() {
      var data = _taggedTemplateLiteral(["\n\tmutation deleteMessageBoardMessage($messageBoardMessageId: Long!) {\n\t\tdeleteMessageBoardMessage(messageBoardMessageId: $messageBoardMessageId)\n\t}\n"]);

      _templateObject9 = function _templateObject9() {
        return data;
      };

      return data;
    }

    function _templateObject8() {
      var data = _taggedTemplateLiteral(["\n\tmutation createMessageBoardThreadMyRating(\n\t\t$messageBoardThreadId: Long!\n\t\t$ratingValue: Float!\n\t) {\n\t\tcreateMessageBoardThreadMyRating(\n\t\t\tmessageBoardThreadId: $messageBoardThreadId\n\t\t\trating: {ratingValue: $ratingValue}\n\t\t) {\n\t\t\tid\n\t\t\tratingValue\n\t\t}\n\t}\n"]);

      _templateObject8 = function _templateObject8() {
        return data;
      };

      return data;
    }

    function _templateObject7() {
      var data = _taggedTemplateLiteral(["\n\tmutation createMessageBoardMessageMyRating(\n\t\t$messageBoardMessageId: Long!\n\t\t$ratingValue: Float!\n\t) {\n\t\tcreateMessageBoardMessageMyRating(\n\t\t\tmessageBoardMessageId: $messageBoardMessageId\n\t\t\trating: {ratingValue: $ratingValue}\n\t\t) {\n\t\t\tid\n\t\t\tratingValue\n\t\t}\n\t}\n"]);

      _templateObject7 = function _templateObject7() {
        return data;
      };

      return data;
    }

    function _templateObject6() {
      var data = _taggedTemplateLiteral(["\n\tmutation createSiteMessageBoardSection(\n\t\t$description: String\n\t\t$siteKey: String!\n\t\t$title: String!\n\t) {\n\t\tcreateSiteMessageBoardSection(\n\t\t\tsiteKey: $siteKey\n\t\t\tmessageBoardSection: {\n\t\t\t\tdescription: $description\n\t\t\t\ttitle: $title\n\t\t\t\tviewableBy: ANYONE\n\t\t\t}\n\t\t) {\n\t\t\tid\n\t\t\ttitle\n\t\t}\n\t}\n"]);

      _templateObject6 = function _templateObject6() {
        return data;
      };

      return data;
    }

    function _templateObject5() {
      var data = _taggedTemplateLiteral(["\n\tmutation createMessageBoardSectionMessageBoardSection(\n\t\t$description: String\n\t\t$parentMessageBoardSectionId: Long!\n\t\t$title: String!\n\t) {\n\t\tcreateMessageBoardSectionMessageBoardSection(\n\t\t\tparentMessageBoardSectionId: $parentMessageBoardSectionId\n\t\t\tmessageBoardSection: {\n\t\t\t\tdescription: $description\n\t\t\t\ttitle: $title\n\t\t\t\tviewableBy: ANYONE\n\t\t\t}\n\t\t) {\n\t\t\tid\n\t\t\ttitle\n\t\t}\n\t}\n"]);

      _templateObject5 = function _templateObject5() {
        return data;
      };

      return data;
    }

    function _templateObject4() {
      var data = _taggedTemplateLiteral(["\n\tmutation createMessageBoardSectionMessageBoardThread(\n\t\t$messageBoardSectionId: Long!\n\t\t$articleBody: String!\n\t\t$headline: String!\n\t\t$keywords: [String]\n\t) {\n\t\tcreateMessageBoardSectionMessageBoardThread(\n\t\t\tmessageBoardSectionId: $messageBoardSectionId\n\t\t\tmessageBoardThread: {\n\t\t\t\tarticleBody: $articleBody\n\t\t\t\tencodingFormat: \"html\"\n\t\t\t\theadline: $headline\n\t\t\t\tkeywords: $keywords\n\t\t\t\tshowAsQuestion: true\n\t\t\t\tsubscribed: true\n\t\t\t\tviewableBy: ANYONE\n\t\t\t}\n\t\t) {\n\t\t\tarticleBody\n\t\t\theadline\n\t\t\tkeywords\n\t\t\tshowAsQuestion\n\t\t}\n\t}\n"]);

      _templateObject4 = function _templateObject4() {
        return data;
      };

      return data;
    }

    function _templateObject3() {
      var data = _taggedTemplateLiteral(["\n\tmutation createSiteMessageBoardThread(\n\t\t$articleBody: String!\n\t\t$headline: String!\n\t\t$keywords: [String]\n\t\t$siteKey: String!\n\t) {\n\t\tcreateSiteMessageBoardThread(\n\t\t\tsiteKey: $siteKey\n\t\t\tmessageBoardThread: {\n\t\t\t\tarticleBody: $articleBody\n\t\t\t\tencodingFormat: \"html\"\n\t\t\t\theadline: $headline\n\t\t\t\tkeywords: $keywords\n\t\t\t\tshowAsQuestion: true\n\t\t\t\tsubscribed: true\n\t\t\t\tviewableBy: ANYONE\n\t\t\t}\n\t\t) {\n\t\t\tarticleBody\n\t\t\theadline\n\t\t\tkeywords\n\t\t\tshowAsQuestion\n\t\t}\n\t}\n"]);

      _templateObject3 = function _templateObject3() {
        return data;
      };

      return data;
    }

    function _templateObject2() {
      var data = _taggedTemplateLiteral(["\n\tmutation createMessageBoardMessageMessageBoardMessage(\n\t\t$articleBody: String!\n\t\t$parentMessageBoardMessageId: Long!\n\t) {\n\t\tcreateMessageBoardMessageMessageBoardMessage(\n\t\t\tmessageBoardMessage: {\n\t\t\t\tarticleBody: $articleBody\n\t\t\t\tencodingFormat: \"html\"\n\t\t\t\tviewableBy: ANYONE\n\t\t\t}\n\t\t\tparentMessageBoardMessageId: $parentMessageBoardMessageId\n\t\t) {\n\t\t\tactions\n\t\t\tarticleBody\n\t\t\tcreator {\n\t\t\t\tname\n\t\t\t}\n\t\t\tid\n\t\t}\n\t}\n"]);

      _templateObject2 = function _templateObject2() {
        return data;
      };

      return data;
    }

    function _templateObject() {
      var data = _taggedTemplateLiteral(["\n\tmutation createMessageBoardThreadMessageBoardMessage(\n\t\t$articleBody: String!\n\t\t$messageBoardThreadId: Long!\n\t) {\n\t\tcreateMessageBoardThreadMessageBoardMessage(\n\t\t\tmessageBoardMessage: {\n\t\t\t\tarticleBody: $articleBody\n\t\t\t\tencodingFormat: \"html\"\n\t\t\t\tviewableBy: ANYONE\n\t\t\t}\n\t\t\tmessageBoardThreadId: $messageBoardThreadId\n\t\t) {\n\t\t\tviewableBy\n\t\t}\n\t}\n"]);

      _templateObject = function _templateObject() {
        return data;
      };

      return data;
    }

    function _taggedTemplateLiteral(strings, raw) {
      if (!raw) {
        raw = strings.slice(0);
      }return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } }));
    }

    var HEADERS = {
      Accept: 'application/json',
      'Accept-Language': Liferay.ThemeDisplay.getBCP47LanguageId(),
      'Content-Type': 'text/plain; charset=utf-8'
    };
    var client = new _client.ApolloClient({
      cache: new _client.InMemoryCache(),
      defaultOptions: {
        query: {
          errorPolicy: 'all'
        }
      },
      link: new _client.HttpLink({
        credentials: 'include',
        fetch: _frontendJsWeb.fetch,
        headers: HEADERS,
        uri: '/o/graphql'
      })
    });
    exports.client = client;
    var createAnswerQuery = (0, _client.gql)(_templateObject());
    exports.createAnswerQuery = createAnswerQuery;
    var createCommentQuery = (0, _client.gql)(_templateObject2());
    exports.createCommentQuery = createCommentQuery;
    var createQuestionInRootQuery = (0, _client.gql)(_templateObject3());
    exports.createQuestionInRootQuery = createQuestionInRootQuery;
    var createQuestionInASectionQuery = (0, _client.gql)(_templateObject4());
    exports.createQuestionInASectionQuery = createQuestionInASectionQuery;
    var createSubTopicQuery = (0, _client.gql)(_templateObject5());
    exports.createSubTopicQuery = createSubTopicQuery;
    var createTopicQuery = (0, _client.gql)(_templateObject6());
    exports.createTopicQuery = createTopicQuery;
    var createVoteMessageQuery = (0, _client.gql)(_templateObject7());
    exports.createVoteMessageQuery = createVoteMessageQuery;
    var createVoteThreadQuery = (0, _client.gql)(_templateObject8());
    exports.createVoteThreadQuery = createVoteThreadQuery;
    var deleteMessageQuery = (0, _client.gql)(_templateObject9());
    exports.deleteMessageQuery = deleteMessageQuery;
    var deleteMessageBoardThreadQuery = (0, _client.gql)(_templateObject10());
    exports.deleteMessageBoardThreadQuery = deleteMessageBoardThreadQuery;

    var getTags = function getTags(orderBy) {
      var page = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      var pageSize = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 30;
      var search = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var siteKey = arguments.length > 4 ? arguments[4] : undefined;

      if (orderBy === 'latest-created') {
        return client.query({
          query: getTagsOrderByDateCreatedQuery,
          variables: {
            page: page,
            pageSize: pageSize,
            search: search,
            siteKey: siteKey
          }
        }).then(function (result) {
          return _objectSpread({}, result, {
            data: result.data.keywords
          });
        });
      }

      return client.query({
        query: getTagsOrderByNumberOfUsagesQuery,
        variables: {
          page: page,
          pageSize: pageSize,
          search: search,
          siteKey: siteKey
        }
      }).then(function (result) {
        return _objectSpread({}, result, {
          data: result.data.keywordsRanked
        });
      });
    };

    exports.getTags = getTags;
    var getTagsOrderByNumberOfUsagesQuery = (0, _client.gql)(_templateObject11());
    exports.getTagsOrderByNumberOfUsagesQuery = getTagsOrderByNumberOfUsagesQuery;
    var getTagsOrderByDateCreatedQuery = (0, _client.gql)(_templateObject12());
    exports.getTagsOrderByDateCreatedQuery = getTagsOrderByDateCreatedQuery;
    var getMessageQuery = (0, _client.gql)(_templateObject13());
    exports.getMessageQuery = getMessageQuery;
    var getThreadQuery = (0, _client.gql)(_templateObject14());
    exports.getThreadQuery = getThreadQuery;
    var getMessageBoardThreadByIdQuery = (0, _client.gql)(_templateObject15());
    exports.getMessageBoardThreadByIdQuery = getMessageBoardThreadByIdQuery;
    var getThreadContentQuery = (0, _client.gql)(_templateObject16());
    exports.getThreadContentQuery = getThreadContentQuery;
    var getMessagesQuery = (0, _client.gql)(_templateObject17());
    exports.getMessagesQuery = getMessagesQuery;
    var hasListPermissionsQuery = (0, _client.gql)(_templateObject18());
    exports.hasListPermissionsQuery = hasListPermissionsQuery;

    var getQuestionThreads = function getQuestionThreads() {
      var creatorId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      var filter = arguments.length > 1 ? arguments[1] : undefined;
      var keywords = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
      var page = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
      var pageSize = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 30;
      var search = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : '';
      var section = arguments.length > 6 ? arguments[6] : undefined;
      var siteKey = arguments.length > 7 ? arguments[7] : undefined;

      if (filter === 'latest-edited') {
        return getThreads(creatorId, keywords, page, pageSize, search, section, siteKey, 'dateModified:desc');
      } else if (filter === 'week') {
        var date = new Date();
        date.setDate(date.getDate() - 7);
        return getRankedThreads(date, page, pageSize, section);
      } else if (filter === 'month') {
        var _date = new Date();

        _date.setDate(_date.getDate() - 31);

        return getRankedThreads(_date, page, pageSize, section);
      } else if (filter === 'most-voted') {
        return getRankedThreads(null, page, pageSize, section);
      }

      return getThreads(creatorId, keywords, page, pageSize, search, section, siteKey);
    };

    exports.getQuestionThreads = getQuestionThreads;

    var getThreads = function getThreads() {
      var creatorId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      var keywords = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      var page = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
      var pageSize = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 30;
      var search = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
      var section = arguments.length > 5 ? arguments[5] : undefined;
      var siteKey = arguments.length > 6 ? arguments[6] : undefined;
      var sort = arguments.length > 7 ? arguments[7] : undefined;

      if (!search && !keywords && !creatorId && !sort && !section.messageBoardSections.items.length && section.id !== 0) {
        return client.query({
          context: {
            uri: '/o/graphql?restrictFields=actions'
          },
          query: getSectionThreadsQuery,
          variables: {
            messageBoardSectionId: section.id,
            page: page,
            pageSize: pageSize
          }
        }).then(function (result) {
          return _objectSpread({}, result, {
            data: result.data.messageBoardSectionMessageBoardThreads
          });
        });
      }

      var filter = '';

      if (section && section.id) {
        filter = "(messageBoardSectionId eq ".concat(section.id, " ");

        for (var i = 0; i < section.messageBoardSections.items.length; i++) {
          filter += "or messageBoardSectionId eq ".concat(section.messageBoardSections.items[i].id, " ");
        }

        filter += ')';
      }

      if (keywords) {
        filter += "".concat(section && section.id && ' and ' || '', "keywords/any(x:x eq '").concat(keywords, "')");
      } else if (creatorId) {
        filter += " and creator/id eq ".concat(creatorId);
      }

      sort = sort || 'dateCreated:desc';
      return client.query({
        context: {
          uri: '/o/graphql?restrictFields=actions'
        },
        query: getThreadsQuery,
        variables: {
          filter: filter,
          page: page,
          pageSize: pageSize,
          search: search,
          siteKey: siteKey,
          sort: sort
        }
      }).then(function (result) {
        return _objectSpread({}, result, {
          data: result.data.messageBoardThreads
        });
      });
    };

    exports.getThreads = getThreads;

    var getSectionsByRootSection = function getSectionsByRootSection(siteKey, sectionTitle) {
      if (!sectionTitle || sectionTitle === '0') {
        return client.query({
          query: getSectionsQuery,
          variables: {
            siteKey: siteKey
          }
        }).then(function (result) {
          return _objectSpread({}, result, {
            data: result.data.messageBoardSections
          });
        });
      }

      return getSectionBySectionTitle(siteKey, sectionTitle).then(function (result) {
        return _objectSpread({}, result, {
          data: result.messageBoardSections
        });
      });
    };

    exports.getSectionsByRootSection = getSectionsByRootSection;

    var getSectionByRootSection = function getSectionByRootSection(siteKey) {
      return client.query({
        query: getSectionsQuery,
        variables: {
          siteKey: siteKey
        }
      }).then(function (_ref) {
        var messageBoardSections = _ref.data.messageBoardSections;
        return {
          actions: messageBoardSections.actions,
          id: 0,
          messageBoardSections: messageBoardSections,
          numberOfMessageBoardSections: messageBoardSections && messageBoardSections.items && messageBoardSections.items.length
        };
      });
    };

    exports.getSectionByRootSection = getSectionByRootSection;

    var getSectionBySectionTitle = function getSectionBySectionTitle(siteKey, sectionTitle) {
      return client.query({
        query: getSectionBySectionTitleQuery,
        variables: {
          filter: "title eq '".concat(sectionTitle, "' or id eq '").concat(sectionTitle, "'"),
          siteKey: siteKey
        }
      }).then(function (_ref2) {
        var data = _ref2.data;
        return data.messageBoardSections.items[0];
      });
    };

    exports.getSectionBySectionTitle = getSectionBySectionTitle;
    var getThreadsQuery = (0, _client.gql)(_templateObject19());
    exports.getThreadsQuery = getThreadsQuery;
    var getSectionThreadsQuery = (0, _client.gql)(_templateObject20());
    exports.getSectionThreadsQuery = getSectionThreadsQuery;

    var getRankedThreads = function getRankedThreads(dateModified) {
      var page = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      var pageSize = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 20;
      var section = arguments.length > 3 ? arguments[3] : undefined;
      var sort = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
      return client.query({
        query: getRankedThreadsQuery,
        variables: {
          dateModified: dateModified && dateModified.toISOString(),
          messageBoardSectionId: section.id,
          page: page,
          pageSize: pageSize,
          sort: sort
        }
      }).then(function (result) {
        return _objectSpread({}, result, {
          data: result.data.messageBoardThreadsRanked
        });
      });
    };

    exports.getRankedThreads = getRankedThreads;
    var getRankedThreadsQuery = (0, _client.gql)(_templateObject21());
    exports.getRankedThreadsQuery = getRankedThreadsQuery;
    var getRelatedThreadsQuery = (0, _client.gql)(_templateObject22());
    exports.getRelatedThreadsQuery = getRelatedThreadsQuery;
    var getSectionBySectionTitleQuery = (0, _client.gql)(_templateObject23());
    exports.getSectionBySectionTitleQuery = getSectionBySectionTitleQuery;
    var getSectionQuery = (0, _client.gql)(_templateObject24());
    exports.getSectionQuery = getSectionQuery;
    var getSectionsQuery = (0, _client.gql)(_templateObject25());
    exports.getSectionsQuery = getSectionsQuery;
    var getUserActivityQuery = (0, _client.gql)(_templateObject26());
    exports.getUserActivityQuery = getUserActivityQuery;
    var markAsAnswerMessageBoardMessageQuery = (0, _client.gql)(_templateObject27());
    exports.markAsAnswerMessageBoardMessageQuery = markAsAnswerMessageBoardMessageQuery;
    var updateMessageQuery = (0, _client.gql)(_templateObject28());
    exports.updateMessageQuery = updateMessageQuery;
    var updateThreadQuery = (0, _client.gql)(_templateObject29());
    exports.updateThreadQuery = updateThreadQuery;
    var subscribeQuery = (0, _client.gql)(_templateObject30());
    exports.subscribeQuery = subscribeQuery;
    var unsubscribeQuery = (0, _client.gql)(_templateObject31());
    exports.unsubscribeQuery = unsubscribeQuery;
    var subscribeSectionQuery = (0, _client.gql)(_templateObject32());
    exports.subscribeSectionQuery = subscribeSectionQuery;
    var unsubscribeSectionQuery = (0, _client.gql)(_templateObject33());
    exports.unsubscribeSectionQuery = unsubscribeSectionQuery;
    var getSubscriptionsQuery = (0, _client.gql)(_templateObject34());
    exports.getSubscriptionsQuery = getSubscriptionsQuery;
    var unsubscribeMyUserAccountQuery = (0, _client.gql)(_templateObject35());
    exports.unsubscribeMyUserAccountQuery = unsubscribeMyUserAccountQuery;
    //# sourceMappingURL=client.es.js.map
  }
});
//# sourceMappingURL=client.es.js.map