Liferay.Loader.define("questions-web@1.0.52/js/utils/utils.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-react-web$react', './lang.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.dateToInternationalHuman = dateToInternationalHuman;
    exports.dateToBriefInternationalHuman = dateToBriefInternationalHuman;
    exports.deleteCacheVariables = deleteCacheVariables;
    exports.timeDifference = timeDifference;
    exports.useDebounceCallback = useDebounceCallback;
    exports.normalizeRating = normalizeRating;
    exports.normalize = normalize;
    exports.stringToSlug = stringToSlug;
    exports.slugToText = slugToText;
    exports.historyPushWithSlug = historyPushWithSlug;
    exports.stripHTML = stripHTML;
    exports.getFullPath = getFullPath;
    exports.getBasePath = getBasePath;
    exports.getContextLink = getContextLink;

    var _frontendJsWeb = require("frontend-js-web");

    var _react = require("frontend-js-react-web$react");

    var _lang = _interopRequireDefault(require("./lang.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function dateToInternationalHuman(ISOString) {
      var localeKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : navigator.language;
      var date = new Date(ISOString);
      var options = {
        day: 'numeric',
        hour: '2-digit',
        minute: '2-digit',
        month: 'short'
      };

      if (date.getFullYear() !== new Date().getFullYear()) {
        options.year = 'numeric';
      }

      var intl = new Intl.DateTimeFormat(localeKey, options);
      return intl.format(date);
    }

    function dateToBriefInternationalHuman(ISOString) {
      var localeKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : navigator.language;
      var date = new Date(ISOString);
      var intl = new Intl.DateTimeFormat(localeKey, {
        day: '2-digit',
        month: '2-digit',
        year: '2-digit'
      });
      return intl.format(date);
    }

    function deleteCacheVariables(cache, parameter) {
      Object.keys(cache.data.data).forEach(function (key) {
        return key.match("^".concat(parameter)) && cache.data["delete"](key);
      });
    }

    function timeDifference(previous) {
      var current = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new Date();
      var msPerMinute = 60 * 1000;
      var msPerHour = msPerMinute * 60;
      var msPerDay = msPerHour * 24;
      var msPerMonth = msPerDay * 30;
      var msPerYear = msPerDay * 365;
      var elapsed = current - new Date(previous);

      if (elapsed < msPerMinute) {
        return _lang["default"].sub(Liferay.Language.get('asked-x-seconds-ago-by'), [Math.round(elapsed / 1000)]);
      } else if (elapsed < msPerHour) {
        return _lang["default"].sub(Liferay.Language.get('asked-x-minutes-ago-by'), [Math.round(elapsed / msPerMinute)]);
      } else if (elapsed < msPerDay) {
        return _lang["default"].sub(Liferay.Language.get('asked-x-hours-ago-by'), [Math.round(elapsed / msPerHour)]);
      } else if (elapsed < msPerMonth) {
        return _lang["default"].sub(Liferay.Language.get('asked-x-days-ago-by'), [Math.round(elapsed / msPerDay)]);
      } else if (elapsed < msPerYear) {
        return _lang["default"].sub(Liferay.Language.get('asked-x-months-ago-by'), [Math.round(elapsed / msPerMonth)]);
      } else {
        return _lang["default"].sub(Liferay.Language.get('asked-x-years-ago-by'), [Math.round(elapsed / msPerYear)]);
      }
    }

    function useDebounceCallback(callback, milliseconds) {
      var callbackRef = (0, _react.useRef)((0, _frontendJsWeb.debounce)(callback, milliseconds));
      return [callbackRef.current, function () {
        return (0, _frontendJsWeb.cancelDebounce)(callbackRef.current);
      }];
    }

    function normalizeRating(aggregateRating) {
      return aggregateRating && Math.trunc(aggregateRating.ratingCount * normalize(aggregateRating.ratingAverage));
    }

    function normalize(ratingValue) {
      return ratingValue * 2 - 1;
    }

    function stringToSlug(text) {
      var whiteSpaces = /\s+/g;
      return text.replace(whiteSpaces, '-').toLowerCase();
    }

    function slugToText(slug) {
      var hyphens = /-+/g;
      return slug.replace(hyphens, ' ').toLowerCase();
    }

    function historyPushWithSlug(push) {
      return function (url) {
        return push(stringToSlug(url));
      };
    }

    function stripHTML(text) {
      if (!text) {
        return '';
      }

      var htmlTags = /<([^>]+>)/g;

      var newLines = /\r?\n|\r/g;
      return text.replace(htmlTags, '').replace('&nbsp;', ' ').replace(newLines, '') || '';
    }

    function getFullPath() {
      return window.location.href.substring(0, window.location.href.indexOf('#'));
    }

    function getBasePath() {
      return window.location.href.substring(window.location.origin.length, window.location.href.indexOf('#'));
    }

    function getContextLink(url) {
      return {
        headers: {
          Link: "".concat(getFullPath(), "?redirectTo=/%23/questions/").concat(url, "/")
        }
      };
    }
    //# sourceMappingURL=utils.es.js.map
  }
});
//# sourceMappingURL=utils.es.js.map