Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/ApolloClient', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { __assign } from 'tslib';
        import { invariant, InvariantError } from 'ts-invariant';
        import { ApolloLink } from './link/core/ApolloLink.js';
        import { execute } from './link/core/execute.js';
        import { LocalState } from './core/LocalState.js';
        import { QueryManager } from './core/QueryManager.js';
        import { version } from './version.js';
        import { HttpLink } from './link/http/HttpLink.js';

        var hasSuggestedDevtools = false;
        var ApolloClient = function () {
            function ApolloClient(options) {
                var _this = this;
                this.defaultOptions = {};
                this.resetStoreCallbacks = [];
                this.clearStoreCallbacks = [];
                var uri = options.uri,
                    credentials = options.credentials,
                    headers = options.headers,
                    cache = options.cache,
                    _a = options.ssrMode,
                    ssrMode = _a === void 0 ? false : _a,
                    _b = options.ssrForceFetchDelay,
                    ssrForceFetchDelay = _b === void 0 ? 0 : _b,
                    connectToDevTools = options.connectToDevTools,
                    _c = options.queryDeduplication,
                    queryDeduplication = _c === void 0 ? true : _c,
                    defaultOptions = options.defaultOptions,
                    _d = options.assumeImmutableResults,
                    assumeImmutableResults = _d === void 0 ? false : _d,
                    resolvers = options.resolvers,
                    typeDefs = options.typeDefs,
                    fragmentMatcher = options.fragmentMatcher,
                    clientAwarenessName = options.name,
                    clientAwarenessVersion = options.version;
                var link = options.link;
                if (!link) {
                    link = uri ? new HttpLink({ uri: uri, credentials: credentials, headers: headers }) : ApolloLink.empty();
                }
                if (!cache) {
                    throw new InvariantError(1);
                }
                this.link = link;
                this.cache = cache;
                this.disableNetworkFetches = ssrMode || ssrForceFetchDelay > 0;
                this.queryDeduplication = queryDeduplication;
                this.defaultOptions = defaultOptions || {};
                this.typeDefs = typeDefs;
                if (ssrForceFetchDelay) {
                    setTimeout(function () {
                        return _this.disableNetworkFetches = false;
                    }, ssrForceFetchDelay);
                }
                this.watchQuery = this.watchQuery.bind(this);
                this.query = this.query.bind(this);
                this.mutate = this.mutate.bind(this);
                this.resetStore = this.resetStore.bind(this);
                this.reFetchObservableQueries = this.reFetchObservableQueries.bind(this);
                var defaultConnectToDevTools = false && typeof window !== 'undefined' && !window.__APOLLO_CLIENT__;
                if (typeof connectToDevTools === 'undefined' ? defaultConnectToDevTools : connectToDevTools && typeof window !== 'undefined') {
                    window.__APOLLO_CLIENT__ = this;
                }

                this.version = version;
                this.localState = new LocalState({
                    cache: cache,
                    client: this,
                    resolvers: resolvers,
                    fragmentMatcher: fragmentMatcher
                });
                this.queryManager = new QueryManager({
                    cache: this.cache,
                    link: this.link,
                    queryDeduplication: queryDeduplication,
                    ssrMode: ssrMode,
                    clientAwareness: {
                        name: clientAwarenessName,
                        version: clientAwarenessVersion
                    },
                    localState: this.localState,
                    assumeImmutableResults: assumeImmutableResults,
                    onBroadcast: function () {
                        if (_this.devToolsHookCb) {
                            _this.devToolsHookCb({
                                action: {},
                                state: {
                                    queries: _this.queryManager.getQueryStore(),
                                    mutations: _this.queryManager.mutationStore.getStore()
                                },
                                dataWithOptimisticResults: _this.cache.extract(true)
                            });
                        }
                    }
                });
            }
            ApolloClient.prototype.stop = function () {
                this.queryManager.stop();
            };
            ApolloClient.prototype.watchQuery = function (options) {
                if (this.defaultOptions.watchQuery) {
                    options = __assign(__assign({}, this.defaultOptions.watchQuery), options);
                }
                if (this.disableNetworkFetches && (options.fetchPolicy === 'network-only' || options.fetchPolicy === 'cache-and-network')) {
                    options = __assign(__assign({}, options), { fetchPolicy: 'cache-first' });
                }
                return this.queryManager.watchQuery(options);
            };
            ApolloClient.prototype.query = function (options) {
                if (this.defaultOptions.query) {
                    options = __assign(__assign({}, this.defaultOptions.query), options);
                }
                invariant(options.fetchPolicy !== 'cache-and-network', 2);
                if (this.disableNetworkFetches && options.fetchPolicy === 'network-only') {
                    options = __assign(__assign({}, options), { fetchPolicy: 'cache-first' });
                }
                return this.queryManager.query(options);
            };
            ApolloClient.prototype.mutate = function (options) {
                if (this.defaultOptions.mutate) {
                    options = __assign(__assign({}, this.defaultOptions.mutate), options);
                }
                return this.queryManager.mutate(options);
            };
            ApolloClient.prototype.subscribe = function (options) {
                return this.queryManager.startGraphQLSubscription(options);
            };
            ApolloClient.prototype.readQuery = function (options, optimistic) {
                if (optimistic === void 0) {
                    optimistic = false;
                }
                return this.cache.readQuery(options, optimistic);
            };
            ApolloClient.prototype.readFragment = function (options, optimistic) {
                if (optimistic === void 0) {
                    optimistic = false;
                }
                return this.cache.readFragment(options, optimistic);
            };
            ApolloClient.prototype.writeQuery = function (options) {
                var result = this.cache.writeQuery(options);
                this.queryManager.broadcastQueries();
                return result;
            };
            ApolloClient.prototype.writeFragment = function (options) {
                var result = this.cache.writeFragment(options);
                this.queryManager.broadcastQueries();
                return result;
            };
            ApolloClient.prototype.__actionHookForDevTools = function (cb) {
                this.devToolsHookCb = cb;
            };
            ApolloClient.prototype.__requestRaw = function (payload) {
                return execute(this.link, payload);
            };
            ApolloClient.prototype.resetStore = function () {
                var _this = this;
                return Promise.resolve().then(function () {
                    return _this.queryManager.clearStore();
                }).then(function () {
                    return Promise.all(_this.resetStoreCallbacks.map(function (fn) {
                        return fn();
                    }));
                }).then(function () {
                    return _this.reFetchObservableQueries();
                });
            };
            ApolloClient.prototype.clearStore = function () {
                var _this = this;
                return Promise.resolve().then(function () {
                    return _this.queryManager.clearStore();
                }).then(function () {
                    return Promise.all(_this.clearStoreCallbacks.map(function (fn) {
                        return fn();
                    }));
                });
            };
            ApolloClient.prototype.onResetStore = function (cb) {
                var _this = this;
                this.resetStoreCallbacks.push(cb);
                return function () {
                    _this.resetStoreCallbacks = _this.resetStoreCallbacks.filter(function (c) {
                        return c !== cb;
                    });
                };
            };
            ApolloClient.prototype.onClearStore = function (cb) {
                var _this = this;
                this.clearStoreCallbacks.push(cb);
                return function () {
                    _this.clearStoreCallbacks = _this.clearStoreCallbacks.filter(function (c) {
                        return c !== cb;
                    });
                };
            };
            ApolloClient.prototype.reFetchObservableQueries = function (includeStandby) {
                return this.queryManager.reFetchObservableQueries(includeStandby);
            };
            ApolloClient.prototype.extract = function (optimistic) {
                return this.cache.extract(optimistic);
            };
            ApolloClient.prototype.restore = function (serializedState) {
                return this.cache.restore(serializedState);
            };
            ApolloClient.prototype.addResolvers = function (resolvers) {
                this.localState.addResolvers(resolvers);
            };
            ApolloClient.prototype.setResolvers = function (resolvers) {
                this.localState.setResolvers(resolvers);
            };
            ApolloClient.prototype.getResolvers = function () {
                return this.localState.getResolvers();
            };
            ApolloClient.prototype.setLocalStateFragmentMatcher = function (fragmentMatcher) {
                this.localState.setFragmentMatcher(fragmentMatcher);
            };
            return ApolloClient;
        }();

        export { ApolloClient };
        //# sourceMappingURL=ApolloClient.js.map
    }
});
//# sourceMappingURL=ApolloClient.js.map