import { DataProxy } from './DataProxy';
export declare namespace Cache {
    type WatchCallback = (diff: Cache.DiffResult<any>) => void;
    interface ReadOptions<TVariables = any> extends DataProxy.Query<TVariables> {
        rootId?: string;
        previousResult?: any;
        optimistic: boolean;
    }
    interface WriteOptions<TResult = any, TVariables = any> extends DataProxy.Query<TVariables> {
        dataId: string;
        result: TResult;
        broadcast?: boolean;
    }
    interface DiffOptions extends ReadOptions {
        returnPartialData?: boolean;
    }
    interface WatchOptions extends ReadOptions {
        immediate?: boolean;
        callback: WatchCallback;
    }
    interface EvictOptions {
        id: string;
        fieldName?: string;
        args?: Record<string, any>;
        broadcast?: boolean;
    }
    export import DiffResult = DataProxy.DiffResult;
    export import WriteQueryOptions = DataProxy.WriteQueryOptions;
    export import WriteFragmentOptions = DataProxy.WriteFragmentOptions;
    export import Fragment = DataProxy.Fragment;
}
//# sourceMappingURL=Cache.d.ts.map